/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractClass;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassUtil;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.chooseContainer.ChooseContainerUtilKt;
import org.jetbrains.kotlin.idea.refactoring.chooseContainer.SeparateFileWrapper;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.KotlinExtractSuperConflictSearcher;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.KotlinExtractSuperclassHandler;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.ui.KotlinExtractSuperDialogBase;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\u0007\u001a\u00020\u00042\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\u000bJ+\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002\u00a2\u0006\u0002\u0010\u0016J\u001a\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u001a\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0004J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J\u0018\u0010#\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\nH$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/KotlinExtractSuperHandlerBase;", "Lcom/intellij/refactoring/RefactoringActionHandler;", "Lcom/intellij/refactoring/lang/ElementsHandler;", "isExtractInterface", "", "<init>", "(Z)V", "isEnabledOnElements", "elements", "", "Lcom/intellij/psi/PsiElement;", "([Lcom/intellij/psi/PsiElement;)Z", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "checkClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "doInvoke", "targetParent", "selectElements", "checkConflicts", "originalClass", "dialog", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/ui/KotlinExtractSuperDialogBase;", "getErrorMessage", "", "createDialog", "kotlin.refactorings.common"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nKotlinExtractSuperHandlerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinExtractSuperHandlerBase.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/KotlinExtractSuperHandlerBase\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,114:1\n253#2:115\n253#2:116\n*S KotlinDebug\n*F\n+ 1 KotlinExtractSuperHandlerBase.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/KotlinExtractSuperHandlerBase\n*L\n39#1:115\n48#1:116\n*E\n"})
public abstract class KotlinExtractSuperHandlerBase
implements RefactoringActionHandler,
ElementsHandler {
    private final boolean isExtractInterface;

    public KotlinExtractSuperHandlerBase(boolean isExtractInterface) {
        this.isExtractInterface = isExtractInterface;
    }

    public boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        return ArraysKt.singleOrNull((Object[])elements) instanceof KtClassOrObject;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @Nullable DataContext dataContext) {
        PsiElement element;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement == null) {
            return;
        }
        PsiElement $this$getNonStrictParentOfType$iv = element = psiElement;
        boolean $i$f$getNonStrictParentOfType = false;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false);
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject klass = ktClassOrObject;
        if (!this.checkClass(klass, editor)) {
            return;
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        this.selectElements(klass, editor);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        PsiElement psiElement;
        Editor editor;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
                if (dataContext == null) {
                    return;
                }
                editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                psiElement = PsiTreeUtil.findCommonParent((PsiElement[])Arrays.copyOf(elements, elements.length));
                if (psiElement == null) break block5;
                PsiElement $this$getNonStrictParentOfType$iv = psiElement;
                boolean $i$f$getNonStrictParentOfType = false;
                psiElement = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false);
                if (psiElement != null) break block6;
            }
            return;
        }
        PsiElement klass = psiElement;
        if (!this.checkClass((KtClassOrObject)klass, editor)) {
            return;
        }
        this.selectElements((KtClassOrObject)klass, editor);
    }

    private final boolean checkClass(KtClassOrObject klass, Editor editor) {
        Project project = klass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)((PsiElement)klass))) {
            return false;
        }
        String errorMessage = this.getErrorMessage(klass);
        if (errorMessage != null) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)errorMessage), (String)KotlinExtractSuperclassHandler.INSTANCE.getREFACTORING_NAME(), (String)"refactoring.extractSuperclass");
            return false;
        }
        return true;
    }

    private final void doInvoke(KtClassOrObject klass, PsiElement targetParent) {
        this.createDialog(klass, targetParent).show();
    }

    private final void selectElements(KtClassOrObject klass, Editor editor) {
        Collection collection = KotlinCommonRefactoringUtilKt.getExtractionContainers$default((PsiElement)klass, true, true, false, 4, null);
        PsiManagerEx psiManagerEx = klass.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManagerEx, (String)"getManager(...)");
        List containers = CollectionsKt.plus((Collection)collection, (Object)((Object)new SeparateFileWrapper((PsiManager)psiManagerEx)));
        if (editor == null) {
            this.doInvoke(klass, (PsiElement)CollectionsKt.first((List)containers));
            return;
        }
        ChooseContainerUtilKt.chooseContainerElementIfNecessary$default(containers, editor, CollectionsKt.first((List)containers) instanceof KtFile ? KotlinBundle.message((String)"text.select.target.file", (Object[])new Object[0]) : KotlinBundle.message((String)"text.select.target.code.block.file", (Object[])new Object[0]), true, null, arg_0 -> KotlinExtractSuperHandlerBase.selectElements$lambda$0(this, klass, arg_0), 16, null);
    }

    protected final boolean checkConflicts(@NotNull KtClassOrObject originalClass, @NotNull KotlinExtractSuperDialogBase dialog2) {
        Intrinsics.checkNotNullParameter((Object)originalClass, (String)"originalClass");
        Intrinsics.checkNotNullParameter((Object)((Object)dialog2), (String)"dialog");
        KotlinExtractSuperConflictSearcher kotlinExtractSuperConflictSearcher = KotlinExtractSuperConflictSearcher.Companion.getInstance();
        List<KotlinMemberInfo> list2 = dialog2.getSelectedMembers();
        PsiElement psiElement = dialog2.getSelectedTargetParent();
        String string = dialog2.getExtractedSuperName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExtractedSuperName(...)");
        MultiMap<PsiElement, String> conflicts = kotlinExtractSuperConflictSearcher.collectConflicts(originalClass, list2, psiElement, string, this.isExtractInterface);
        return ExtractSuperClassUtil.showConflicts((DialogWrapper)((DialogWrapper)dialog2), conflicts, (Project)originalClass.getProject());
    }

    @NlsContexts.DialogMessage
    @Nullable
    public String getErrorMessage(@NotNull KtClassOrObject klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return KtPsiUtilKt.isExpectDeclaration((KtDeclaration)((KtDeclaration)klass)) ? KotlinBundle.message((String)"error.text.extraction.from.expect.class.is.not.yet.supported", (Object[])new Object[0]) : (LightClassUtilsKt.toLightClass((KtClassOrObject)klass) == null ? KotlinBundle.message((String)"error.text.extraction.from.non.jvm.class.is.not.yet.supported", (Object[])new Object[0]) : null);
    }

    @NotNull
    protected abstract KotlinExtractSuperDialogBase createDialog(@NotNull KtClassOrObject var1, @NotNull PsiElement var2);

    private static final Unit selectElements$lambda$0(KotlinExtractSuperHandlerBase this$0, KtClassOrObject $klass, NavigatablePsiElement it) {
        NavigatablePsiElement navigatablePsiElement;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof SeparateFileWrapper) {
            PsiDirectory psiDirectory = $klass.getContainingFile().getParent();
            Intrinsics.checkNotNull((Object)psiDirectory);
            navigatablePsiElement = (NavigatablePsiElement)psiDirectory;
        } else {
            navigatablePsiElement = it;
        }
        this$0.doInvoke($klass, (PsiElement)navigatablePsiElement);
        return Unit.INSTANCE;
    }
}

