/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.pullUp;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.codeInsight.shorten.DelayedRequestsWaitingSetKt;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.TypeUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a.\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0014"}, d2={"getSuperTypeEntryByDescriptor", "Lorg/jetbrains/kotlin/psi/KtSuperTypeListEntry;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "makeAbstract", "", "member", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "originalMemberDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "addSuperTypeEntry", "delegator", "targetClassDescriptor", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\npullUpUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 pullUpUtils.kt\norg/jetbrains/kotlin/idea/refactoring/pullUp/PullUpUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n295#2,2:93\n*S KotlinDebug\n*F\n+ 1 pullUpUtils.kt\norg/jetbrains/kotlin/idea/refactoring/pullUp/PullUpUtilsKt\n*L\n25#1:93,2\n*E\n"})
public final class PullUpUtilsKt {
    @Nullable
    public static final KtSuperTypeListEntry getSuperTypeEntryByDescriptor(@NotNull KtClassOrObject $this$getSuperTypeEntryByDescriptor, @NotNull ClassDescriptor descriptor2, @NotNull BindingContext context2) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getSuperTypeEntryByDescriptor, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Iterable $this$firstOrNull$iv = $this$getSuperTypeEntryByDescriptor.getSuperTypeListEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv;
                boolean bl = false;
                KotlinType referencedType = (KotlinType)context2.get((ReadOnlySlice)BindingContext.TYPE, (Object)it.getTypeReference());
                KotlinType kotlinType = referencedType;
                if (!Intrinsics.areEqual((Object)(kotlinType != null && (kotlinType = kotlinType.getConstructor()) != null ? kotlinType.getDeclarationDescriptor() : null), (Object)descriptor2)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    public static final void makeAbstract(@NotNull KtCallableDeclaration member, @NotNull CallableMemberDescriptor originalMemberDescriptor, @NotNull TypeSubstitutor substitutor2, @NotNull KtClass targetClass) {
        PsiElement deleteFrom;
        PsiElement psiElement;
        KtCallableDeclaration ktCallableDeclaration;
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)originalMemberDescriptor, (String)"originalMemberDescriptor");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        if (!targetClass.isInterface()) {
            member.addModifier(KtTokens.ABSTRACT_KEYWORD);
        }
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns((DeclarationDescriptor)((DeclarationDescriptor)originalMemberDescriptor));
        if (member.getTypeReference() == null) {
            KotlinType type2 = originalMemberDescriptor.getReturnType();
            if (type2 == null || KotlinTypeKt.isError((KotlinType)type2)) {
                type2 = (KotlinType)builtIns.getNullableAnyType();
            } else {
                KotlinType kotlinType;
                KotlinType kotlinType2 = TypeUtils.anonymousObjectSuperTypeOrNull(type2);
                if (kotlinType2 == null) {
                    kotlinType2 = type2;
                }
                if ((kotlinType = substitutor2.substitute(kotlinType2, Variance.INVARIANT)) == null) {
                    SimpleType simpleType = builtIns.getNullableAnyType();
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getNullableAnyType(...)");
                    kotlinType = type2 = (KotlinType)simpleType;
                }
            }
            if (member instanceof KtProperty || !TypeUtilsKt.isUnit((KotlinType)type2)) {
                PsiModificationUtilsKt.setType(member, type2, false);
            }
        }
        if ((ktCallableDeclaration = member) instanceof KtProperty) {
            psiElement = ((KtProperty)member).getEqualsToken();
            if (psiElement == null) {
                KtPropertyDelegate ktPropertyDelegate = ((KtProperty)member).getDelegate();
                if (ktPropertyDelegate != null) {
                    psiElement = (PsiElement)ktPropertyDelegate;
                } else {
                    List list2 = ((KtProperty)member).getAccessors();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAccessors(...)");
                    psiElement = (PsiElement)CollectionsKt.firstOrNull((List)list2);
                }
            }
        } else if (ktCallableDeclaration instanceof KtNamedFunction) {
            psiElement = ((KtNamedFunction)member).getEqualsToken();
            if (psiElement == null) {
                psiElement = (PsiElement)((KtNamedFunction)member).getBodyExpression();
            }
        } else {
            psiElement = null;
        }
        if ((deleteFrom = psiElement) != null) {
            member.deleteChildRange(deleteFrom, member.getLastChild());
        }
    }

    public static final void addSuperTypeEntry(@NotNull KtSuperTypeListEntry delegator, @NotNull KtClassOrObject targetClass, @NotNull ClassDescriptor targetClassDescriptor, @NotNull BindingContext context2, @NotNull TypeSubstitutor substitutor2) {
        Intrinsics.checkNotNullParameter((Object)delegator, (String)"delegator");
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        Intrinsics.checkNotNullParameter((Object)targetClassDescriptor, (String)"targetClassDescriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        Object object = context2.get((ReadOnlySlice)BindingContext.TYPE, (Object)delegator.getTypeReference());
        Intrinsics.checkNotNull((Object)object);
        KotlinType referencedType = (KotlinType)object;
        ClassifierDescriptor classifierDescriptor = referencedType.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor referencedClass = classDescriptor;
        if (Intrinsics.areEqual((Object)targetClassDescriptor, (Object)referencedClass) || DescriptorUtils.isDirectSubclass((ClassDescriptor)targetClassDescriptor, (ClassDescriptor)referencedClass)) {
            return;
        }
        KotlinType typeInTargetClass = substitutor2.substitute(referencedType, Variance.INVARIANT);
        if (typeInTargetClass == null || KotlinTypeKt.isError((KotlinType)typeInTargetClass)) {
            return;
        }
        String renderedType = IdeDescriptorRenderers.SOURCE_CODE.renderType(typeInTargetClass);
        Project project = targetClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtSuperTypeEntry newSpecifier = new KtPsiFactory(project, false, 2, null).createSuperTypeEntry(renderedType);
        DelayedRequestsWaitingSetKt.addToShorteningWaitSet$default((KtElement)targetClass.addSuperTypeListEntry((KtSuperTypeListEntry)newSpecifier), null, 1, null);
    }
}

