/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.ultimate.nodejs.cli;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.idea.base.codeInsight.tooling.KotlinJSRunConfigurationDataProvider;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.js.JsUtilsKt;
import org.jetbrains.kotlin.idea.run.RcUtilsKt;
import org.jetbrains.kotlin.idea.ultimate.nodejs.NodeJsUtilKt;
import org.jetbrains.kotlin.idea.ultimate.nodejs.TestElementPath;
import org.jetbrains.kotlin.idea.ultimate.nodejs.cli.NodeJsConfigData;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\tH\u0016J&\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\tH\u0016R\u001a\u0010\u0007\u001a\u00020\b*\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/ultimate/nodejs/cli/KotlinNodeJsRunConfigurationProducer;", "Lcom/intellij/execution/actions/LazyRunConfigurationProducer;", "Lcom/jetbrains/nodejs/run/NodeJsRunConfiguration;", "Lorg/jetbrains/kotlin/idea/base/codeInsight/tooling/KotlinJSRunConfigurationDataProvider;", "Lorg/jetbrains/kotlin/idea/ultimate/nodejs/cli/NodeJsConfigData;", "<init>", "()V", "isAcceptable", "", "Lcom/intellij/execution/actions/ConfigurationContext;", "(Lcom/intellij/execution/actions/ConfigurationContext;)Z", "isForTests", "()Z", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "getConfigurationData", "context", "setupConfigurationFromContext", "configuration", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "isConfigurationFromContext", "kotlin-ultimate.javascript.nodeJs"})
@SourceDebugExtension(value={"SMAP\nKotlinNodeJsRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNodeJsRunConfigurationProducer.kt\norg/jetbrains/kotlin/idea/ultimate/nodejs/cli/KotlinNodeJsRunConfigurationProducer\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,97:1\n253#2:98\n*S KotlinDebug\n*F\n+ 1 KotlinNodeJsRunConfigurationProducer.kt\norg/jetbrains/kotlin/idea/ultimate/nodejs/cli/KotlinNodeJsRunConfigurationProducer\n*L\n65#1:98\n*E\n"})
final class KotlinNodeJsRunConfigurationProducer
extends LazyRunConfigurationProducer<NodeJsRunConfiguration>
implements KotlinJSRunConfigurationDataProvider<NodeJsConfigData> {
    private final boolean isAcceptable(ConfigurationContext $this$isAcceptable) {
        ConfigurationContext configurationContext = $this$isAcceptable;
        RunConfiguration original = configurationContext != null ? configurationContext.getOriginalConfiguration(null) : null;
        return original == null || original instanceof NodeJsRunConfiguration;
    }

    @Override
    public boolean isForTests() {
        return false;
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return NodeJsRunConfigurationType.Companion.getInstance().getConfigurationFactories()[0];
    }

    @Override
    @Nullable
    public NodeJsConfigData getConfigurationData(@NotNull ConfigurationContext context2) {
        MainFunctionDetector detector;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!this.isAcceptable(context2)) {
            return null;
        }
        PsiElement psiElement = context2.getPsiLocation();
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        Module module = context2.getModule();
        if (module == null || (module = JsUtilsKt.asJsModule(module)) == null) {
            return null;
        }
        Module module2 = module;
        if (KotlinFacetUtils.isNewMultiPlatformModule(module2)) {
            return null;
        }
        String string = JsUtilsKt.getJsProductionOutputFilePath(module2);
        if (string == null) {
            return null;
        }
        String jsFilePath = string;
        PsiElement $this$getNonStrictParentOfType$iv = element;
        boolean $i$f$getNonStrictParentOfType = false;
        KtNamedDeclaration declaration = (KtNamedDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtNamedDeclaration.class, (boolean)false);
        if (declaration instanceof KtNamedFunction ? !MainFunctionDetector.isMain$default((MainFunctionDetector)(detector = new MainFunctionDetector(LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)declaration), KotlinNodeJsRunConfigurationProducer::getConfigurationData$lambda$0)), (KtNamedFunction)((KtNamedFunction)declaration), (boolean)false, (boolean)false, (int)4, null) : !TestElementPath.Companion.isModuleAssociatedDir(element, module2)) {
            return null;
        }
        return new NodeJsConfigData(element, module2, jsFilePath);
    }

    protected boolean setupConfigurationFromContext(@NotNull NodeJsRunConfiguration configuration2, @NotNull ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        PsiElement psiElement = (PsiElement)sourceElement.get();
        if (psiElement == null) {
            return false;
        }
        PsiElement psiElement2 = psiElement;
        NodeJsConfigData nodeJsConfigData = this.getConfigurationData(context2);
        if (nodeJsConfigData == null) {
            return false;
        }
        NodeJsConfigData configData = nodeJsConfigData;
        CharSequence charSequence = configuration2.getWorkingDirectory();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            configuration2.setWorkingDirectory(FileUtil.toSystemDependentName((String)psiElement2.getProject().getBaseDir().getPath()));
        }
        configuration2.setMainScriptFilePath(configData.getJsOutputFilePath());
        configuration2.setEnvs(NodeJsUtilKt.getNodeJsEnvironmentVars(configData.getModule(), false).getEnvs());
        configuration2.setGeneratedName();
        RcUtilsKt.addBuildTask((RunConfiguration)configuration2);
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull NodeJsRunConfiguration configuration2, @NotNull ConfigurationContext context2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        NodeJsConfigData nodeJsConfigData = this.getConfigurationData(context2);
        if (nodeJsConfigData == null) {
            return false;
        }
        NodeJsConfigData configData = nodeJsConfigData;
        return Intrinsics.areEqual((Object)configuration2.getMainScriptFilePath(), (Object)configData.getJsOutputFilePath());
    }

    private static final FunctionDescriptor getConfigurationData$lambda$0(KtNamedFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ResolutionUtils.resolveToDescriptorIfAny$default(it, null, 1, null);
    }
}

