/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.ultimate.nodejs.protractor;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.protractor.ProtractorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.ultimate.nodejs.KotlinJavascriptBundle;
import org.jetbrains.kotlin.idea.ultimate.nodejs.protractor.KotlinProtractorRunConfigurationEditor;
import org.jetbrains.kotlin.idea.ultimate.nodejs.protractor.KotlinProtractorRunSettings;
import org.jetbrains.kotlin.idea.ultimate.nodejs.protractor.KotlinProtractorRunState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010#\u001a\u00020\fH\u0002J\b\u0010$\u001a\u00020\fH\u0016J\n\u0010%\u001a\u0004\u0018\u00010\bH\u0016J,\u0010&\u001a\u00020\f2\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\u0010'\u001a\u0004\u0018\u00010\b2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0002R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/KotlinProtractorRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;)V", "onNewConfigurationCreated", "", "runSettings", "Lorg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/KotlinProtractorRunSettings;", "getRunSettings", "()Lorg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/KotlinProtractorRunSettings;", "setRunSettings", "(Lorg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/KotlinProtractorRunSettings;)V", "protractorPackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "getProtractorPackage", "()Lcom/intellij/javascript/nodejs/util/NodePackage;", "getState", "Lorg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/KotlinProtractorRunState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getConfigurationEditor", "Lorg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/KotlinProtractorRunConfigurationEditor;", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "initialize", "checkConfiguration", "suggestedName", "validatePath", "path", "shouldBeAbsolute", "", "shouldBeDirectory", "kotlin-ultimate.javascript.nodeJs"})
@SourceDebugExtension(value={"SMAP\nKotlinProtractorRunConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinProtractorRunConfiguration.kt\norg/jetbrains/kotlin/idea/ultimate/nodejs/protractor/KotlinProtractorRunConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
public final class KotlinProtractorRunConfiguration
extends LocatableConfigurationBase<Object> {
    @NotNull
    private KotlinProtractorRunSettings runSettings;

    public KotlinProtractorRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory2, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        super(project, factory2, name2);
        this.runSettings = new KotlinProtractorRunSettings(null, null, null, null, null, null, 63, null);
    }

    public void onNewConfigurationCreated() {
        this.initialize();
    }

    @NotNull
    public final KotlinProtractorRunSettings getRunSettings() {
        return this.runSettings;
    }

    public final void setRunSettings(@NotNull KotlinProtractorRunSettings kotlinProtractorRunSettings) {
        Intrinsics.checkNotNullParameter((Object)kotlinProtractorRunSettings, (String)"<set-?>");
        this.runSettings = kotlinProtractorRunSettings;
    }

    @NotNull
    public final NodePackage getProtractorPackage() {
        NodePackage nodePackage = ProtractorUtil.getProtractorPackage((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)nodePackage, (String)"getProtractorPackage(...)");
        return nodePackage;
    }

    @NotNull
    public KotlinProtractorRunState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return new KotlinProtractorRunState(this, environment, this.getProtractorPackage());
    }

    @NotNull
    public KotlinProtractorRunConfigurationEditor getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new KotlinProtractorRunConfigurationEditor(project);
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        this.runSettings = KotlinProtractorRunSettings.Companion.readFromXML(element);
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        this.runSettings.writeToXML(element);
    }

    private final void initialize() {
        this.setNameChangedByUser(false);
    }

    public void checkConfiguration() {
        boolean isOptionalConfig;
        boolean bl = !StringsKt.isBlank((CharSequence)this.runSettings.getTestFileSystemDependentPath()) || !StringsKt.isBlank((CharSequence)this.runSettings.getSeleniumAddress()) ? true : (isOptionalConfig = false);
        if (isOptionalConfig) {
            this.validatePath(KotlinJavascriptBundle.message("protractor.configurator.name.test.file", new Object[0]), this.runSettings.getTestFileSystemDependentPath(), true, false);
            if (StringsKt.isBlank((CharSequence)this.runSettings.getSeleniumAddress())) {
                throw new RuntimeConfigurationError(KotlinJavascriptBundle.message("protractor.configurator.error.unspecified.selenium.address", new Object[0]));
            }
        }
        if (!isOptionalConfig || !StringsKt.isBlank((CharSequence)this.runSettings.getConfigFileSystemDependentPath())) {
            this.validatePath(KotlinJavascriptBundle.message("protractor.configurator.name.configuration.file", new Object[0]), this.runSettings.getConfigFileSystemDependentPath(), true, false);
        }
        NodeJsInterpreter interpreter = this.runSettings.getInterpreterRef().resolve(this.getProject());
        NodeJsLocalInterpreter.checkForRunConfiguration((NodeJsInterpreter)interpreter);
        this.validatePath(KotlinJavascriptBundle.message("protractor.configurator.name.protractor.package", new Object[0]), this.getProtractorPackage().getSystemDependentPath(), true, true);
    }

    @Nullable
    public String suggestedName() {
        CharSequence charSequence;
        String string = PathUtil.getFileName((String)this.runSettings.getTestFileSystemDependentPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String name2 = string;
        CharSequence charSequence2 = name2;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    private final void validatePath(@Nls String name2, String path2, boolean shouldBeAbsolute, boolean shouldBeDirectory) {
        boolean exists;
        Object[] objectArray = (Object[])path2;
        if (objectArray == null || StringsKt.isBlank((CharSequence)objectArray)) {
            objectArray = new Object[]{name2};
            throw new RuntimeConfigurationError(KotlinJavascriptBundle.message("protractor.configurator.error.unspecified.0", objectArray));
        }
        File file = new File(path2);
        if (shouldBeAbsolute && !file.isAbsolute()) {
            Object[] objectArray2 = new Object[]{name2};
            throw new RuntimeConfigurationError(KotlinJavascriptBundle.message("protractor.configurator.error.no.such.0", objectArray2));
        }
        boolean bl = exists = shouldBeDirectory ? file.isDirectory() : file.isFile();
        if (!exists) {
            Object[] objectArray3 = new Object[]{name2};
            throw new RuntimeConfigurationError(KotlinJavascriptBundle.message("protractor.configurator.error.no.such.0", objectArray3));
        }
    }
}

