/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.printing;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.nj2k.printing.JKPrinter;
import org.jetbrains.kotlin.nj2k.printing.JKPrinterBase;
import org.jetbrains.kotlin.nj2k.tree.FormattingKt;
import org.jetbrains.kotlin.nj2k.tree.JKComment;
import org.jetbrains.kotlin.nj2k.tree.JKDeclaration;
import org.jetbrains.kotlin.nj2k.tree.JKElement;
import org.jetbrains.kotlin.nj2k.tree.JKFormattingOwner;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u000e\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\b0\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0002J\u0016\u0010\u0012\u001a\u00020\u0013*\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0002J\f\u0010\u0014\u001a\u00020\u000f*\u00020\bH\u0002J\f\u0010\u0015\u001a\u00020\u0013*\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/nj2k/printing/JKCommentPrinter;", "", "printer", "Lorg/jetbrains/kotlin/nj2k/printing/JKPrinter;", "<init>", "(Lorg/jetbrains/kotlin/nj2k/printing/JKPrinter;)V", "printedTokens", "", "Lorg/jetbrains/kotlin/nj2k/tree/JKComment;", "printCommentsAndLineBreaksBefore", "", "element", "Lorg/jetbrains/kotlin/nj2k/tree/JKFormattingOwner;", "printCommentsAndLineBreaksAfter", "createText", "", "", "parent", "shouldBeDropped", "", "escapedText", "hasNoLineBreakAfterSingleLineComment", "kotlin.j2k.shared"})
@SourceDebugExtension(value={"SMAP\nJKCommentPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JKCommentPrinter.kt\norg/jetbrains/kotlin/nj2k/printing/JKCommentPrinter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class JKCommentPrinter {
    @NotNull
    private final JKPrinter printer;
    @NotNull
    private final Set<JKComment> printedTokens;

    public JKCommentPrinter(@NotNull JKPrinter printer) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        this.printer = printer;
        this.printedTokens = new LinkedHashSet();
    }

    public final void printCommentsAndLineBreaksBefore(@NotNull JKFormattingOwner element) {
        boolean shouldAddLineBreakAfterComment;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String text = JKCommentPrinter.createText$default(this, element.getCommentsBefore(), null, 1, null);
        this.printer.print(text);
        if (this.printer.getLastSymbolIsLineBreak()) {
            return;
        }
        boolean bl = element instanceof JKDeclaration && !((Collection)((JKDeclaration)element).getCommentsBefore()).isEmpty() || this.hasNoLineBreakAfterSingleLineComment(text) ? true : (shouldAddLineBreakAfterComment = false);
        if (FormattingKt.getHasLineBreakBefore(element) || shouldAddLineBreakAfterComment) {
            JKPrinterBase.println$default(this.printer, 0, 1, null);
        }
    }

    public final void printCommentsAndLineBreaksAfter(@NotNull JKFormattingOwner element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        JKTreeElement jKTreeElement = element instanceof JKTreeElement ? (JKTreeElement)element : null;
        JKElement jKElement = jKTreeElement != null ? jKTreeElement.getParent() : null;
        JKFormattingOwner parent = jKElement instanceof JKFormattingOwner ? (JKFormattingOwner)((Object)jKElement) : null;
        String text = this.createText(element.getCommentsAfter(), parent);
        this.printer.print(text);
        if (FormattingKt.getHasLineBreakAfter(element)) {
            this.printer.println(element.getLineBreaksAfter());
        } else if (this.hasNoLineBreakAfterSingleLineComment(text)) {
            JKPrinterBase.println$default(this.printer, 0, 1, null);
        }
    }

    private final String createText(List<JKComment> $this$createText, JKFormattingOwner parent) {
        StringBuilder stringBuilder;
        StringBuilder $this$createText_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean needNewLine = false;
        for (JKComment comment : $this$createText) {
            Object object;
            if (this.shouldBeDropped(comment, parent)) continue;
            ((Collection)this.printedTokens).add(comment);
            String text = this.escapedText(comment);
            if (needNewLine) {
                boolean bl2;
                if (comment.getIndent() != null) {
                    String it;
                    boolean bl3 = false;
                    bl2 = StringUtil.containsLineBreak((CharSequence)it);
                } else {
                    bl2 = false;
                }
                if (!bl2) {
                    $this$createText_u24lambda_u240.append('\n');
                }
            }
            if ((object = comment.getIndent()) == null) {
                object = Character.valueOf(' ');
            }
            $this$createText_u24lambda_u240.append(object);
            $this$createText_u24lambda_u240.append(text);
            needNewLine = StringsKt.startsWith$default((String)text, (String)"//", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)text, (char)'\n', (boolean)false, (int)2, null);
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ String createText$default(JKCommentPrinter jKCommentPrinter, List list2, JKFormattingOwner jKFormattingOwner, int n, Object object) {
        if ((n & 1) != 0) {
            jKFormattingOwner = null;
        }
        return jKCommentPrinter.createText(list2, jKFormattingOwner);
    }

    private final boolean shouldBeDropped(JKComment $this$shouldBeDropped, JKFormattingOwner parent) {
        if (this.printedTokens.contains($this$shouldBeDropped)) {
            return true;
        }
        if (StringsKt.startsWith$default((String)$this$shouldBeDropped.getText(), (String)"//noinspection", (boolean)false, (int)2, null)) {
            return true;
        }
        Object object = parent;
        return object != null && (object = object.getCommentsAfter()) != null ? object.contains($this$shouldBeDropped) : false;
    }

    private final String escapedText(JKComment $this$escapedText) {
        return $this$escapedText.isSingleLine() ? $this$escapedText.getText() : (StringsKt.indexOf$default((CharSequence)$this$escapedText.getText(), (String)"/*", (int)0, (boolean)false, (int)6, null) == StringsKt.lastIndexOf$default((CharSequence)$this$escapedText.getText(), (String)"/*", (int)0, (boolean)false, (int)6, null) ? $this$escapedText.getText() : StringsKt.replaceFirst$default((String)StringsKt.replace$default((String)$this$escapedText.getText(), (String)"/*", (String)"/ *", (boolean)false, (int)4, null), (String)"/ *", (String)"/*", (boolean)false, (int)4, null));
    }

    private final boolean hasNoLineBreakAfterSingleLineComment(String $this$hasNoLineBreakAfterSingleLineComment) {
        return StringsKt.lastIndexOf$default((CharSequence)$this$hasNoLineBreakAfterSingleLineComment, (char)'\n', (int)0, (boolean)false, (int)6, null) < StringsKt.lastIndexOf$default((CharSequence)$this$hasNoLineBreakAfterSingleLineComment, (String)"//", (int)0, (boolean)false, (int)6, null);
    }
}

