/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.ULongArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongSpreadBuilder;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.cbor.Cbor;
import kotlinx.serialization.cbor.CborDecoder;
import kotlinx.serialization.cbor.internal.CborDecodingException;
import kotlinx.serialization.cbor.internal.CborListReader;
import kotlinx.serialization.cbor.internal.CborMapReader;
import kotlinx.serialization.cbor.internal.CborParser;
import kotlinx.serialization.cbor.internal.DecoderKt;
import kotlinx.serialization.cbor.internal.EncodingKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0001\n\u0002\b\b\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u000eH\u0004J\u0019\u0010(\u001a\u00020#2\b\u0010)\u001a\u0004\u0018\u00010\u001cH\u0014\u00a2\u0006\u0004\b*\u0010 J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020#2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u00100\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020.H\u0016J\u001e\u00101\u001a\u0010\u0012\u0004\u0012\u000203\u0012\u0006\u0012\u0004\u0018\u00010\u001c022\u0006\u0010-\u001a\u00020.H\u0002J \u00104\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u000103\u0012\u0006\u0012\u0004\u0018\u00010\u001c022\u0006\u0010-\u001a\u00020.H\u0002J!\u00105\u001a\u0002H6\"\u0004\b\u0000\u001062\f\u00107\u001a\b\u0012\u0004\u0012\u0002H608H\u0016\u00a2\u0006\u0002\u00109J\b\u0010:\u001a\u000203H\u0016J\b\u0010;\u001a\u00020\u0012H\u0016J\b\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020\u0012H\u0016J\b\u0010A\u001a\u00020BH\u0016J\b\u0010C\u001a\u00020DH\u0016J\b\u0010E\u001a\u00020FH\u0016J\b\u0010G\u001a\u00020\u000eH\u0016J\b\u0010H\u001a\u00020IH\u0016J\n\u0010J\u001a\u0004\u0018\u00010KH\u0016J\u0010\u0010L\u001a\u00020\u000e2\u0006\u0010M\u001a\u00020.H\u0016J\b\u0010N\u001a\u00020\u0012H\u0002J)\u0010O\u001a\u00020#2\u0006\u0010-\u001a\u00020.2\u0006\u0010P\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0004\bQ\u0010RR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0012@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0015\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006S"}, d2={"Lkotlinx/serialization/cbor/internal/CborReader;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "Lkotlinx/serialization/cbor/CborDecoder;", "cbor", "Lkotlinx/serialization/cbor/Cbor;", "parser", "Lkotlinx/serialization/cbor/internal/CborParser;", "<init>", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/internal/CborParser;)V", "getCbor", "()Lkotlinx/serialization/cbor/Cbor;", "getParser", "()Lkotlinx/serialization/cbor/internal/CborParser;", "value", "", "size", "getSize", "()I", "", "finiteMode", "getFiniteMode", "()Z", "readProperties", "decodeByteArrayAsByteString", "getDecodeByteArrayAsByteString", "setDecodeByteArrayAsByteString", "(Z)V", "tags", "Lkotlin/ULongArray;", "getTags-2g2roS4", "()[J", "setTags-uLth9ew", "([J)V", "[J", "setSize", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "skipBeginToken", "objectTags", "skipBeginToken-uLth9ew", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "endStructure", "decodeElementIndex", "decodeElementNameWithTags", "Lkotlin/Pair;", "", "decodeElementNameWithTagsLenient", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "decodeString", "decodeNotNullMark", "decodeDouble", "", "decodeFloat", "", "decodeBoolean", "decodeByte", "", "decodeShort", "", "decodeChar", "", "decodeInt", "decodeLong", "", "decodeNull", "", "decodeEnum", "enumDescriptor", "isDone", "verifyKeyTags", "index", "verifyKeyTags-rjbGhUI", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I[J)V", "kotlinx-serialization-cbor"})
@SourceDebugExtension(value={"SMAP\nDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Decoder.kt\nkotlinx/serialization/cbor/internal/CborReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,621:1\n1#2:622\n*E\n"})
public class CborReader
extends AbstractDecoder
implements CborDecoder {
    @NotNull
    private final Cbor cbor;
    @NotNull
    private final CborParser parser;
    private int size;
    private boolean finiteMode;
    private int readProperties;
    private boolean decodeByteArrayAsByteString;
    @Nullable
    private long[] tags;

    public CborReader(@NotNull Cbor cbor, @NotNull CborParser parser) {
        Intrinsics.checkNotNullParameter(cbor, "cbor");
        Intrinsics.checkNotNullParameter(parser, "parser");
        this.cbor = cbor;
        this.parser = parser;
        this.size = -1;
    }

    @Override
    @NotNull
    public Cbor getCbor() {
        return this.cbor;
    }

    @NotNull
    protected final CborParser getParser() {
        return this.parser;
    }

    protected final int getSize() {
        return this.size;
    }

    protected final boolean getFiniteMode() {
        return this.finiteMode;
    }

    protected final boolean getDecodeByteArrayAsByteString() {
        return this.decodeByteArrayAsByteString;
    }

    protected final void setDecodeByteArrayAsByteString(boolean bl) {
        this.decodeByteArrayAsByteString = bl;
    }

    @Nullable
    protected final long[] getTags-2g2roS4() {
        return this.tags;
    }

    protected final void setTags-uLth9ew(@Nullable long[] lArray) {
        this.tags = lArray;
    }

    protected final void setSize(int size) {
        if (size >= 0) {
            this.finiteMode = true;
            this.size = size;
        }
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.getCbor().getSerializersModule();
    }

    protected void skipBeginToken-uLth9ew(@Nullable long[] objectTags) {
        this.setSize(this.parser.startMap-uLth9ew(objectTags));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        long[] lArray;
        SerialKind serialKind;
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        CborReader re = EncodingKt.hasArrayTag(descriptor) ? (CborReader)new CborListReader(this.getCbor(), this.parser) : (Intrinsics.areEqual(serialKind = descriptor.getKind(), StructureKind.LIST.INSTANCE) || serialKind instanceof PolymorphicKind ? (CborReader)new CborListReader(this.getCbor(), this.parser) : (Intrinsics.areEqual(serialKind, StructureKind.MAP.INSTANCE) ? (CborReader)new CborMapReader(this.getCbor(), this.parser) : new CborReader(this.getCbor(), this.parser)));
        long[] objectTags = this.getCbor().getConfiguration().getVerifyObjectTags() ? EncodingKt.getObjectTags(descriptor) : null;
        CborReader cborReader = re;
        if (this.tags != null) {
            long[] lArray2;
            void it;
            long[] lArray3 = this.tags;
            CborReader cborReader2 = cborReader;
            boolean bl = false;
            if (objectTags == null) {
                lArray2 = it;
            } else {
                LongSpreadBuilder longSpreadBuilder = new LongSpreadBuilder(2);
                longSpreadBuilder.addSpread(it);
                longSpreadBuilder.addSpread(objectTags);
                lArray2 = longSpreadBuilder.toArray();
            }
            lArray = lArray2;
            cborReader = cborReader2;
        } else {
            lArray = objectTags;
        }
        cborReader.skipBeginToken-uLth9ew(lArray);
        return (CompositeDecoder)re;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (!this.finiteMode) {
            this.parser.end();
        }
    }

    /*
     * WARNING - void declaration
     */
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        int n;
        int index;
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (this.getCbor().getConfiguration().getIgnoreUnknownKeys()) {
            void var3_2;
            long[] tags;
            int knownIndex = 0;
            while (true) {
                int n2;
                if (this.isDone()) {
                    return -1;
                }
                Pair<String, ULongArray> pair = this.decodeElementNameWithTagsLenient(descriptor);
                String elemName = pair.component1();
                ULongArray uLongArray = pair.component2();
                tags = (long[])(uLongArray != null ? uLongArray.unbox-impl() : null);
                int n3 = this.readProperties;
                this.readProperties = n3 + 1;
                if (elemName != null) {
                    String it;
                    boolean bl = false;
                    n2 = descriptor.getElementIndex(it);
                } else {
                    n2 = index = -3;
                }
                if (index != -3) break;
                this.parser.skipElement-uLth9ew(tags);
            }
            this.verifyKeyTags-rjbGhUI(descriptor, index, tags);
            knownIndex = index;
            n = var3_2;
        } else {
            if (this.isDone()) {
                return -1;
            }
            Pair<String, ULongArray> pair = this.decodeElementNameWithTags(descriptor);
            String elemName = pair.component1();
            ULongArray uLongArray = pair.component2();
            long[] tags = (long[])(uLongArray != null ? uLongArray.unbox-impl() : null);
            int n4 = this.readProperties;
            this.readProperties = n4 + 1;
            index = n4 = DecoderKt.access$getElementIndexOrThrow(descriptor, elemName);
            boolean bl = false;
            this.verifyKeyTags-rjbGhUI(descriptor, index, tags);
            n = n4;
        }
        int index2 = n;
        this.decodeByteArrayAsByteString = EncodingKt.isByteString(descriptor, index2);
        this.tags = this.getCbor().getConfiguration().getVerifyValueTags() ? EncodingKt.getValueTags(descriptor, index2) : null;
        return index2;
    }

    private final Pair<String, ULongArray> decodeElementNameWithTags(SerialDescriptor descriptor) {
        long[] tags;
        Triple<String, Long, ULongArray> triple = this.parser.nextTaggedStringOrNumber();
        String elemName = triple.component1();
        Long cborLabel = triple.component2();
        ULongArray uLongArray = triple.component3();
        Object object = tags = (Object)(uLongArray != null ? uLongArray.unbox-impl() : null);
        if (elemName == null && cborLabel != null) {
            String string = DecoderKt.access$getElementNameForCborLabel(descriptor, cborLabel);
            if (string == null) {
                throw new CborDecodingException("CborLabel unknown: " + cborLabel + " for " + descriptor);
            }
            elemName = string;
        }
        if (elemName == null) {
            throw new CborDecodingException("Expected (tagged) string or number, got nothing for " + descriptor);
        }
        return TuplesKt.to(elemName, tags != null ? ULongArray.box-impl(tags) : null);
    }

    private final Pair<String, ULongArray> decodeElementNameWithTagsLenient(SerialDescriptor descriptor) {
        long[] tags;
        Triple<String, Long, ULongArray> triple = this.parser.nextTaggedStringOrNumber();
        String elemName = triple.component1();
        Long cborLabel = triple.component2();
        ULongArray uLongArray = triple.component3();
        Object object = tags = (Object)(uLongArray != null ? uLongArray.unbox-impl() : null);
        if (elemName == null && cborLabel != null) {
            elemName = DecoderKt.access$getElementNameForCborLabel(descriptor, cborLabel);
        }
        return TuplesKt.to(elemName, tags != null ? ULongArray.box-impl(tags) : null);
    }

    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        Object object;
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        if ((this.decodeByteArrayAsByteString || this.getCbor().getConfiguration().getAlwaysUseByteString()) && Intrinsics.areEqual(deserializer.getDescriptor(), BuiltinSerializersKt.ByteArraySerializer().getDescriptor())) {
            object = this.parser.nextByteString-uLth9ew(this.tags);
        } else {
            this.decodeByteArrayAsByteString = this.decodeByteArrayAsByteString || EncodingKt.isInlineByteString(deserializer.getDescriptor());
            object = super.decodeSerializableValue(deserializer);
        }
        return (T)object;
    }

    @NotNull
    public String decodeString() {
        return this.parser.nextString-uLth9ew(this.tags);
    }

    public boolean decodeNotNullMark() {
        return !this.parser.isNull();
    }

    public double decodeDouble() {
        return this.parser.nextDouble-uLth9ew(this.tags);
    }

    public float decodeFloat() {
        return this.parser.nextFloat-uLth9ew(this.tags);
    }

    public boolean decodeBoolean() {
        return this.parser.nextBoolean-uLth9ew(this.tags);
    }

    public byte decodeByte() {
        return (byte)this.parser.nextNumber-uLth9ew(this.tags);
    }

    public short decodeShort() {
        return (short)this.parser.nextNumber-uLth9ew(this.tags);
    }

    public char decodeChar() {
        return (char)this.parser.nextNumber-uLth9ew(this.tags);
    }

    public int decodeInt() {
        return (int)this.parser.nextNumber-uLth9ew(this.tags);
    }

    public long decodeLong() {
        return this.parser.nextNumber-uLth9ew(this.tags);
    }

    @Nullable
    public Void decodeNull() {
        return this.parser.nextNull-uLth9ew(this.tags);
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        return DecoderKt.access$getElementIndexOrThrow(enumDescriptor, this.parser.nextString-uLth9ew(this.tags));
    }

    private final boolean isDone() {
        return !this.finiteMode && this.parser.isEnd() || this.finiteMode && this.readProperties >= this.size;
    }

    private final void verifyKeyTags-rjbGhUI(SerialDescriptor descriptor, int index, long[] tags) {
        block1: {
            if (!this.getCbor().getConfiguration().getVerifyKeyTags()) break block1;
            long[] lArray = EncodingKt.getKeyTags(descriptor, index);
            if (lArray != null) {
                long[] keyTags = lArray;
                boolean bl = false;
                this.parser.verifyTagsAndThrow-EOCRwWE$kotlinx_serialization_cbor(keyTags, tags);
            }
        }
    }
}

