/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.jam.AopAdviceImpl;
import com.intellij.aop.jam.AopAdviceMetas;
import com.intellij.aop.jam.AopAspectImpl;
import com.intellij.aop.jam.AopIntroductionImpl;
import com.intellij.aop.jam.AopPointcutImpl;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.LibraryRuntimeClasspathScope;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JamAopModel {
    @NotNull
    private final List<Module> myModules;
    @Nullable
    private final Project myProject;

    public JamAopModel(@Nullable Module module) {
        this(JamAopModel.getModuleList(module));
    }

    private static List<Module> getModuleList(@Nullable Module module) {
        if (module == null) {
            return Collections.emptyList();
        }
        return List.of(module);
    }

    public JamAopModel(@NotNull List<Module> modules) {
        if (modules == null) {
            JamAopModel.$$$reportNull$$$0(0);
        }
        this.myModules = modules;
        this.myProject = modules.isEmpty() ? null : this.myModules.get(0).getProject();
    }

    public List<AopAspectImpl> getAspects() {
        if (this.myProject == null || DumbService.isDumb((Project)this.myProject)) {
            return Collections.emptyList();
        }
        return JamService.getJamService((Project)this.myProject).getJamClassElements(AopAspectImpl.ASPECT_META, "org.aspectj.lang.annotation.Aspect", this.getModuleScope());
    }

    private GlobalSearchScope getModuleScope() {
        if (this.myProject == null) {
            return GlobalSearchScope.EMPTY_SCOPE;
        }
        if (this.myModules.size() == 1) {
            return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModules.get(0));
        }
        return new LibraryRuntimeClasspathScope(this.myProject, this.myModules);
    }

    public List<AopPointcutImpl> getPointcuts() {
        if (this.myProject == null) {
            return Collections.emptyList();
        }
        return JamService.getJamService((Project)this.myProject).getJamMethodElements(AopPointcutImpl.POINTCUT_METHOD_META, "org.aspectj.lang.annotation.Pointcut", this.getModuleScope());
    }

    @Nullable
    public static AopAdviceImpl getAdvice(@NotNull PsiMethod method) {
        if (method == null) {
            JamAopModel.$$$reportNull$$$0(1);
        }
        return (AopAdviceImpl)JamService.getJamService((Project)method.getProject()).getJamElement((PsiElement)method, AopAdviceMetas.ADVICE_METHOD_METAS);
    }

    @Nullable
    public static AopPointcutImpl getPointcut(@NotNull PsiMethod method) {
        if (method == null) {
            JamAopModel.$$$reportNull$$$0(2);
        }
        return (AopPointcutImpl)JamService.getJamService((Project)method.getProject()).getJamElement((PsiElement)method, new JamMemberMeta[]{AopPointcutImpl.POINTCUT_METHOD_META});
    }

    @Nullable
    public static AopIntroductionImpl getIntroduction(@NotNull PsiField field) {
        if (field == null) {
            JamAopModel.$$$reportNull$$$0(3);
        }
        return (AopIntroductionImpl)JamService.getJamService((Project)field.getProject()).getJamElement((PsiElement)field, new JamMemberMeta[]{AopAspectImpl.INTRODUCTION_FIELD_META});
    }

    public static boolean isAopAvailable(Module module) {
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)"org.aspectj.lang.annotation.Aspect");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        objectArray2[1] = "com/intellij/aop/jam/JamAopModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAdvice";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPointcut";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getIntroduction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

