/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopBundle;
import com.intellij.aop.ArgNamesManipulator;
import com.intellij.aop.LocalAopModel;
import com.intellij.aop.jam.AbstractAopInspection;
import com.intellij.aop.psi.AopPointcutExpressionHolder;
import com.intellij.aop.psi.PsiIfPointcutExpression;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypes;

public final class PointcutMethodStyleInspection
extends AbstractAopInspection {
    @Override
    protected void checkAopMethod(PsiMethod pointcutMethod, LocalAopModel model, ProblemsHolder holder, AopPointcutExpressionHolder aopFile) {
        ArgNamesManipulator manipulator = model.getArgNamesManipulator();
        if (manipulator == null || manipulator.getAdviceType() != null) {
            return;
        }
        PsiElement problemElement = manipulator.getCommonProblemElement();
        if (!PsiTypes.voidType().equals((Object)pointcutMethod.getReturnType())) {
            PsiPointcutExpression expression = aopFile.getPointcutExpression();
            if (expression instanceof PsiIfPointcutExpression && PsiTypes.booleanType().equals((Object)pointcutMethod.getReturnType())) {
                return;
            }
            holder.registerProblem(problemElement, AopBundle.message("pointcut.methods.should.have.void.return.type", new Object[0]), new LocalQuickFix[0]);
            return;
        }
        if (pointcutMethod.getThrowsList().getTextLength() > 0) {
            holder.registerProblem(problemElement, AopBundle.message("pointcut.methods.should.have.no.throws.clause", new Object[0]), new LocalQuickFix[0]);
            return;
        }
        PsiCodeBlock body = pointcutMethod.getBody();
        if (body != null && body.getStatements().length > 0) {
            holder.registerProblem(problemElement, AopBundle.message("pointcut.methods.should.have.empty.body", new Object[0]), new LocalQuickFix[0]);
        }
    }
}

