/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.stream.code;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class SpringCloudStreamImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final List<String> ENTRY_POINT_ANNOTATIONS = List.of("org.springframework.cloud.stream.reactive.StreamEmitter", "org.springframework.cloud.stream.annotation.StreamListener", "org.springframework.cloud.stream.annotation.Input", "org.springframework.cloud.stream.annotation.Output");
    private static final List<String> REGULAR_COMPONENT_ANNOTATIONS = List.of("org.springframework.stereotype.Service", "org.springframework.stereotype.Component");

    SpringCloudStreamImplicitUsageProvider() {
    }

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            SpringCloudStreamImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        return SpringCloudStreamImplicitUsageProvider.hasWriteAnnotations(element) || SpringCloudStreamImplicitUsageProvider.isComponentWithListener(element);
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            SpringCloudStreamImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        return SpringCloudStreamImplicitUsageProvider.hasReadAnnotations(element);
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            SpringCloudStreamImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return SpringCloudStreamImplicitUsageProvider.hasWriteAnnotations(element);
    }

    private static boolean isComponentWithListener(PsiElement element) {
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass psiClass = (PsiClass)element;
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, REGULAR_COMPONENT_ANNOTATIONS, (int)0) && SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)psiClass) && ContainerUtil.exists((Object[])psiClass.getMethods(), m -> AnnotationUtil.isAnnotated((PsiModifierListOwner)m, ENTRY_POINT_ANNOTATIONS, (int)0));
    }

    private static boolean hasReadAnnotations(PsiElement element) {
        return element instanceof PsiMethod && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), ENTRY_POINT_ANNOTATIONS, (int)0);
    }

    private static boolean hasWriteAnnotations(PsiElement element) {
        return element instanceof PsiMethod && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), ENTRY_POINT_ANNOTATIONS, (int)0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/spring/boot/cloud/stream/code/SpringCloudStreamImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

