/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm;

import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageViewTypeLocation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/kubernetes/helm/ChartElementDescriptionProvider;", "Lcom/intellij/psi/ElementDescriptionProvider;", "<init>", "()V", "getElementDescription", "", "element", "Lcom/intellij/psi/PsiElement;", "location", "Lcom/intellij/psi/ElementDescriptionLocation;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nChartElementDescriptionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartElementDescriptionProvider.kt\ncom/intellij/kubernetes/helm/ChartElementDescriptionProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n*L\n1#1,33:1\n30#2,2:34\n133#3:36\n133#3:37\n*S KotlinDebug\n*F\n+ 1 ChartElementDescriptionProvider.kt\ncom/intellij/kubernetes/helm/ChartElementDescriptionProvider\n*L\n19#1:34,2\n23#1:36\n26#1:37\n*E\n"})
public final class ChartElementDescriptionProvider
implements ElementDescriptionProvider {
    @Nullable
    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (!(element instanceof YAMLDocument) && !(element instanceof YAMLKeyValue)) {
            return null;
        }
        Project project = ((YAMLPsiElement)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        if (((ChartManager)object).findChartByDefinitionElement(element) == null) {
            return null;
        }
        YAMLPsiElement yAMLPsiElement = (YAMLPsiElement)element;
        if (yAMLPsiElement instanceof YAMLDocument) {
            condition$iv = location instanceof UsageViewTypeLocation;
            boolean $i$f$doIf = false;
            if (condition$iv) {
                boolean bl = false;
                string = KubernetesBundle.message((String)"ChartElementDescriptionProvider.helm.object.title", (Object[])new Object[0]);
            } else {
                string = null;
            }
        } else if (yAMLPsiElement instanceof YAMLKeyValue) {
            condition$iv = location instanceof UsageViewTypeLocation;
            boolean $i$f$doIf = false;
            if (condition$iv) {
                boolean bl = false;
                string = KubernetesBundle.message((String)"ChartElementDescriptionProvider.helm.value.title", (Object[])new Object[0]);
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }
}

