/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.tgz;

import com.intellij.kubernetes.helm.tgz.TgzHandler;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0014J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0014J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000fH\u0014\u00a8\u0006\u001b"}, d2={"Lcom/intellij/kubernetes/helm/tgz/TgzFileSystem;", "Lcom/intellij/openapi/vfs/newvfs/ArchiveFileSystem;", "<init>", "()V", "getProtocol", "", "extractRootPath", "normalizedPath", "extractLocalPath", "rootPath", "composeRootPath", "localPath", "getHandler", "Lcom/intellij/openapi/vfs/impl/ArchiveHandler;", "entryFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findFileByPath", "path", "findFileByPathIfCached", "refreshAndFindFileByPath", "refresh", "", "asynchronous", "", "isCorrectFileType", "local", "Companion", "intellij.clouds.kubernetes.backend"})
public final class TgzFileSystem
extends ArchiveFileSystem {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getProtocol() {
        return "helm-tgz";
    }

    @NotNull
    protected String extractRootPath(@NotNull String normalizedPath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)normalizedPath, (String)"normalizedPath");
        int endIndex = StringsKt.indexOf$default((CharSequence)normalizedPath, (String)"!/", (int)0, (boolean)false, (int)6, null);
        if (endIndex > 0) {
            String string2 = normalizedPath.substring(0, endIndex + 2);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = "";
        }
        return string;
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        String string = StringUtil.trimEnd((String)rootPath, (String)"!/");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimEnd(...)");
        return string;
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        return localPath + "!/";
    }

    @NotNull
    protected ArchiveHandler getHandler(@NotNull VirtualFile entryFile) {
        Intrinsics.checkNotNullParameter((Object)entryFile, (String)"entryFile");
        ArchiveHandler archiveHandler = VfsImplUtil.getHandler((ArchiveFileSystem)this, (VirtualFile)entryFile, arg_0 -> TgzFileSystem.getHandler$lambda$1(TgzFileSystem::getHandler$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)archiveHandler, (String)"getHandler(...)");
        return archiveHandler;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (VirtualFile)ArchiveFileSystem.findFileByPath((NewVirtualFileSystem)((NewVirtualFileSystem)this), (String)path);
    }

    @Nullable
    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (VirtualFile)ArchiveFileSystem.findFileByPathIfCached((NewVirtualFileSystem)((NewVirtualFileSystem)this), (String)path);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (VirtualFile)VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)((NewVirtualFileSystem)this), (String)path);
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)((NewVirtualFileSystem)this), (boolean)asynchronous);
    }

    protected boolean isCorrectFileType(@NotNull VirtualFile local) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        return Intrinsics.areEqual((Object)local.getExtension(), (Object)"tgz");
    }

    private static final TgzHandler getHandler$lambda$0(String localPath) {
        Intrinsics.checkNotNull((Object)localPath);
        return new TgzHandler(localPath);
    }

    private static final TgzHandler getHandler$lambda$1(Function1 $tmp0, Object p0) {
        return (TgzHandler)((Object)$tmp0.invoke(p0));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kubernetes/helm/tgz/TgzFileSystem$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/kubernetes/helm/tgz/TgzFileSystem;", "getInstance", "()Lcom/intellij/kubernetes/helm/tgz/TgzFileSystem;", "findRootByLocalArchive", "Lcom/intellij/openapi/vfs/VirtualFile;", "archiveFile", "getLocalArchiveByRoot", "root", "isCorrectFile", "", "intellij.clouds.kubernetes.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TgzFileSystem getInstance() {
            VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem("helm-tgz");
            Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type com.intellij.kubernetes.helm.tgz.TgzFileSystem");
            return (TgzFileSystem)virtualFileSystem;
        }

        @Nullable
        public final VirtualFile findRootByLocalArchive(@NotNull VirtualFile archiveFile) {
            Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
            TgzFileSystem tgzFileSystem = this.getInstance();
            String string = this.getInstance().getRootPathByLocal(archiveFile);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRootPathByLocal(...)");
            return tgzFileSystem.findFileByPath(string);
        }

        @Nullable
        public final VirtualFile getLocalArchiveByRoot(@NotNull VirtualFile root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            return this.getInstance().findLocalByRootPath(root.getPath());
        }

        public final boolean isCorrectFile(@NotNull VirtualFile archiveFile) {
            Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
            return !archiveFile.isDirectory() && this.getInstance().isCorrectFileType(archiveFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

