/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.references;

import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.view.navigation.KubernetesNavigationManager;
import com.intellij.kubernetes.view.navigation.KubernetesResourceNavigationData;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.util.messages.MessageBus;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\rH&J\b\u0010\u0018\u001a\u00020\rH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/kubernetes/references/InClusterElement;", "Lcom/intellij/psi/impl/FakePsiElement;", "Lcom/intellij/psi/SyntheticElement;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "_parent", "Lcom/intellij/psi/PsiElement;", "navigationData", "Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;", "<init>", "(Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;Lcom/intellij/psi/PsiElement;Lcom/intellij/kubernetes/view/navigation/KubernetesResourceNavigationData;)V", "getParent", "getText", "", "getProject", "Lcom/intellij/openapi/project/Project;", "navigate", "", "requestFocus", "", "getIcon", "Ljavax/swing/Icon;", "open", "getName", "toString", "getContainingFile", "Lcom/intellij/psi/PsiFile;", "isValid", "intellij.clouds.kubernetes.backend"})
public abstract class InClusterElement
extends FakePsiElement
implements SyntheticElement {
    @NotNull
    private final KubernetesApiModelInterface apiModel;
    @Nullable
    private final PsiElement _parent;
    @NotNull
    private final KubernetesResourceNavigationData navigationData;

    public InClusterElement(@NotNull KubernetesApiModelInterface apiModel2, @Nullable PsiElement _parent, @NotNull KubernetesResourceNavigationData navigationData) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)navigationData, (String)"navigationData");
        this.apiModel = apiModel2;
        this._parent = _parent;
        this.navigationData = navigationData;
    }

    @Nullable
    public PsiElement getParent() {
        return this._parent;
    }

    @NotNull
    public String getText() {
        return this.getName();
    }

    @NotNull
    public Project getProject() {
        return this.apiModel.getProject();
    }

    public void navigate(boolean requestFocus) {
        MessageBus messageBus = this.getProject().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        MessageBus messageBus2 = messageBus;
        if (messageBus2.isDisposed()) {
            return;
        }
        ((KubernetesNavigationManager)messageBus2.syncPublisher(KubernetesNavigationManager.TOPIC)).navigate(this.apiModel, this.navigationData);
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return KubernetesIcons.Kubernetes_Y;
    }

    @NotNull
    public abstract String getName();

    @NotNull
    public String toString() {
        return this.getText();
    }

    @Nullable
    public PsiFile getContainingFile() {
        return this._parent != null ? super.getContainingFile() : null;
    }

    public boolean isValid() {
        return true;
    }
}

