/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.HelmUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.helm.model.DependenciesMetaClass;
import com.intellij.kubernetes.helm.model.DependenciesV1MetaClass;
import com.intellij.kubernetes.helm.model.HelmModel;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J#\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/kubernetes/ui/intentions/HelmUpdateDependenciesIntentionAction;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "Lcom/intellij/openapi/util/Iconable;", "<init>", "()V", "getFamilyName", "", "getText", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "invoke", "", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "getIcon", "Ljavax/swing/Icon;", "flags", "", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nHelmIntentions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmIntentions.kt\ncom/intellij/kubernetes/ui/intentions/HelmUpdateDependenciesIntentionAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,155:1\n30#2,2:156\n*S KotlinDebug\n*F\n+ 1 HelmIntentions.kt\ncom/intellij/kubernetes/ui/intentions/HelmUpdateDependenciesIntentionAction\n*L\n148#1:156,2\n*E\n"})
public final class HelmUpdateDependenciesIntentionAction
extends PsiElementBaseIntentionAction
implements Iconable {
    @NotNull
    public String getFamilyName() {
        String string = KubernetesBundle.message((String)"HelmUpdateDependenciesIntentionAction.family.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getText() {
        String string = KubernetesBundle.message((String)"HelmUpdateDependenciesIntentionAction.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (editor == null) {
            return;
        }
        AnAction anAction = ActionManager.getInstance().getAction("Kubernetes.HelmDependencyUpdate");
        Intrinsics.checkNotNull((Object)anAction);
        AnAction action = anAction;
        JComponent jComponent = editor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        ActionUtil.invokeAction((AnAction)action, (Component)jComponent, (String)"IntentionMenu", null, null);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        YamlMetaTypeProvider yamlMetaTypeProvider = HelmUtilKt.getHelmMetaTypeProvider(psiFile);
        if (yamlMetaTypeProvider == null) {
            return false;
        }
        YamlMetaTypeProvider metaTypeProvider = yamlMetaTypeProvider;
        YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)YamlUtilKt.getTypedAncestorOrSelf((PsiElement)element, YAMLKeyValue.class);
        if (yAMLKeyValue == null) {
            return false;
        }
        YAMLKeyValue keyVal = yAMLKeyValue;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = metaTypeProvider.getKeyValueMetaType(keyVal);
        if (metaTypeProxy == null) {
            return false;
        }
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy2 = metaTypeProxy;
        YamlMetaType yamlMetaType = metaTypeProxy2.getMetaType();
        if (!(yamlMetaType instanceof DependenciesMetaClass)) {
            bl = false;
        } else if (yamlMetaType instanceof DependenciesV1MetaClass) {
            HelmModel helmModel;
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ChartManager> serviceClass$iv = ChartManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)element);
            if (virtualFile == null) {
                return false;
            }
            Chart chart = ((ChartManager)object).findChartByRelatedFile(virtualFile);
            bl = Intrinsics.areEqual(chart != null && (helmModel = chart.getModel()) != null ? helmModel.getApiVersion() : null, (Object)"v1");
        } else {
            bl = true;
        }
        return bl;
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = KubernetesIcons.Helm;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Helm");
        return icon;
    }
}

