/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.Transform;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0006\u001a\u00020\fJ\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleUtil;", "", "()V", "applyInverseTransform", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "r", "transform", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "applyTransform", "", "", "source", "Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "labelByBreak", "", "", "scale", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "transformedDefinedLimits", "Lkotlin/Pair;", "plot-base"})
@SourceDebugExtension(value={"SMAP\nScaleUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScaleUtil.kt\norg/jetbrains/letsPlot/core/plot/base/scale/ScaleUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1549#2:64\n1620#2,3:65\n*S KotlinDebug\n*F\n+ 1 ScaleUtil.kt\norg/jetbrains/letsPlot/core/plot/base/scale/ScaleUtil\n*L\n43#1:64\n43#1:65,3\n*E\n"})
public final class ScaleUtil {
    @NotNull
    public static final ScaleUtil INSTANCE = new ScaleUtil();

    private ScaleUtil() {
    }

    @NotNull
    public final Map<Object, String> labelByBreak(@NotNull Scale scale2) {
        Intrinsics.checkNotNullParameter((Object)scale2, (String)"scale");
        ScaleBreaks scaleBreaks = scale2.getScaleBreaks();
        return MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)scaleBreaks.getDomainValues(), (Iterable)scaleBreaks.getLabels()));
    }

    @NotNull
    public final Pair<Double, Double> transformedDefinedLimits(@NotNull ContinuousTransform transform2) {
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        Double d = transform2.apply((Double)transform2.definedLimits().getFirst());
        Double d2 = transform2.apply((Double)transform2.definedLimits().getSecond());
        Pair pair2 = new Pair((Object)(d != null ? d : Double.NaN), (Object)(d2 != null ? d2 : Double.NaN));
        double lower2 = ((Number)pair2.component1()).doubleValue();
        double upper2 = ((Number)pair2.component2()).doubleValue();
        return SeriesUtil.INSTANCE.allFinite(lower2, upper2) ? new Pair((Object)Math.min(lower2, upper2), (Object)Math.max(lower2, upper2)) : new Pair((Object)lower2, (Object)upper2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Double> applyTransform(@NotNull List<?> source, @NotNull Transform transform2) {
        List list2;
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        if (transform2.hasDomainLimits()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = source;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(transform2.isInDomain(it) ? it : null);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = source;
        }
        List source2 = list2;
        return transform2.apply(source2);
    }

    @NotNull
    public final DoubleSpan applyTransform(@NotNull DoubleSpan r, @NotNull ContinuousTransform transform2) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        Double d = transform2.apply(r.getLowerEnd());
        Intrinsics.checkNotNull((Object)d);
        double a2 = d;
        Double d2 = transform2.apply(r.getUpperEnd());
        Intrinsics.checkNotNull((Object)d2);
        double b2 = d2;
        return new DoubleSpan(Math.min(a2, b2), Math.max(a2, b2));
    }

    @NotNull
    public final DoubleSpan applyInverseTransform(@NotNull DoubleSpan r, @NotNull ContinuousTransform transform2) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        Double d = transform2.applyInverse(r.getLowerEnd());
        Intrinsics.checkNotNull((Object)d);
        double a2 = d;
        Double d2 = transform2.applyInverse(r.getUpperEnd());
        Intrinsics.checkNotNull((Object)d2);
        double b2 = d2;
        return new DoubleSpan(Math.min(a2, b2), Math.max(a2, b2));
    }
}

