/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaGenericsUtil {
    public static boolean isReifiableType(PsiType type) {
        if (type instanceof PsiArrayType) {
            return JavaGenericsUtil.isReifiableType(((PsiArrayType)type).getComponentType());
        }
        if (type instanceof PsiPrimitiveType) {
            return true;
        }
        if (PsiUtil.resolveClassInType(type) instanceof PsiTypeParameter) {
            return false;
        }
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)PsiUtil.convertAnonymousToBaseType(type);
            if (classType.isRaw()) {
                return true;
            }
            PsiType[] parameters = classType.getParameters();
            if (parameters.length > 0) {
                for (PsiType parameter : parameters) {
                    if (parameter instanceof PsiWildcardType && ((PsiWildcardType)parameter).getBound() == null) continue;
                    return false;
                }
                return true;
            }
            PsiClassType.ClassResolveResult resolved = classType.resolveGenerics();
            PsiClass aClass = resolved.getElement();
            if (aClass instanceof PsiTypeParameter) {
                return false;
            }
            if (aClass != null && !aClass.hasModifierProperty("static")) {
                PsiClass stopClassLevel = PsiUtil.isLocalClass(aClass) ? null : aClass.getContainingClass();
                PsiModifierListOwner enclosingStaticElement = PsiUtil.getEnclosingStaticElement(aClass, stopClassLevel);
                PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
                if (containingClass != null && (enclosingStaticElement == null || PsiTreeUtil.isAncestor((PsiElement)enclosingStaticElement, (PsiElement)containingClass, (boolean)false))) {
                    while (containingClass instanceof PsiAnonymousClass) {
                        containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class, (boolean)true);
                    }
                    if (containingClass == null || enclosingStaticElement != null && !PsiTreeUtil.isAncestor((PsiElement)enclosingStaticElement, (PsiElement)containingClass, (boolean)false)) {
                        return true;
                    }
                    return JavaGenericsUtil.isReifiableType(JavaPsiFacade.getElementFactory(aClass.getProject()).createType(containingClass, resolved.getSubstitutor()));
                }
            }
            return true;
        }
        if (type instanceof PsiCapturedWildcardType) {
            return JavaGenericsUtil.isReifiableType(((PsiCapturedWildcardType)type).getUpperBound());
        }
        return false;
    }

    public static boolean isUncheckedWarning(@NotNull PsiJavaCodeReferenceElement expression, @NotNull JavaResolveResult resolveResult, @NotNull LanguageLevel languageLevel) {
        PsiExpressionList argumentList;
        PsiElement resolve;
        if (expression == null) {
            JavaGenericsUtil.$$$reportNull$$$0(0);
        }
        if (resolveResult == null) {
            JavaGenericsUtil.$$$reportNull$$$0(1);
        }
        if (languageLevel == null) {
            JavaGenericsUtil.$$$reportNull$$$0(2);
        }
        if (!((resolve = resolveResult.getElement()) instanceof PsiMethod)) {
            return false;
        }
        PsiMethod psiMethod = (PsiMethod)resolve;
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        int parametersCount = parameters.length;
        if (parametersCount == 0) {
            return false;
        }
        PsiParameter varargParameter = parameters[parametersCount - 1];
        if (!varargParameter.isVarArgs()) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, "java.lang.SafeVarargs", 2)) {
            return false;
        }
        PsiType componentType = ((PsiEllipsisType)varargParameter.getType()).getComponentType();
        if (JavaGenericsUtil.isReifiableType(resolveResult.getSubstitutor().substitute(componentType))) {
            return false;
        }
        if (expression instanceof PsiMethodReferenceExpression) {
            return true;
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiCall && (argumentList = ((PsiCall)parent).getArgumentList()) != null) {
            PsiExpression lastArg;
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length == parametersCount && (lastArg = args[args.length - 1]).getType() instanceof PsiArrayType) {
                return false;
            }
            for (int i = parametersCount - 1; i < args.length; ++i) {
                if (JavaGenericsUtil.isReifiableType(resolveResult.getSubstitutor().substitute(args[i].getType()))) continue;
                return true;
            }
            return args.length < parametersCount;
        }
        return false;
    }

    public static boolean isUncheckedCast(@NotNull PsiType castType, @NotNull PsiType operandType) {
        if (castType == null) {
            JavaGenericsUtil.$$$reportNull$$$0(3);
        }
        if (operandType == null) {
            JavaGenericsUtil.$$$reportNull$$$0(4);
        }
        if (TypeConversionUtil.isAssignable(castType, operandType, false)) {
            return false;
        }
        if ((castType = castType.getDeepComponentType()) instanceof PsiClassType) {
            PsiClassType castClassType = (PsiClassType)castType;
            if ((operandType = operandType.getDeepComponentType()) instanceof PsiCapturedWildcardType) {
                operandType = ((PsiCapturedWildcardType)operandType).getUpperBound();
            }
            if (!(operandType instanceof PsiClassType)) {
                return false;
            }
            PsiClassType operandClassType = (PsiClassType)operandType;
            PsiClassType.ClassResolveResult castResult = castClassType.resolveGenerics();
            PsiClassType.ClassResolveResult operandResult = operandClassType.resolveGenerics();
            PsiClass operandClass = operandResult.getElement();
            PsiClass castClass = castResult.getElement();
            if (operandClass == null || castClass == null) {
                return false;
            }
            if (castClass instanceof PsiTypeParameter) {
                return true;
            }
            if (castClassType.hasNonTrivialParameters()) {
                if (operandClassType.isRaw()) {
                    return true;
                }
                if (castClass.isInheritor(operandClass, true)) {
                    PsiSubstitutor castSubstitutor = castResult.getSubstitutor();
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory(castClass.getProject());
                    for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(castClass)) {
                        PsiSubstitutor modifiedSubstitutor;
                        PsiClassType otherType;
                        if (typeParameter.getOwner() instanceof PsiMethod || !TypeConversionUtil.isAssignable(operandType, otherType = factory.createType(castClass, modifiedSubstitutor = castSubstitutor.put(typeParameter, null)), false)) continue;
                        return true;
                    }
                    PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(operandClass, castClass, castResult.getSubstitutor());
                    PsiSubstitutor operandSubstitutor = operandResult.getSubstitutor();
                    PsiClass superClass = operandResult.getElement();
                    if (superClass == null) {
                        return true;
                    }
                    HashSet<PsiTypeParameter> capturedWildcardType = new HashSet<PsiTypeParameter>();
                    for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(operandClass)) {
                        if (parameter.getOwner() instanceof PsiMethod) continue;
                        PsiType operandParameterType = operandSubstitutor.substitute(parameter);
                        if (operandParameterType instanceof PsiCapturedWildcardType) {
                            capturedWildcardType.add(parameter);
                        }
                        PsiType superParameterType = superSubstitutor.substitute(parameter);
                        if (operandParameterType == null || superParameterType == null || TypeConversionUtil.typesAgree(superParameterType, operandParameterType, false)) continue;
                        return true;
                    }
                    return !JavaGenericsUtil.capturedWildcardTypesAreNotMerged(capturedWildcardType, operandClass, castClass);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean capturedWildcardTypesAreNotMerged(Set<PsiTypeParameter> capturedSuperClassTypes, PsiClass superClass, PsiClass derivedClass) {
        if (capturedSuperClassTypes.isEmpty()) {
            return true;
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, derivedClass, PsiSubstitutor.EMPTY);
        if (substitutor == PsiSubstitutor.EMPTY) {
            return true;
        }
        HashSet<String> capturedSourceTypeParameters = new HashSet<String>();
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(superClass)) {
            PsiClass resolved;
            PsiType substituted;
            if (!capturedSuperClassTypes.contains(parameter) || !((substituted = substitutor.substitute(parameter)) instanceof PsiClassType) || !((resolved = ((PsiClassType)substituted).resolve()) instanceof PsiTypeParameter)) continue;
            PsiTypeParameter typeParameter = (PsiTypeParameter)resolved;
            if (capturedSourceTypeParameters.contains(typeParameter.getName())) {
                return false;
            }
            capturedSourceTypeParameters.add(typeParameter.getName());
        }
        return true;
    }

    public static boolean isRawToGeneric(PsiType lType, PsiType rType) {
        if (lType instanceof PsiPrimitiveType || rType instanceof PsiPrimitiveType) {
            return false;
        }
        if (lType.equals(rType)) {
            return false;
        }
        if (lType instanceof PsiArrayType && rType instanceof PsiArrayType) {
            return JavaGenericsUtil.isRawToGeneric(((PsiArrayType)lType).getComponentType(), ((PsiArrayType)rType).getComponentType());
        }
        if (lType instanceof PsiArrayType || rType instanceof PsiArrayType) {
            return false;
        }
        if (rType instanceof PsiIntersectionType) {
            for (PsiType type : ((PsiIntersectionType)rType).getConjuncts()) {
                if (!JavaGenericsUtil.isRawToGeneric(lType, type)) continue;
                return true;
            }
            return false;
        }
        if (lType instanceof PsiIntersectionType) {
            for (PsiType type : ((PsiIntersectionType)lType).getConjuncts()) {
                if (!JavaGenericsUtil.isRawToGeneric(type, rType)) continue;
                return true;
            }
            return false;
        }
        if (rType instanceof PsiCapturedWildcardType) {
            return JavaGenericsUtil.isRawToGeneric(lType, ((PsiCapturedWildcardType)rType).getUpperBound());
        }
        if (!(lType instanceof PsiClassType) || !(rType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType.ClassResolveResult lResolveResult = ((PsiClassType)lType).resolveGenerics();
        PsiClassType.ClassResolveResult rResolveResult = ((PsiClassType)rType).resolveGenerics();
        PsiClass lClass = lResolveResult.getElement();
        PsiClass rClass = rResolveResult.getElement();
        if (rClass instanceof PsiAnonymousClass) {
            return JavaGenericsUtil.isRawToGeneric(lType, ((PsiAnonymousClass)rClass).getBaseClassType());
        }
        PsiSubstitutor lSubstitutor = lResolveResult.getSubstitutor();
        PsiSubstitutor rSubstitutor = rResolveResult.getSubstitutor();
        if (lClass == null || rClass == null) {
            return false;
        }
        if (lClass instanceof PsiTypeParameter && !InheritanceUtil.isInheritorOrSelf(rClass, lClass, true)) {
            return true;
        }
        if (!lClass.getManager().areElementsEquivalent((PsiElement)lClass, (PsiElement)rClass)) {
            if (lClass.isInheritor(rClass, true)) {
                lSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(rClass, lClass, lSubstitutor);
                lClass = rClass;
            } else if (rClass.isInheritor(lClass, true)) {
                rSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(lClass, rClass, rSubstitutor);
                rClass = lClass;
            } else {
                return false;
            }
        }
        Iterator<PsiTypeParameter> lIterator = PsiUtil.typeParametersIterator(lClass);
        Iterator<PsiTypeParameter> rIterator = PsiUtil.typeParametersIterator(rClass);
        while (lIterator.hasNext()) {
            if (!rIterator.hasNext()) {
                return false;
            }
            PsiTypeParameter lParameter = lIterator.next();
            PsiTypeParameter rParameter = rIterator.next();
            PsiType lTypeArg = lSubstitutor.substitute(lParameter);
            PsiType rTypeArg = rSubstitutor.substituteWithBoundsPromotion(rParameter);
            if (lTypeArg == null) continue;
            if (rTypeArg == null) {
                if (lTypeArg instanceof PsiWildcardType && ((PsiWildcardType)lTypeArg).getBound() == null) continue;
                return true;
            }
            if (TypeConversionUtil.typesAgree(lTypeArg, rTypeArg, true)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiType getCollectionItemType(@NotNull PsiExpression expression) {
        if (expression == null) {
            JavaGenericsUtil.$$$reportNull$$$0(5);
        }
        return JavaGenericsUtil.getCollectionItemType(expression.getType(), expression.getResolveScope());
    }

    public static @Nullable List<@NotNull PsiType> getParentParameterTypeListFromDerivedType(@Nullable PsiType baseType, @Nullable PsiType derivedType) {
        if (derivedType instanceof PsiClassType) {
            PsiClass baseClass = PsiTypesUtil.getPsiClass(baseType);
            if (baseClass == null) {
                return null;
            }
            PsiClassType.ClassResolveResult resolveResult = JavaGenericsUtil.getDerivedClassTypeResolveResult((PsiClassType)derivedType);
            PsiClass derivedClass = resolveResult.getElement();
            if (derivedClass == null) {
                return null;
            }
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            Object[] parameters = baseClass.getTypeParameters();
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getClassSubstitutor(baseClass, derivedClass, substitutor);
            if (superClassSubstitutor == null) {
                return null;
            }
            return ContainerUtil.map((Object[])parameters, typeParameter -> {
                PsiType substitutedType = superClassSubstitutor.substitute((PsiTypeParameter)typeParameter);
                return substitutedType == null ? PsiType.getJavaLangObject(derivedClass.getManager(), derivedClass.getResolveScope()) : substitutedType;
            });
        }
        if (derivedType instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)derivedType).getConjuncts()) {
                List<@NotNull PsiType> candidates = JavaGenericsUtil.getParentParameterTypeListFromDerivedType(baseType, conjunct);
                if (candidates == null) continue;
                return candidates;
            }
        }
        return null;
    }

    @NotNull
    private static PsiClassType.ClassResolveResult getDerivedClassTypeResolveResult(PsiClassType derivedType) {
        PsiClassType.ClassResolveResult resolveResult = derivedType.resolveGenerics();
        PsiClass derivedClass = resolveResult.getElement();
        if (derivedClass instanceof PsiTypeParameter) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)derivedClass;
            PsiClassType[] types = typeParameter.getExtendsListTypes();
            if (types.length > 1) {
                PsiClassType.ClassResolveResult classResolveResult = PsiClassType.ClassResolveResult.EMPTY;
                if (classResolveResult == null) {
                    JavaGenericsUtil.$$$reportNull$$$0(6);
                }
                return classResolveResult;
            }
            if (types.length == 1) {
                PsiClassType.ClassResolveResult classResolveResult = types[0].resolveGenerics();
                if (classResolveResult == null) {
                    JavaGenericsUtil.$$$reportNull$$$0(7);
                }
                return classResolveResult;
            }
        }
        PsiClassType.ClassResolveResult classResolveResult = resolveResult;
        if (classResolveResult == null) {
            JavaGenericsUtil.$$$reportNull$$$0(8);
        }
        return classResolveResult;
    }

    @Nullable
    public static PsiType getCollectionItemType(@Nullable PsiType type, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            JavaGenericsUtil.$$$reportNull$$$0(9);
        }
        if (type instanceof PsiArrayType) {
            return ((PsiArrayType)type).getComponentType();
        }
        if (type instanceof PsiClassType) {
            PsiTypeParameter typeParameter;
            PsiClass myClass;
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type).resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass == null) {
                return null;
            }
            PsiManager manager = aClass.getManager();
            String qName = aClass.getQualifiedName();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            JavaPsiFacade facade = JavaPsiFacade.getInstance(manager.getProject());
            if (qName != null && (myClass = facade.findClass(qName, scope)) != null && myClass != aClass) {
                PsiTypeParameter thisTypeParameter = JavaGenericsUtil.getIterableTypeParameter(facade, myClass);
                if (thisTypeParameter == null) {
                    return null;
                }
                PsiTypeParameter thatTypeParameter = JavaGenericsUtil.getIterableTypeParameter(facade, aClass);
                if (thatTypeParameter != null) {
                    substitutor = substitutor.put(thisTypeParameter, substitutor.substitute(thatTypeParameter));
                }
                aClass = myClass;
            }
            if ((typeParameter = JavaGenericsUtil.getIterableTypeParameter(facade, aClass)) == null) {
                return null;
            }
            PsiClass owner = (PsiClass)typeParameter.getOwner();
            if (owner == null) {
                return null;
            }
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getClassSubstitutor(owner, aClass, substitutor);
            if (superClassSubstitutor == null) {
                return null;
            }
            PsiType itemType = superClassSubstitutor.substitute(typeParameter);
            return itemType == null ? PsiType.getJavaLangObject(manager, aClass.getResolveScope()) : itemType;
        }
        if (type instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)type).getConjuncts()) {
                PsiType itemType = JavaGenericsUtil.getCollectionItemType(conjunct, scope);
                if (itemType == null) continue;
                return itemType;
            }
        }
        if (type instanceof PsiCapturedWildcardType) {
            return JavaGenericsUtil.getCollectionItemType(((PsiCapturedWildcardType)type).getUpperBound(), scope);
        }
        return null;
    }

    @Nullable
    private static PsiTypeParameter getIterableTypeParameter(JavaPsiFacade facade, PsiClass context) {
        PsiClass iterable = facade.findClass("java.lang.Iterable", context.getResolveScope());
        if (iterable == null) {
            return null;
        }
        PsiTypeParameter[] typeParameters = iterable.getTypeParameters();
        if (typeParameters.length != 1) {
            return null;
        }
        return typeParameters[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operandType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/JavaGenericsUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/JavaGenericsUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDerivedClassTypeResolveResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUncheckedWarning";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUncheckedCast";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionItemType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

