/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnnamedPattern;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.source.ClassReferencePointer;
import com.intellij.psi.impl.source.JavaVarTypeUtil;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiDiamondTypeElementImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class PsiTypeElementImpl
extends CompositePsiElement
implements PsiTypeElement {
    public PsiTypeElementImpl() {
        this(JavaElementType.TYPE);
    }

    PsiTypeElementImpl(@NotNull IElementType type) {
        if (type == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(0);
        }
        super(type);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeElement(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = (PsiType)CachedValuesManager.getProjectPsiDependentCache((PsiElement)this, __ -> this.calculateType());
        if (psiType == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(2);
        }
        return psiType;
    }

    @NotNull
    private PsiType calculateType() {
        PsiType inferredType = PsiAugmentProvider.getInferredType(this);
        if (inferredType != null) {
            PsiType psiType = inferredType;
            if (psiType == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(3);
            }
            return psiType;
        }
        PsiType type = null;
        boolean ellipsis = false;
        SmartList annotations = new SmartList();
        SmartList arrayComponentAnnotations = new SmartList();
        PsiElement parent = this.getParent();
        PsiElement firstChild = this.getFirstChild();
        if (firstChild == null && parent instanceof PsiUnnamedPattern) {
            type = JavaPsiPatternUtil.getDeconstructedImplicitPatternType((PsiPattern)parent);
        }
        for (PsiElement child = firstChild; child != null; child = child.getNextSibling()) {
            List<PsiType> types;
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                annotations.add((PsiAnnotation)child);
            } else if (child instanceof PsiTypeElement) {
                assert (type == null) : this;
                if (child instanceof PsiDiamondTypeElementImpl) {
                    type = new PsiDiamondTypeImpl((PsiManager)this.getManager(), this);
                    break;
                }
                type = ((PsiTypeElement)child).getType();
            } else if (PsiUtil.isJavaToken(child, ElementType.PRIMITIVE_TYPE_BIT_SET)) {
                assert (type == null) : this;
                String text = child.getText();
                type = annotations.isEmpty() ? PsiJavaParserFacadeImpl.getPrimitiveType(text) : new PsiPrimitiveType(text, PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations));
            } else if (PsiUtil.isJavaToken(child, JavaTokenType.VAR_KEYWORD)) {
                assert (type == null) : this;
                type = this.inferVarType(parent);
            } else if (child instanceof PsiJavaCodeReferenceElement) {
                assert (type == null) : this;
                type = new PsiClassReferenceType(PsiTypeElementImpl.getReferenceComputable((PsiJavaCodeReferenceElement)child), null, PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations));
            } else if (PsiUtil.isJavaToken(child, JavaTokenType.LBRACKET)) {
                assert (type != null) : this;
                arrayComponentAnnotations.add(PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations));
            } else if (PsiUtil.isJavaToken(child, JavaTokenType.ELLIPSIS)) {
                assert (type != null) : this;
                arrayComponentAnnotations.add(PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations));
                ellipsis = true;
            }
            if (PsiUtil.isJavaToken(child, JavaTokenType.QUEST)) {
                assert (type == null) : this;
                PsiElement boundKind = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)child);
                PsiElement boundType = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)boundKind);
                type = PsiUtil.isJavaToken(boundKind, JavaTokenType.EXTENDS_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createExtends((PsiManager)this.getManager(), ((PsiTypeElement)boundType).getType()) : (PsiUtil.isJavaToken(boundKind, JavaTokenType.SUPER_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createSuper((PsiManager)this.getManager(), ((PsiTypeElement)boundType).getType()) : PsiWildcardType.createUnbounded((PsiManager)this.getManager()));
                type = type.annotate(PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations));
                break;
            }
            if (child instanceof ASTNode) {
                ((ASTNode)child).getElementType();
            }
            if (PsiUtil.isJavaToken(child, JavaTokenType.AND)) {
                types = this.collectTypes();
                assert (!types.isEmpty()) : this;
                type = PsiIntersectionType.createIntersection(false, types.toArray(PsiType.createArray(types.size())));
                break;
            }
            if (!PsiUtil.isJavaToken(child, JavaTokenType.OR)) continue;
            types = this.collectTypes();
            assert (!types.isEmpty()) : this;
            type = PsiDisjunctionType.createDisjunction(types, (PsiManager)this.getManager());
            break;
        }
        if (type == null) {
            PsiType psiType = PsiTypes.nullType();
            if (psiType == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(4);
            }
            return psiType;
        }
        if (!arrayComponentAnnotations.isEmpty()) {
            type = PsiTypeElementImpl.createArray(type, (List<TypeAnnotationProvider>)arrayComponentAnnotations, ellipsis);
        }
        if (parent instanceof PsiModifierListOwner) {
            type = JavaSharedImplUtil.applyAnnotations(type, ((PsiModifierListOwner)parent).getModifierList());
        }
        PsiType psiType = type;
        if (psiType == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(5);
        }
        return psiType;
    }

    private static PsiType createArray(PsiType elementType, List<TypeAnnotationProvider> providers, boolean ellipsis) {
        PsiType result = elementType;
        for (int i = providers.size() - 1; i >= 0; --i) {
            TypeAnnotationProvider provider = providers.get(i);
            result = ellipsis && i == 0 ? new PsiEllipsisType(result, provider) : new PsiArrayType(result, provider);
        }
        providers.clear();
        return result;
    }

    private PsiType inferVarType(PsiElement parent) {
        if (parent instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)parent;
            if (parameter instanceof PsiPatternVariable) {
                return JavaPsiPatternUtil.getDeconstructedImplicitPatternVariableType((PsiPatternVariable)parameter);
            }
            PsiElement declarationScope = parameter.getDeclarationScope();
            if (declarationScope instanceof PsiForeachStatement) {
                PsiExpression iteratedValue = ((PsiForeachStatement)declarationScope).getIteratedValue();
                if (iteratedValue != null) {
                    PsiType type = JavaGenericsUtil.getCollectionItemType(iteratedValue);
                    return type != null ? JavaVarTypeUtil.getUpwardProjection(type) : null;
                }
                return null;
            }
            if (declarationScope instanceof PsiLambdaExpression) {
                return parameter.getType();
            }
        } else {
            for (PsiTypeElementImpl e = this; e != null; e = e.getNextSibling()) {
                if (!(e instanceof PsiExpression)) continue;
                if (!PsiTreeUtil.processElements((PsiElement)e, PsiReferenceExpression.class, ref -> !ref.isReferenceTo(parent))) {
                    return null;
                }
                if (!(e instanceof PsiArrayInitializerExpression)) {
                    PsiExpression expression = (PsiExpression)((Object)e);
                    RecursionGuard.StackStamp stamp = RecursionManager.markStack();
                    PsiType type = (PsiType)RecursionManager.doPreventingRecursion((Object)expression, (boolean)true, () -> expression.getType());
                    if (stamp.mayCacheNow()) {
                        return type == null ? null : JavaVarTypeUtil.getUpwardProjection(type);
                    }
                    return null;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isInferredType() {
        return PsiUtil.isJavaToken(this.getFirstChild(), JavaTokenType.VAR_KEYWORD) || PsiAugmentProvider.isInferredType(this);
    }

    @NotNull
    private static ClassReferencePointer getReferenceComputable(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement root;
        PsiElement parent;
        if (ref == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(6);
        }
        PsiElement psiElement = parent = (root = (PsiElement)SyntaxTraverser.psiApi().parents((Object)ref.getParent()).takeWhile(it -> it instanceof PsiTypeElement || it instanceof PsiReferenceParameterList || it instanceof PsiJavaCodeReferenceElement).last()) instanceof PsiTypeElement ? root.getParent() : null;
        if (parent instanceof PsiMethod || parent instanceof PsiVariable) {
            PsiModifierListOwner owner = (PsiModifierListOwner)parent;
            int[] pathFromRoot = PsiTypeElementImpl.getPathFromRoot(ref);
            return PsiTypeElementImpl.computeFromTypeOwner(owner, pathFromRoot, new WeakReference<PsiJavaCodeReferenceElement>(ref));
        }
        ClassReferencePointer classReferencePointer = ClassReferencePointer.constant(ref);
        if (classReferencePointer == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(7);
        }
        return classReferencePointer;
    }

    private static int[] getPathFromRoot(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement parent;
        block8: {
            if (ref == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(8);
            }
            IntArrayList result = null;
            while (true) {
                if ((parent = ref.getParent()) instanceof PsiJavaCodeReferenceElement) {
                    PsiJavaCodeReferenceElement parentRef = (PsiJavaCodeReferenceElement)parent;
                    if (parentRef.getQualifier() == ref) {
                        if (result == null) {
                            result = new IntArrayList();
                        }
                        result.add(0, -1);
                        ref = parentRef;
                        continue;
                    }
                    throw new IllegalStateException("Unexpected parent (going not from qualifier): " + parent.getText());
                }
                if (!(parent instanceof PsiTypeElement)) break block8;
                PsiElement nextParent = parent.getParent();
                while (nextParent instanceof PsiTypeElement) {
                    parent = nextParent;
                    nextParent = nextParent.getParent();
                }
                if (!(nextParent instanceof PsiReferenceParameterList)) break;
                PsiReferenceParameterList list = (PsiReferenceParameterList)nextParent;
                int index = ArrayUtil.indexOf((Object[])list.getTypeParameterElements(), (Object)parent);
                PsiElement nextRef = nextParent.getParent();
                if (!(nextRef instanceof PsiJavaCodeReferenceElement)) {
                    throw new IllegalStateException("Must be a reference: " + nextRef.getText());
                }
                ref = (PsiJavaCodeReferenceElement)nextRef;
                if (result == null) {
                    result = new IntArrayList();
                }
                result.add(0, index);
            }
            return result == null ? ArrayUtil.EMPTY_INT_ARRAY : result.toIntArray();
        }
        throw new IllegalStateException("Unexpected parent: " + parent.getText());
    }

    @Contract(value="_,_,true -> !null")
    @Nullable
    private static PsiJavaCodeReferenceElement findReference(@NotNull PsiType type, int[] root, boolean check) {
        if (type == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(9);
        }
        int offset = 0;
        while (true) {
            if (type instanceof PsiWildcardType) {
                PsiType bound = ((PsiWildcardType)type).getBound();
                if (bound == null) {
                    if (check) {
                        throw new IllegalStateException("Bound expected: " + type.getCanonicalText());
                    }
                    return null;
                }
                type = bound;
            }
            if (!((type = type.getDeepComponentType()) instanceof PsiClassReferenceType)) {
                if (check) {
                    throw new IllegalStateException("Reference type expected: " + type.getCanonicalText());
                }
                return null;
            }
            PsiClassReferenceType classType = (PsiClassReferenceType)type;
            PsiJavaCodeReferenceElement ref = classType.getReference();
            if (offset == root.length) {
                return ref;
            }
            int nextIndex = root[offset++];
            while (nextIndex == -1) {
                PsiElement qualifier = ref.getQualifier();
                if (!(qualifier instanceof PsiJavaCodeReferenceElement)) {
                    if (check) {
                        throw new IllegalStateException("Qualifier expected: " + ref.getCanonicalText());
                    }
                    return null;
                }
                ref = (PsiJavaCodeReferenceElement)qualifier;
                if (offset == root.length) {
                    return ref;
                }
                nextIndex = root[offset++];
            }
            PsiReferenceParameterList list = ref.getParameterList();
            if (list == null) {
                if (check) {
                    throw new IllegalStateException("Parameter list expected: " + ref.getCanonicalText());
                }
                return null;
            }
            PsiType[] arguments = list.getTypeArguments();
            if (nextIndex >= arguments.length) {
                if (check) {
                    throw new IllegalStateException("Type parameter #" + nextIndex + " expected: " + ref.getCanonicalText());
                }
                return null;
            }
            type = arguments[nextIndex];
        }
    }

    @NotNull
    private static ClassReferencePointer computeFromTypeOwner(final @NotNull PsiModifierListOwner parent, final int[] pathFromRoot, final @NotNull WeakReference<PsiJavaCodeReferenceElement> ref) {
        if (parent == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(10);
        }
        if (ref == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(11);
        }
        return new ClassReferencePointer(){

            @Contract(value="true -> !null")
            @Nullable
            private PsiJavaCodeReferenceElement retrieveReference(boolean check) {
                PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)ref.get();
                if (element != null && element.isValid()) {
                    return element;
                }
                if (check) {
                    PsiUtilCore.ensureValid((PsiElement)parent);
                }
                if (!parent.isValid()) {
                    return null;
                }
                PsiType type = PsiUtil.getTypeByPsiElement(parent);
                if (type == null) {
                    if (check) {
                        throw new IllegalStateException("Type of " + parent.getClass() + " is null");
                    }
                    return null;
                }
                return PsiTypeElementImpl.findReference(type, pathFromRoot, check);
            }

            @Override
            @Nullable
            public PsiJavaCodeReferenceElement retrieveReference() {
                return this.retrieveReference(false);
            }

            @Override
            @NotNull
            public PsiJavaCodeReferenceElement retrieveNonNullReference() {
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = this.retrieveReference(true);
                if (psiJavaCodeReferenceElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiJavaCodeReferenceElement;
            }

            public String toString() {
                String msg = "Type element reference of " + parent.getClass() + " #" + parent.getClass().getSimpleName() + ", path=" + Arrays.toString(pathFromRoot);
                return parent.isValid() ? msg + " #" + parent.getLanguage() : msg + ", invalid";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl$1", "retrieveNonNullReference"));
            }
        };
    }

    @NotNull
    private static TypeAnnotationProvider createProvider(@NotNull List<PsiAnnotation> annotations) {
        if (annotations == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(12);
        }
        TypeAnnotationProvider typeAnnotationProvider = TypeAnnotationProvider.Static.create((PsiAnnotation[])ContainerUtil.copyAndClear(annotations, PsiAnnotation.ARRAY_FACTORY, (boolean)true));
        if (typeAnnotationProvider == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(13);
        }
        return typeAnnotationProvider;
    }

    private @Unmodifiable @NotNull List<PsiType> collectTypes() {
        List typeElements = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PsiTypeElement.class);
        List list = ContainerUtil.map((Collection)typeElements, typeElement -> typeElement.getType());
        if (list == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        TreeElement firstChildNode = this.getFirstChildNode();
        if (firstChildNode == null) {
            return null;
        }
        if (firstChildNode.getElementType() == JavaElementType.TYPE) {
            return ((PsiTypeElement)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)firstChildNode)).getInnermostComponentReferenceElement();
        }
        return this.getReferenceElement();
    }

    @Nullable
    private PsiJavaCodeReferenceElement getReferenceElement() {
        ASTNode ref = this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
        if (ref == null) {
            return null;
        }
        return (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi((ASTNode)ref);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(15);
        }
        if (state == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(16);
        }
        if (place == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(17);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        return true;
    }

    @Override
    public PsiAnnotation @NotNull [] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getType().getAnnotations();
        if (psiAnnotationArray == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(18);
        }
        return psiAnnotationArray;
    }

    @Override
    public boolean hasAnnotations() {
        return this.getType().hasAnnotations();
    }

    @Override
    public PsiAnnotation @NotNull [] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(19);
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(20);
        }
        return PsiImplUtil.findAnnotation(this, qualifiedName);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        PsiModifierList modifierList;
        PsiIdentifier identifier;
        if (qualifiedName == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(21);
        }
        PsiAnnotation annotation = JavaPsiFacade.getElementFactory(this.getProject()).createAnnotationFromText('@' + qualifiedName, this);
        PsiElement firstChild = this.getFirstChild();
        for (PsiElement child = this.getLastChild(); child != firstChild; child = child.getPrevSibling()) {
            if (!PsiUtil.isJavaToken(child, JavaTokenType.LBRACKET) && !PsiUtil.isJavaToken(child, JavaTokenType.ELLIPSIS)) continue;
            PsiAnnotation psiAnnotation = (PsiAnnotation)this.addBefore(annotation, child);
            if (psiAnnotation == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(22);
            }
            return psiAnnotation;
        }
        if (firstChild instanceof PsiJavaCodeReferenceElement && (identifier = (PsiIdentifier)PsiTreeUtil.getChildOfType((PsiElement)firstChild, PsiIdentifier.class)) != null && identifier != firstChild.getFirstChild()) {
            PsiAnnotation psiAnnotation = (PsiAnnotation)firstChild.addBefore((PsiElement)annotation, (PsiElement)identifier);
            if (psiAnnotation == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(23);
            }
            return psiAnnotation;
        }
        PsiElement parent = this.getParent();
        while (parent instanceof PsiTypeElement && ((PsiTypeElement)parent).getType() instanceof PsiArrayType) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiModifierListOwner && (modifierList = ((PsiModifierListOwner)parent).getModifierList()) != null) {
            PsiTypeParameterList list;
            PsiTypeParameterList psiTypeParameterList = list = parent instanceof PsiTypeParameterListOwner ? ((PsiTypeParameterListOwner)parent).getTypeParameterList() : null;
            if (list == null || list.textMatches("")) {
                PsiAnnotation psiAnnotation = (PsiAnnotation)modifierList.add(annotation);
                if (psiAnnotation == null) {
                    PsiTypeElementImpl.$$$reportNull$$$0(24);
                }
                return psiAnnotation;
            }
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)this.addBefore(annotation, firstChild);
        if (psiAnnotation == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(25);
        }
        return psiAnnotation;
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        PsiElement result;
        if (newElement == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(26);
        }
        if (!(newElement instanceof PsiTypeElement) || !((PsiTypeElement)newElement).isInferredType()) {
            PsiImplUtil.markTypeAnnotations(this);
        }
        if ((result = super.replace(newElement)) instanceof PsiTypeElement) {
            PsiImplUtil.deleteTypeAnnotations((PsiTypeElement)result);
        }
        return result;
    }

    @Override
    public boolean acceptsAnnotations() {
        if (this.isInferredType()) {
            return false;
        }
        PsiType type = this.getType();
        return !PsiTypes.voidType().equals(type) && !PsiTypes.nullType().equals(type);
    }

    public PsiElement getOriginalElement() {
        PsiElement originalMethod;
        PsiElement originalVariable;
        PsiElement parent = this.getParent();
        if (parent instanceof PsiVariable && (originalVariable = parent.getOriginalElement()) != parent && originalVariable instanceof PsiVariable) {
            return ((PsiVariable)originalVariable).getTypeElement();
        }
        if (parent instanceof PsiMethod && (originalMethod = parent.getOriginalElement()) != parent && originalMethod instanceof PsiMethod) {
            return ((PsiMethod)originalMethod).getReturnTypeElement();
        }
        if (parent instanceof PsiTypeElement || parent instanceof PsiJavaCodeReferenceElement || parent instanceof PsiReferenceParameterList) {
            return PsiImplUtil.getCorrespondingOriginalElementOfType(this, PsiTypeElement.class);
        }
        return this;
    }

    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiTypeElementImpl";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiTypeElementImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceComputable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createProvider";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "addAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceComputable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPathFromRoot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findReference";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeFromTypeOwner";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createProvider";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

