/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullabilitySource;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.TypeNullability;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class JavaTypeNullabilityUtil {
    @NotNull
    public static TypeNullability getTypeNullability(@NotNull PsiClassType type) {
        if (type == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(0);
        }
        return JavaTypeNullabilityUtil.getTypeNullability(type, null, !JavaTypeNullabilityUtil.isLocal(type));
    }

    @NotNull
    private static TypeNullability getTypeNullability(@NotNull PsiClassType type, @Nullable Set<PsiClassType> visited, boolean checkContainer) {
        NullabilityAnnotationInfo typeUseNullability;
        NullableNotNullManager manager;
        if (type == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(1);
        }
        if (visited != null && visited.contains(type)) {
            TypeNullability typeNullability = TypeNullability.UNKNOWN;
            if (typeNullability == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(2);
            }
            return typeNullability;
        }
        TypeNullability fromAnnotations = JavaTypeNullabilityUtil.getNullabilityFromAnnotations(type.getAnnotations());
        if (!fromAnnotations.equals(TypeNullability.UNKNOWN)) {
            TypeNullability typeNullability = fromAnnotations;
            if (typeNullability == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(3);
            }
            return typeNullability;
        }
        PsiElement context = type.getPsiContext();
        if (context != null && checkContainer && (manager = NullableNotNullManager.getInstance(context.getProject())) != null && (typeUseNullability = manager.findDefaultTypeUseNullability(context)) != null) {
            TypeNullability typeNullability = typeUseNullability.toTypeNullability();
            if (typeNullability == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(4);
            }
            return typeNullability;
        }
        PsiClass target = type.resolve();
        if (target instanceof PsiTypeParameter) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)target;
            PsiReferenceList extendsList = typeParameter.getExtendsList();
            Object[] extendTypes = extendsList.getReferencedTypes();
            if (extendTypes.length == 0 && checkContainer) {
                NullabilityAnnotationInfo typeUseNullability2;
                NullableNotNullManager manager2 = NullableNotNullManager.getInstance(typeParameter.getProject());
                NullabilityAnnotationInfo nullabilityAnnotationInfo = typeUseNullability2 = manager2 == null ? null : manager2.findDefaultTypeUseNullability(typeParameter);
                if (typeUseNullability2 != null) {
                    TypeNullability typeNullability = typeUseNullability2.toTypeNullability().inherited();
                    if (typeNullability == null) {
                        JavaTypeNullabilityUtil.$$$reportNull$$$0(5);
                    }
                    return typeNullability;
                }
            } else {
                HashSet<PsiClassType> nextVisited = visited == null ? new HashSet<PsiClassType>() : visited;
                nextVisited.add(type);
                List nullabilities = ContainerUtil.map((Object[])extendTypes, t -> JavaTypeNullabilityUtil.getTypeNullability(t, nextVisited, checkContainer));
                TypeNullability typeNullability = TypeNullability.intersect(nullabilities).inherited();
                if (typeNullability == null) {
                    JavaTypeNullabilityUtil.$$$reportNull$$$0(6);
                }
                return typeNullability;
            }
        }
        TypeNullability typeNullability = TypeNullability.UNKNOWN;
        if (typeNullability == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(7);
        }
        return typeNullability;
    }

    private static boolean isLocal(PsiClassType classType) {
        PsiElement context = classType.getPsiContext();
        return context instanceof PsiJavaCodeReferenceElement && context.getParent() instanceof PsiTypeElement && context.getParent().getParent() instanceof PsiLocalVariable;
    }

    @NotNull
    public static TypeNullability getNullabilityFromAnnotations(@NotNull @NotNull PsiAnnotation @NotNull [] annotations) {
        if (annotations == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(8);
        }
        for (PsiAnnotation annotation : annotations) {
            String qualifiedName = annotation.getQualifiedName();
            NullableNotNullManager manager = NullableNotNullManager.getInstance(annotation.getProject());
            if (manager == null) {
                TypeNullability typeNullability = TypeNullability.UNKNOWN;
                if (typeNullability == null) {
                    JavaTypeNullabilityUtil.$$$reportNull$$$0(9);
                }
                return typeNullability;
            }
            Optional<Nullability> optionalNullability = manager.getAnnotationNullability(qualifiedName);
            if (!optionalNullability.isPresent()) continue;
            Nullability nullability = optionalNullability.get();
            return new TypeNullability(nullability, new NullabilitySource.ExplicitAnnotation(annotation));
        }
        TypeNullability typeNullability = TypeNullability.UNKNOWN;
        if (typeNullability == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(10);
        }
        return typeNullability;
    }

    @NotNull
    public static NullabilityConflict getNullabilityConflictInAssignment(@Nullable PsiType leftType, @Nullable PsiType rightType, boolean checkNotNullToNull) {
        return JavaTypeNullabilityUtil.getNullabilityConflictInAssignment(leftType, rightType, checkNotNullToNull, false);
    }

    @NotNull
    private static NullabilityConflict getNullabilityConflictInAssignment(@Nullable PsiType leftType, @Nullable PsiType rightType, boolean checkNotNullToNull, boolean checkConflictInInitialType) {
        NullabilityConflict nullabilityConflict;
        if (checkConflictInInitialType && JavaTypeNullabilityUtil.isAllowedNullabilityConflictType(checkNotNullToNull, nullabilityConflict = JavaTypeNullabilityUtil.getNullabilityConflictType(leftType, rightType))) {
            NullabilityConflict nullabilityConflict2 = nullabilityConflict;
            if (nullabilityConflict2 == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(11);
            }
            return nullabilityConflict2;
        }
        if (leftType == null || TypeConversionUtil.isNullType(leftType) || rightType == null || TypeConversionUtil.isNullType(rightType)) {
            NullabilityConflict nullabilityConflict3 = NullabilityConflict.UNKNOWN;
            if (nullabilityConflict3 == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(12);
            }
            return nullabilityConflict3;
        }
        if (rightType instanceof PsiIntersectionType) {
            return JavaTypeNullabilityUtil.getNullabilityConflictInTypeArguments(leftType, rightType, checkNotNullToNull);
        }
        if (rightType instanceof PsiCapturedWildcardType) {
            return JavaTypeNullabilityUtil.getNullabilityConflictInAssignment(leftType, ((PsiCapturedWildcardType)rightType).getUpperBound(true), checkNotNullToNull, false);
        }
        if (leftType instanceof PsiCapturedWildcardType) {
            return JavaTypeNullabilityUtil.getNullabilityConflictInAssignment(((PsiCapturedWildcardType)leftType).getLowerBound(), rightType, checkNotNullToNull, false);
        }
        if (leftType instanceof PsiWildcardType) {
            return JavaTypeNullabilityUtil.getNullabilityConflictInAssignment(GenericsUtil.getWildcardBound(leftType), rightType, checkNotNullToNull, false);
        }
        if (rightType instanceof PsiWildcardType) {
            return JavaTypeNullabilityUtil.getNullabilityConflictInAssignment(leftType, GenericsUtil.getWildcardBound(rightType), checkNotNullToNull, false);
        }
        if (leftType instanceof PsiArrayType && rightType instanceof PsiArrayType) {
            return JavaTypeNullabilityUtil.getNullabilityConflictInAssignment(((PsiArrayType)leftType).getComponentType(), ((PsiArrayType)rightType).getComponentType(), checkNotNullToNull, true);
        }
        if (!(leftType instanceof PsiClassType) || !(rightType instanceof PsiClassType)) {
            NullabilityConflict nullabilityConflict4 = NullabilityConflict.UNKNOWN;
            if (nullabilityConflict4 == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(13);
            }
            return nullabilityConflict4;
        }
        return JavaTypeNullabilityUtil.getNullabilityConflictInTypeArguments(leftType, rightType, checkNotNullToNull);
    }

    @NotNull
    private static NullabilityConflict getNullabilityConflictInTypeArguments(@NotNull PsiType leftType, @NotNull PsiType rightType, boolean checkNotNullToNull) {
        if (leftType == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(14);
        }
        if (rightType == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(15);
        }
        List<PsiType> leftParameterTypeList = JavaGenericsUtil.getParentParameterTypeListFromDerivedType(leftType, leftType);
        List<PsiType> rightParameterTypeList = JavaGenericsUtil.getParentParameterTypeListFromDerivedType(leftType, rightType);
        if (leftParameterTypeList == null || rightParameterTypeList == null || leftParameterTypeList.size() != rightParameterTypeList.size()) {
            NullabilityConflict nullabilityConflict = NullabilityConflict.UNKNOWN;
            if (nullabilityConflict == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(16);
            }
            return nullabilityConflict;
        }
        for (int i = 0; i < leftParameterTypeList.size(); ++i) {
            PsiType rightParameterType;
            PsiType leftParameterType = leftParameterTypeList.get(i);
            NullabilityConflict nullabilityConflict = JavaTypeNullabilityUtil.getNullabilityConflictInAssignment(leftParameterType, rightParameterType = rightParameterTypeList.get(i), checkNotNullToNull, true);
            if (nullabilityConflict == NullabilityConflict.UNKNOWN) continue;
            NullabilityConflict nullabilityConflict2 = nullabilityConflict;
            if (nullabilityConflict2 == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(17);
            }
            return nullabilityConflict2;
        }
        NullabilityConflict nullabilityConflict = NullabilityConflict.UNKNOWN;
        if (nullabilityConflict == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(18);
        }
        return nullabilityConflict;
    }

    private static boolean isAllowedNullabilityConflictType(boolean checkNotNullToNull, @NotNull NullabilityConflict nullabilityConflict) {
        if (nullabilityConflict == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(19);
        }
        return nullabilityConflict != NullabilityConflict.UNKNOWN && (checkNotNullToNull || nullabilityConflict != NullabilityConflict.NOT_NULL_TO_NULL);
    }

    @NotNull
    public static NullabilityConflict getNullabilityConflictType(@Nullable PsiType leftType, @Nullable PsiType rightType) {
        if (leftType == null || rightType == null) {
            NullabilityConflict nullabilityConflict = NullabilityConflict.UNKNOWN;
            if (nullabilityConflict == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(20);
            }
            return nullabilityConflict;
        }
        TypeNullability leftTypeNullability = leftType.getNullability();
        TypeNullability rightTypeNullability = rightType.getNullability();
        Nullability leftNullability = leftTypeNullability.nullability();
        Nullability rightNullability = rightTypeNullability.nullability();
        if (leftNullability == Nullability.NOT_NULL && rightNullability == Nullability.NULLABLE) {
            NullabilityConflict nullabilityConflict = NullabilityConflict.NULL_TO_NOT_NULL;
            if (nullabilityConflict == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(21);
            }
            return nullabilityConflict;
        }
        if (leftNullability == Nullability.NULLABLE && rightNullability == Nullability.NOT_NULL && !GenericsUtil.isWildcardWithExtendsBound(leftType)) {
            NullabilityConflict nullabilityConflict = NullabilityConflict.NOT_NULL_TO_NULL;
            if (nullabilityConflict == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(22);
            }
            return nullabilityConflict;
        }
        NullabilityConflict nullabilityConflict = NullabilityConflict.UNKNOWN;
        if (nullabilityConflict == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(23);
        }
        return nullabilityConflict;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/JavaTypeNullabilityUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullabilityConflict";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/JavaTypeNullabilityUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeNullability";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullabilityFromAnnotations";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullabilityConflictInAssignment";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullabilityConflictInTypeArguments";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullabilityConflictType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeNullability";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNullabilityFromAnnotations";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNullabilityConflictInTypeArguments";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isAllowedNullabilityConflictType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum NullabilityConflict {
        NULL_TO_NOT_NULL,
        NOT_NULL_TO_NULL,
        UNKNOWN;

    }
}

