/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtilCore;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.impl.CssAdvancedElementTypes;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssBlockImpl
extends LazyParseablePsiElement
implements CssBlock {
    private static final Hash.Strategy<CssDeclaration> ourStrategy = new Hash.Strategy<CssDeclaration>(){

        public int hashCode(CssDeclaration object) {
            return object == null ? 0 : object.equalityHashCode();
        }

        public boolean equals(CssDeclaration o1, CssDeclaration o2) {
            return o1 == o2 || o1 != null && o2 != null && o1.isEqualTo((Object)o2);
        }
    };

    CssBlockImpl(CharSequence text) {
        this(text, (IElementType)CssAdvancedElementTypes.CSS_DECLARATION_BLOCK);
    }

    CssBlockImpl(CharSequence text, IElementType type) {
        super(type, text);
    }

    public CssRuleset @NotNull [] getRulesets() {
        CssRuleset[] cssRulesetArray = (CssRuleset[])this.getChildrenAsPsiElements(CssElementTypes.CSS_RULESET, CssRuleset.ARRAY_FACTORY);
        if (cssRulesetArray == null) {
            CssBlockImpl.$$$reportNull$$$0(0);
        }
        return cssRulesetArray;
    }

    public CssDeclaration @NotNull [] getDeclarations() {
        CssDeclaration[] cssDeclarationArray = (CssDeclaration[])this.getChildrenAsPsiElements(CssElementTypes.CSS_DECLARATION, CssDeclaration.ARRAY_FACTORY);
        if (cssDeclarationArray == null) {
            CssBlockImpl.$$$reportNull$$$0(1);
        }
        return cssDeclarationArray;
    }

    @NotNull
    public Language getLanguage() {
        Language language = CssElement.getLanguageOf((CssElement)this);
        if (language == null) {
            CssBlockImpl.$$$reportNull$$$0(2);
        }
        return language;
    }

    public boolean isEqualTo(Object object) {
        if (!(object instanceof CssBlockImpl)) {
            return false;
        }
        CssBlockImpl block = (CssBlockImpl)((Object)object);
        Set<CssDeclaration> set1 = CssBlockImpl.getDeclarationsHashSet(this);
        Set<CssDeclaration> set2 = CssBlockImpl.getDeclarationsHashSet(block);
        return set1.equals(set2);
    }

    @Nullable
    public PsiElement getLBrace() {
        ASTNode node;
        PsiElement firstChild = PsiTreeUtil.getDeepestFirst((PsiElement)this);
        if (firstChild instanceof PsiWhiteSpace) {
            firstChild = PsiTreeUtil.nextVisibleLeaf((PsiElement)firstChild);
        }
        if (firstChild != null && (node = firstChild.getNode()) != null && node.getElementType() == CssElementTypes.CSS_LBRACE) {
            return firstChild;
        }
        return null;
    }

    @Nullable
    public PsiElement getRBrace() {
        ASTNode node;
        PsiElement lastChild = PsiTreeUtil.getDeepestLast((PsiElement)this);
        if (lastChild instanceof PsiWhiteSpace) {
            lastChild = PsiTreeUtil.prevVisibleLeaf((PsiElement)lastChild);
        }
        if (lastChild != null && (node = lastChild.getNode()) != null && node.getElementType() == CssElementTypes.CSS_RBRACE) {
            return lastChild;
        }
        return null;
    }

    private static Set<CssDeclaration> getDeclarationsHashSet(CssBlockImpl block) {
        return new ObjectOpenCustomHashSet((Object[])block.getDeclarations(), ourStrategy);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            CssBlockImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssBlock(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Nullable
    public CssDeclaration findDeclaration(@NotNull String propertyName) {
        if (propertyName == null) {
            CssBlockImpl.$$$reportNull$$$0(4);
        }
        return this.findDeclaration(propertyName, true);
    }

    @Nullable
    public CssDeclaration findDeclaration(@NotNull String propertyName, boolean searchInShorthand) {
        if (propertyName == null) {
            CssBlockImpl.$$$reportNull$$$0(5);
        }
        return CssPsiUtilCore.findDeclaration(this, propertyName, searchInShorthand);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssBlockImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRulesets";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssBlockImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

