/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.typed;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.stubs.JSFrameworkMarkersIndex;
import com.intellij.lang.javascript.psi.stubs.JSStubElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptSingleTypeStub;
import com.intellij.lang.javascript.psi.stubs.TypeScriptTypeArgumentListStub;
import com.intellij.lang.javascript.psi.stubs.TypeScriptUnionOrIntersectionTypeStub;
import com.intellij.lang.javascript.psi.types.JSModuleTypeImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.modules.TypeScriptNodeSearchProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.model.VueComponent;
import org.jetbrains.vuejs.model.source.VueEntityDescriptor;
import org.jetbrains.vuejs.model.typed.VueTypedComponent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011J\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/vuejs/model/typed/VueTypedEntitiesProvider;", "", "<init>", "()V", "vueComponentTypenameRegex", "Lkotlin/text/Regex;", "isComponentDefinition", "", "definition", "Lcom/intellij/lang/javascript/psi/ecmal4/JSQualifiedNamedElement;", "checkType", "typeElement", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptType;", "checkTypeName", "typeName", "", "getComponentDescriptor", "Lorg/jetbrains/vuejs/model/source/VueEntityDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "getComponent", "Lorg/jetbrains/vuejs/model/typed/VueTypedComponent;", "descriptor", "calculateDtsComponents", "", "Lorg/jetbrains/vuejs/model/VueComponent;", "moduleDir", "Lcom/intellij/psi/PsiDirectory;", "VueTypedComponentDescriptor", "intellij.vuejs.backend"})
@SourceDebugExtension(value={"SMAP\nVueTypedEntitiesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueTypedEntitiesProvider.kt\norg/jetbrains/vuejs/model/typed/VueTypedEntitiesProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1#2:161\n19#3:162\n1869#4,2:163\n1869#4,2:165\n1869#4,2:167\n*S KotlinDebug\n*F\n+ 1 VueTypedEntitiesProvider.kt\norg/jetbrains/vuejs/model/typed/VueTypedEntitiesProvider\n*L\n42#1:162\n128#1:163,2\n145#1:165,2\n69#1:167,2\n*E\n"})
public final class VueTypedEntitiesProvider {
    @NotNull
    public static final VueTypedEntitiesProvider INSTANCE = new VueTypedEntitiesProvider();
    @NotNull
    private static final Regex vueComponentTypenameRegex = new Regex("(import\\s*\\(\\s*['\"]vue['\"]\\s*\\)\\s*\\.\\s*|vue\\s*\\.\\s*)?(DefineComponent|ComponentOptionsBase|ComponentOptionsMixin|ComponentCustomProps|__VLS_WithTemplateSlots|__VLS_WithSlots(\\$[0-9]+)?)");

    private VueTypedEntitiesProvider() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isComponentDefinition(@NotNull JSQualifiedNamedElement definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        if (definition.getName() == null) return false;
        if (definition instanceof JSField) {
            return false;
        }
        JSQualifiedNamedElement jSQualifiedNamedElement = definition;
        if (jSQualifiedNamedElement instanceof TypeScriptVariable) {
            TypeScriptTypeAlias typeScriptTypeAlias;
            void $this$asSafely$iv;
            TypeScriptType typeScriptType = ((TypeScriptVariable)definition).getTypeElement();
            if (typeScriptType == null) {
                return false;
            }
            TypeScriptType typeElement = typeScriptType;
            if (this.checkType(typeElement)) {
                return true;
            }
            if (!(typeElement instanceof TypeScriptSingleType)) return false;
            String string = ((TypeScriptSingleType)typeElement).getQualifiedTypeName();
            if (string == null) return false;
            String it = string;
            boolean bl = false;
            PsiElement psiElement = JSStubBasedPsiTreeUtil.resolveLocally((String)it, (PsiElement)((PsiElement)typeElement));
            if (psiElement == null) return false;
            it = psiElement;
            boolean $i$f$asSafely = false;
            Object v1 = $this$asSafely$iv;
            if (!(v1 instanceof TypeScriptTypeAlias)) {
                v1 = null;
            }
            if ((typeScriptTypeAlias = (TypeScriptTypeAlias)v1) == null) return false;
            TypeScriptType typeScriptType2 = typeScriptTypeAlias.getTypeDeclaration();
            TypeScriptType aliasedType = typeScriptType2;
            if (aliasedType == null) return false;
            if (!this.checkType(aliasedType)) return false;
            return true;
        }
        if (!(jSQualifiedNamedElement instanceof TypeScriptClass)) return false;
        return TypeScriptUtil.isDefinitionFile((PsiFile)((TypeScriptClass)definition).getContainingFile());
    }

    private final boolean checkType(TypeScriptType typeElement) {
        StubElement typeStub;
        Ref.BooleanRef result = new Ref.BooleanRef();
        StubBasedPsiElement stubBasedPsiElement = typeElement instanceof StubBasedPsiElement ? (StubBasedPsiElement)typeElement : null;
        Object object = typeStub = stubBasedPsiElement != null ? stubBasedPsiElement.getStub() : null;
        if (typeStub != null) {
            VueTypedEntitiesProvider.checkType$visit(result, (Stub)typeStub);
        } else {
            typeElement.accept((PsiElementVisitor)new PsiRecursiveVisitor(result){
                final /* synthetic */ Ref.BooleanRef $result;
                {
                    this.$result = $result;
                }

                public void visitJSElement(JSElement node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (node instanceof TypeScriptSingleType && VueTypedEntitiesProvider.access$checkTypeName(VueTypedEntitiesProvider.INSTANCE, ((TypeScriptSingleType)node).getQualifiedTypeName())) {
                        this.$result.element = true;
                    } else if (node instanceof TypeScriptTypeArgumentList || node instanceof TypeScriptUnionOrIntersectionType || node instanceof TypeScriptSingleType) {
                        node.acceptChildren((PsiElementVisitor)this);
                    }
                }
            });
        }
        return result.element;
    }

    private final boolean checkTypeName(String typeName) {
        CharSequence charSequence;
        return typeName != null && vueComponentTypenameRegex.matches(charSequence = (CharSequence)typeName);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final VueEntityDescriptor getComponentDescriptor(@Nullable PsiElement element) {
        VueTypedComponentDescriptor vueTypedComponentDescriptor;
        if (element == null) {
            return null;
        }
        PsiElement source = element instanceof JSPsiNamedElementBase ? (PsiElement)VueUtilKt.resolveIfImportSpecifier((JSPsiNamedElementBase)element) : element;
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(TypeScriptVariable.class), Reflection.getOrCreateKotlinClass(TypeScriptInterfaceClass.class)};
        JSQualifiedNamedElement componentDefinition = (JSQualifiedNamedElement)VueUtilKt.resolveElementTo(element, kClassArray);
        Object object = componentDefinition;
        if (object != null) {
            JSQualifiedNamedElement jSQualifiedNamedElement;
            JSQualifiedNamedElement it = jSQualifiedNamedElement = object;
            boolean bl = false;
            object = INSTANCE.isComponentDefinition(it) ? jSQualifiedNamedElement : null;
            if (object != null) {
                it = object;
                boolean bl2 = false;
                Object object2 = source instanceof PsiNamedElement ? (PsiNamedElement)source : null;
                if (object2 == null || (object2 = object2.getName()) == null) {
                    String string = componentDefinition.getName();
                    object2 = string;
                    Intrinsics.checkNotNull((Object)string);
                }
                vueTypedComponentDescriptor = new VueTypedComponentDescriptor(source, (String)object2);
                return vueTypedComponentDescriptor;
            }
        }
        vueTypedComponentDescriptor = null;
        return vueTypedComponentDescriptor;
    }

    @Nullable
    public final VueTypedComponent getComponent(@Nullable VueEntityDescriptor descriptor) {
        VueTypedComponent vueTypedComponent;
        VueTypedComponentDescriptor vueTypedComponentDescriptor = descriptor instanceof VueTypedComponentDescriptor ? (VueTypedComponentDescriptor)descriptor : null;
        if (vueTypedComponentDescriptor != null) {
            VueTypedComponentDescriptor it = vueTypedComponentDescriptor;
            boolean bl = false;
            vueTypedComponent = new VueTypedComponent(it.getSource(), it.getName());
        } else {
            vueTypedComponent = null;
        }
        return vueTypedComponent;
    }

    @NotNull
    public final Map<String, VueComponent> calculateDtsComponents(@NotNull PsiDirectory moduleDir) {
        JSFile mainPsiFile;
        PsiFile psiFile;
        VirtualFile mainFile;
        Intrinsics.checkNotNullParameter((Object)moduleDir, (String)"moduleDir");
        Map componentsFromDts = new LinkedHashMap();
        Project project = moduleDir.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Set componentDefs = CollectionsKt.toSet((Iterable)JSFrameworkMarkersIndex.Companion.getElements("Vue Typed Component", TypeScriptVariable.class, project, GlobalSearchScopesCore.directoryScope((PsiDirectory)moduleDir, (boolean)true)));
        if (componentDefs.isEmpty()) {
            return MapsKt.emptyMap();
        }
        TypeScriptNodeSearchProcessor searchProcessor = new TypeScriptNodeSearchProcessor();
        VirtualFile virtualFile = mainFile = JSExactFileReference.resolveForNpmPackages((VirtualFile)moduleDir.getVirtualFile(), (JSDirectorySearchProcessor)((JSDirectorySearchProcessor)searchProcessor));
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            psiFile = moduleDir.getManager().findFile(it);
        } else {
            psiFile = null;
        }
        Object object = psiFile;
        JSFile jSFile = mainPsiFile = object instanceof JSFile ? (JSFile)object : null;
        if (mainPsiFile != null) {
            object = new JSModuleTypeImpl(mainPsiFile, false).asRecordType().getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProperties(...)");
            object = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JSRecordType.PropertySignature export = (JSRecordType.PropertySignature)element$iv;
                boolean bl = false;
                List list = export.getMemberSource().getAllSourceElements();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllSourceElements(...)");
                VueTypedComponent vueTypedComponent = (VueTypedComponent)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), arg_0 -> VueTypedEntitiesProvider.calculateDtsComponents$lambda$1$0(componentDefs, export, arg_0)));
                if (vueTypedComponent == null) continue;
                VueTypedComponent it = vueTypedComponent;
                boolean bl2 = false;
                componentsFromDts.put(it.getDefaultName(), it);
            }
        } else {
            $this$forEach$iv = componentDefs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TypeScriptVariable variable = (TypeScriptVariable)element$iv;
                boolean bl = false;
                String name = variable.getName();
                if (!variable.isExported() || name == null) continue;
                componentsFromDts.put(name, new VueTypedComponent((PsiElement)variable, name));
            }
        }
        return componentsFromDts;
    }

    private static final void checkType$visit(Ref.BooleanRef result, Stub stub) {
        if (stub instanceof TypeScriptSingleTypeStub && INSTANCE.checkTypeName(((TypeScriptSingleTypeStub)stub).getQualifiedTypeName())) {
            result.element = true;
        } else if (stub instanceof TypeScriptTypeArgumentListStub || stub instanceof TypeScriptUnionOrIntersectionTypeStub || stub instanceof TypeScriptSingleTypeStub) {
            List list = ((JSStubElement)stub).getChildrenStubs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenStubs(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StubElement it = (StubElement)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                VueTypedEntitiesProvider.checkType$visit(result, (Stub)it);
            }
        }
    }

    private static final VueTypedComponent calculateDtsComponents$lambda$1$0(Set $componentDefs, JSRecordType.PropertySignature $export, PsiElement it) {
        VueTypedComponent vueTypedComponent;
        TypeScriptVariable variable;
        if (!(it instanceof TypeScriptVariable)) {
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(TypeScriptVariable.class)};
            v0 = (TypeScriptVariable)VueUtilKt.resolveElementTo(it, kClassArray);
        } else {
            v0 = variable = (TypeScriptVariable)it;
        }
        if (variable != null && $componentDefs.contains(variable)) {
            Intrinsics.checkNotNull((Object)it);
            String string = $export.getMemberName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMemberName(...)");
            vueTypedComponent = new VueTypedComponent(it, string);
        } else {
            vueTypedComponent = null;
        }
        return vueTypedComponent;
    }

    public static final /* synthetic */ boolean access$checkTypeName(VueTypedEntitiesProvider $this, String typeName) {
        return $this.checkTypeName(typeName);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/vuejs/model/typed/VueTypedEntitiesProvider$VueTypedComponentDescriptor;", "Lorg/jetbrains/vuejs/model/source/VueEntityDescriptor;", "source", "Lcom/intellij/psi/PsiElement;", "name", "", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "getSource", "()Lcom/intellij/psi/PsiElement;", "getName", "()Ljava/lang/String;", "intellij.vuejs.backend"})
    public static final class VueTypedComponentDescriptor
    implements VueEntityDescriptor {
        @NotNull
        private final PsiElement source;
        @NotNull
        private final String name;

        public VueTypedComponentDescriptor(@NotNull PsiElement source, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.source = source;
            this.name = name;
        }

        @Override
        @NotNull
        public PsiElement getSource() {
            return this.source;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }
    }
}

