/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.handlers.fixers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.handlers.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/handlers/fixers/KotlinCatchParameterFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/codeInsight/handlers/KotlinSmartEnterHandler;", "<init>", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "psiElement", "Lcom/intellij/psi/PsiElement;", "intellij.kotlin.base.codeInsight.minimal"})
public final class KotlinCatchParameterFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor, @NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (!(psiElement instanceof KtCatchClause)) {
            return;
        }
        ASTNode aSTNode = ((KtCatchClause)psiElement).getNode().findChildByType((IElementType)KtTokens.CATCH_KEYWORD);
        Intrinsics.checkNotNull((Object)aSTNode);
        TextRange textRange = aSTNode.getTextRange();
        Intrinsics.checkNotNull((Object)textRange);
        int catchEnd = textRange.getEndOffset();
        KtParameterList parameterList = ((KtCatchClause)psiElement).getParameterList();
        if (parameterList == null || parameterList.getNode().findChildByType((IElementType)KtTokens.RPAR) == null) {
            int n = PsiUtilsKt.getEndOffset((PsiElement)psiElement);
            KtExpression ktExpression = ((KtCatchClause)psiElement).getCatchBody();
            int n2 = ktExpression != null ? PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)ktExpression)) : Integer.MAX_VALUE;
            int endOffset = Math.min(n, n2);
            Object object = parameterList;
            if (object == null || (object = object.getParameters()) == null || (object = (KtParameter)CollectionsKt.firstOrNull((List)object)) == null || (object = object.getText()) == null) {
                object = "";
            }
            Object parameter = object;
            editor.getDocument().replaceString(catchEnd, endOffset, (CharSequence)("(" + (String)parameter + ")"));
            processor.registerUnresolvedError(endOffset - 1);
        } else {
            List list = parameterList.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
            KtParameter ktParameter = (KtParameter)CollectionsKt.firstOrNull((List)list);
            CharSequence charSequence = ktParameter != null ? ktParameter.getText() : null;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                processor.registerUnresolvedError(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)parameterList)) + 1);
            }
        }
    }
}

