/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.view;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.spring.data.commons.view.SpringRepositoriesViewSettings;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringRepositoryMethodPanel
extends FinderRecursivePanel<PsiMethod> {
    private final PsiClass myPsiClass;

    public SpringRepositoryMethodPanel(@NotNull Project project, @NotNull PsiClass psiClass) {
        if (project == null) {
            SpringRepositoryMethodPanel.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            SpringRepositoryMethodPanel.$$$reportNull$$$0(1);
        }
        super(project, null);
        this.myPsiClass = psiClass;
        this.setNonBlockingLoad(true);
    }

    protected JComponent createLeftComponent() {
        JComponent component = super.createLeftComponent();
        if (component instanceof ListWithFilter) {
            ListWithFilter list = (ListWithFilter)component;
            list.getScrollPane().setBorder((Border)JBUI.Borders.empty());
        }
        return component;
    }

    @Nullable
    protected JComponent createRightComponent(@NotNull PsiMethod method) {
        if (method == null) {
            SpringRepositoryMethodPanel.$$$reportNull$$$0(2);
        }
        return this.getDocumentationComponent((PsiElement)method);
    }

    public JComponent getDocumentationComponent(PsiElement element) {
        return DocumentationComponent.createAndFetch((Project)this.getProject(), (PsiElement)element, (Disposable)this);
    }

    protected void doCustomizeCellRenderer(@NotNull SimpleColoredComponent coloredComponent, @NotNull JList list, @NotNull PsiMethod method, int index, boolean selected, boolean hasFocus) {
        String name;
        if (coloredComponent == null) {
            SpringRepositoryMethodPanel.$$$reportNull$$$0(3);
        }
        if (list == null) {
            SpringRepositoryMethodPanel.$$$reportNull$$$0(4);
        }
        if (method == null) {
            SpringRepositoryMethodPanel.$$$reportNull$$$0(5);
        }
        coloredComponent.clear();
        coloredComponent.setIcon(this.getItemIcon(method));
        PsiClass containingClass = method.getContainingClass();
        boolean inheritedMethod = !this.myPsiClass.equals((Object)containingClass);
        String signature = SpringRepositoryMethodPanel.getMethodSignature(method);
        coloredComponent.append(signature, inheritedMethod ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (inheritedMethod && containingClass != null && StringUtil.isNotEmpty((String)(name = containingClass.getName()))) {
            coloredComponent.append(UIUtil.rightArrow() + name, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @NlsSafe
    public static String getMethodSignature(PsiMethod method) {
        int options = 263;
        return method.isValid() ? PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options, (int)2) : "";
    }

    @NotNull
    protected List<PsiMethod> getListItems() {
        List<PsiMethod> list = SpringRepositoryMethodPanel.getRepositoryMethods(this.myPsiClass);
        if (list == null) {
            SpringRepositoryMethodPanel.$$$reportNull$$$0(6);
        }
        return list;
    }

    public static List<PsiMethod> getRepositoryMethods(@NotNull PsiClass psiClass) {
        boolean showAllMethods;
        if (psiClass == null) {
            SpringRepositoryMethodPanel.$$$reportNull$$$0(7);
        }
        PsiMethod[] methods = (showAllMethods = SpringRepositoriesViewSettings.getInstance(psiClass.getProject()).isShowAllRepositoryMethods()) ? psiClass.getAllMethods() : psiClass.getMethods();
        return Arrays.stream(methods).filter(SpringRepositoryMethodPanel.getMethodFilter()).sorted(Comparator.comparing(PsiMethod::getName)).collect(Collectors.toList());
    }

    @NotNull
    private static Predicate<PsiMethod> getMethodFilter() {
        Predicate<PsiMethod> predicate = method -> {
            if (method.isConstructor()) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            return containingClass != null && !"java.lang.Object".equals(containingClass.getQualifiedName());
        };
        if (predicate == null) {
            SpringRepositoryMethodPanel.$$$reportNull$$$0(8);
        }
        return predicate;
    }

    @Nullable
    protected Icon getItemIcon(@NotNull PsiMethod method) {
        if (method == null) {
            SpringRepositoryMethodPanel.$$$reportNull$$$0(9);
        }
        return method.isValid() ? method.getIcon(0) : null;
    }

    protected boolean hasChildren(@NotNull PsiMethod method) {
        if (method == null) {
            SpringRepositoryMethodPanel.$$$reportNull$$$0(10);
        }
        return false;
    }

    @NotNull
    protected String getItemText(@NotNull PsiMethod method) {
        if (method == null) {
            SpringRepositoryMethodPanel.$$$reportNull$$$0(11);
        }
        return method.isValid() ? SpringRepositoryMethodPanel.getMethodSignature(method) : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coloredComponent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/view/SpringRepositoryMethodPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/view/SpringRepositoryMethodPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRightComponent";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCustomizeCellRenderer";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryMethods";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasChildren";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getItemText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8 -> new IllegalStateException(string);
        };
    }
}

