/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.http;

import com.intellij.java.ultimate.icons.JavaUltimateIcons;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.MicronautIcons;
import com.intellij.micronaut.jam.http.MnController;
import com.intellij.micronaut.jam.http.MnHttpMappingInfo;
import com.intellij.micronaut.jam.http.MnHttpModel;
import com.intellij.micronaut.jam.http.MnHttpUrlPathSpecification;
import com.intellij.micronaut.provider.http.MnHttpServerFramework;
import com.intellij.micronaut.provider.http.MnHttpUrlTargetInfo;
import com.intellij.micronaut.provider.http.MnHttpUtils;
import com.intellij.micronaut.provider.http.MnModuleAuthoritiesInfo;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.jvm.cache.SourceTestLibSearcher;
import com.intellij.microservices.jvm.url.UastUrlAttributeUtils;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.uast.UastModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00152\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0003H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006&"}, d2={"Lcom/intellij/micronaut/provider/http/MnHttpServerFramework;", "Lcom/intellij/microservices/endpoints/EndpointsUrlTargetProvider;", "Lcom/intellij/micronaut/jam/http/MnController;", "Lcom/intellij/micronaut/jam/http/MnHttpMappingInfo;", "<init>", "()V", "controllersSearcher", "Lcom/intellij/microservices/jvm/cache/SourceTestLibSearcher;", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "project", "Lcom/intellij/openapi/project/Project;", "getEndpointGroups", "", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpoints", "", "group", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "endpoint", "isValidEndpoint", "", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "getUrlTargetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnHttpServerFramework.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnHttpServerFramework.kt\ncom/intellij/micronaut/provider/http/MnHttpServerFramework\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1563#2:79\n1634#2,3:80\n*S KotlinDebug\n*F\n+ 1 MnHttpServerFramework.kt\ncom/intellij/micronaut/provider/http/MnHttpServerFramework\n*L\n72#1:79\n72#1:80,3\n*E\n"})
public final class MnHttpServerFramework
implements EndpointsUrlTargetProvider<MnController, MnHttpMappingInfo> {
    @NotNull
    private final SourceTestLibSearcher<MnController> controllersSearcher = new SourceTestLibSearcher("MN_CONTROLLERS", (Function2)controllersSearcher.1.INSTANCE);
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("Micronaut-HTTP-Server", MicronautBundle.message("micronaut.http.server.framework.title", new Object[0]), MicronautIcons.MicronautLogo);

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.HTTP_SERVER_TYPE;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return MnHttpUtils.hasHttpServerLibrary(project) ? EndpointsProvider.Status.HAS_ENDPOINTS : EndpointsProvider.Status.UNAVAILABLE;
    }

    @NotNull
    public Iterable<MnController> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof ModuleEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        if (!MnHttpUtils.hasHttpServerLibrary(((ModuleEndpointsFilter)filter).getModule())) {
            return CollectionsKt.emptyList();
        }
        return this.controllersSearcher.iterable(((ModuleEndpointsFilter)filter).getModule(), ((ModuleEndpointsFilter)filter).getFromTests(), ((ModuleEndpointsFilter)filter).getFromLibraries());
    }

    @NotNull
    public List<MnHttpMappingInfo> getEndpoints(@NotNull MnController group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        List<MnHttpMappingInfo> list = MnHttpModel.getHttpMethods((PsiClass)group.getPsiElement());
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHttpMethods(...)");
        return list;
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull MnController group, @NotNull MnHttpMappingInfo endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        String string = MnHttpUtils.getHttpResourcePath(endpoint);
        if (string == null) {
            string = "/";
        }
        return (ItemPresentation)new HttpMethodPresentation(string, endpoint.getMapping().getHttpMethod(), ((PsiClass)group.getPsiElement()).getName(), JavaUltimateIcons.Web.RequestMapping, (TextAttributesKey)(UastUrlAttributeUtils.isUastDeclarationDeprecated((PsiElement)endpoint.getMapping().getPsiElement()) ? CodeInsightColors.DEPRECATED_ATTRIBUTES : null));
    }

    public boolean isValidEndpoint(@NotNull MnController group, @NotNull MnHttpMappingInfo endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.isValid();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (ModificationTracker)UastModificationTracker.Companion.getInstance(project);
    }

    @NotNull
    public PsiElement getDocumentationElement(@NotNull MnController group, @NotNull MnHttpMappingInfo endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        PsiElement psiElement = endpoint.getMapping().getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
        return psiElement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull MnController group, @NotNull MnHttpMappingInfo endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        UrlPath urlPath = MnHttpUrlPathSpecification.INSTANCE.parsePath(MnHttpUtils.getHttpResourcePath(endpoint));
        MnModuleAuthoritiesInfo authorities = MnHttpUtils.authoritiesForMapping(endpoint);
        if (authorities != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = authorities.getSchemeAndAuthorityList();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String scheme = (String)pair.component1();
                Authority.Exact authority = (Authority.Exact)pair.component2();
                collection.add(new MnHttpUrlTargetInfo(CollectionsKt.listOf((Object)scheme), urlPath, endpoint, CollectionsKt.listOf((Object)authority)));
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.listOf((Object)new MnHttpUrlTargetInfo(UrlConstants.HTTP_SCHEMES, urlPath, endpoint, null, 8, null));
    }
}

