/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.http;

import com.intellij.micronaut.config.MnConfigValueSearcher;
import com.intellij.microservices.url.Authority;
import com.intellij.openapi.module.Module;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$0#J\n\u0010'\u001a\u0004\u0018\u00010&H\u0002J\u0010\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\u000bR\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\r\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u0019\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\r\u001a\u0004\b\u001a\u0010\u0018R\u001b\u0010\u001c\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\r\u001a\u0004\b\u001d\u0010\u0018R\u001b\u0010\u001f\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\r\u001a\u0004\b \u0010\u000b\u00a8\u0006+"}, d2={"Lcom/intellij/micronaut/provider/http/MnModuleAuthoritiesInfo;", "", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "sslEnabled", "", "getSslEnabled", "()Z", "sslEnabled$delegate", "Lkotlin/Lazy;", "deprecatedSslEnabled", "getDeprecatedSslEnabled", "deprecatedSslEnabled$delegate", "sslPortOrNull", "", "getSslPortOrNull", "()Ljava/lang/Integer;", "sslPortOrNull$delegate", "sslPort", "getSslPort", "()I", "deprecatedSslPort", "getDeprecatedSslPort", "deprecatedSslPort$delegate", "serverPort", "getServerPort", "serverPort$delegate", "dualProtocolEnabled", "getDualProtocolEnabled", "dualProtocolEnabled$delegate", "getSchemeAndAuthorityList", "", "Lkotlin/Pair;", "", "Lcom/intellij/microservices/url/Authority$Exact;", "httpsAuthority", "localhost", "port", "Companion", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnHttpUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnHttpUtils.kt\ncom/intellij/micronaut/provider/http/MnModuleAuthoritiesInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1#2:258\n*E\n"})
public final class MnModuleAuthoritiesInfo {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Module module;
    @NotNull
    private final Lazy sslEnabled$delegate;
    @NotNull
    private final Lazy deprecatedSslEnabled$delegate;
    @NotNull
    private final Lazy sslPortOrNull$delegate;
    @NotNull
    private final Lazy deprecatedSslPort$delegate;
    @NotNull
    private final Lazy serverPort$delegate;
    @NotNull
    private final Lazy dualProtocolEnabled$delegate;
    @Deprecated
    @NotNull
    public static final String HTTP = "http://";
    @Deprecated
    @NotNull
    public static final String HTTPS = "https://";

    public MnModuleAuthoritiesInfo(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
        this.sslEnabled$delegate = LazyKt.lazy(() -> MnModuleAuthoritiesInfo.sslEnabled_delegate$lambda$0(this));
        this.deprecatedSslEnabled$delegate = LazyKt.lazy(() -> MnModuleAuthoritiesInfo.deprecatedSslEnabled_delegate$lambda$0(this));
        this.sslPortOrNull$delegate = LazyKt.lazy(() -> MnModuleAuthoritiesInfo.sslPortOrNull_delegate$lambda$0(this));
        this.deprecatedSslPort$delegate = LazyKt.lazy(() -> MnModuleAuthoritiesInfo.deprecatedSslPort_delegate$lambda$0(this));
        this.serverPort$delegate = LazyKt.lazy(() -> MnModuleAuthoritiesInfo.serverPort_delegate$lambda$0(this));
        this.dualProtocolEnabled$delegate = LazyKt.lazy(() -> MnModuleAuthoritiesInfo.dualProtocolEnabled_delegate$lambda$0(this));
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    private final boolean getSslEnabled() {
        Lazy lazy = this.sslEnabled$delegate;
        return (Boolean)lazy.getValue();
    }

    private final boolean getDeprecatedSslEnabled() {
        Lazy lazy = this.deprecatedSslEnabled$delegate;
        return (Boolean)lazy.getValue();
    }

    private final Integer getSslPortOrNull() {
        Lazy lazy = this.sslPortOrNull$delegate;
        return (Integer)lazy.getValue();
    }

    private final int getSslPort() {
        Integer n = this.getSslPortOrNull();
        return n != null ? n : 8443;
    }

    private final int getDeprecatedSslPort() {
        Lazy lazy = this.deprecatedSslPort$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final int getServerPort() {
        Lazy lazy = this.serverPort$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final boolean getDualProtocolEnabled() {
        Lazy lazy = this.dualProtocolEnabled$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final List<Pair<String, Authority.Exact>> getSchemeAndAuthorityList() {
        List list;
        block3: {
            Authority.Exact exact;
            block5: {
                block4: {
                    block2: {
                        if (!this.getDualProtocolEnabled()) break block2;
                        Object[] objectArray = new Pair[2];
                        Authority.Exact exact2 = this.httpsAuthority();
                        Intrinsics.checkNotNull((Object)exact2);
                        objectArray[0] = TuplesKt.to((Object)HTTPS, (Object)exact2);
                        objectArray[1] = TuplesKt.to((Object)HTTP, (Object)this.localhost(this.getServerPort()));
                        list = CollectionsKt.listOf((Object[])objectArray);
                        break block3;
                    }
                    exact = this.httpsAuthority();
                    if (exact == null) break block4;
                    Authority.Exact it = exact;
                    boolean bl = false;
                    Pair pair = TuplesKt.to((Object)HTTPS, (Object)it);
                    exact = pair;
                    if (pair != null) break block5;
                }
                exact = TuplesKt.to((Object)HTTP, (Object)this.localhost(this.getServerPort()));
            }
            list = CollectionsKt.listOf((Object)exact);
        }
        return list;
    }

    private final Authority.Exact httpsAuthority() {
        Object object;
        if (this.getDualProtocolEnabled() && !this.getSslEnabled() && !this.getDeprecatedSslEnabled()) {
            Integer n = this.getSslPortOrNull();
            object = this.localhost(n != null ? n.intValue() : this.getDeprecatedSslPort());
        } else {
            object = this.getSslEnabled() ? this.localhost(this.getSslPort()) : (this.getDeprecatedSslEnabled() ? this.localhost(this.getDeprecatedSslPort()) : null);
        }
        return object;
    }

    private final Authority.Exact localhost(int port) {
        return new Authority.Exact("localhost:" + port);
    }

    private static final boolean sslEnabled_delegate$lambda$0(MnModuleAuthoritiesInfo this$0) {
        String string = new MnConfigValueSearcher(this$0.module, false, "micronaut.server.ssl.enabled", false, null, 0, 58, null).findValueText();
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    private static final boolean deprecatedSslEnabled_delegate$lambda$0(MnModuleAuthoritiesInfo this$0) {
        String string = new MnConfigValueSearcher(this$0.module, false, "micronaut.ssl.enabled", false, null, 0, 58, null).findValueText();
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    private static final Integer sslPortOrNull_delegate$lambda$0(MnModuleAuthoritiesInfo this$0) {
        String string = new MnConfigValueSearcher(this$0.module, false, "micronaut.server.ssl.port", false, null, 0, 58, null).findValueText();
        return string != null ? StringsKt.toIntOrNull((String)string) : null;
    }

    private static final int deprecatedSslPort_delegate$lambda$0(MnModuleAuthoritiesInfo this$0) {
        Object object = new MnConfigValueSearcher(this$0.module, false, "micronaut.ssl.port", false, null, 0, 58, null).findValueText();
        return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 8443;
    }

    private static final int serverPort_delegate$lambda$0(MnModuleAuthoritiesInfo this$0) {
        Object object = new MnConfigValueSearcher(this$0.module, false, "micronaut.server.port", false, null, 0, 58, null).findValueText();
        return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 8080;
    }

    private static final boolean dualProtocolEnabled_delegate$lambda$0(MnModuleAuthoritiesInfo this$0) {
        String string = new MnConfigValueSearcher(this$0.module, false, "micronaut.server.dual-protocol", false, null, 0, 58, null).findValueText();
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/micronaut/provider/http/MnModuleAuthoritiesInfo$Companion;", "", "<init>", "()V", "HTTP", "", "getHTTP$annotations", "HTTPS", "intellij.micronaut"})
    private static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ void getHTTP$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

