/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.inspections.jam;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.compiler.util.InspectionValidatorWrapper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.spring.integration.util.SpringIntegrationUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringIntegrationJamModelInspectionBase
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Module module;
        if (holder == null) {
            SpringIntegrationJamModelInspectionBase.$$$reportNull$$$0(0);
        }
        if (!SpringIntegrationUtil.isSpringIntegrationUsed(module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile()))) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SpringIntegrationJamModelInspectionBase.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            SpringIntegrationJamModelInspectionBase.$$$reportNull$$$0(2);
        }
        return psiElementVisitor;
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SpringIntegrationJamModelInspectionBase.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            SpringIntegrationJamModelInspectionBase.$$$reportNull$$$0(4);
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)file)) {
            return null;
        }
        if (!SpringIntegrationJamModelInspectionBase.isFileAccepted(file.getContainingFile())) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        this.checkJavaFile((PsiJavaFile)file, holder);
        List problemDescriptors = holder.getResults();
        return problemDescriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    protected void checkJavaFile(@NotNull PsiJavaFile javaFile, @NotNull ProblemsHolder holder) {
        if (javaFile == null) {
            SpringIntegrationJamModelInspectionBase.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            SpringIntegrationJamModelInspectionBase.$$$reportNull$$$0(6);
        }
        for (PsiClass psiClass : javaFile.getClasses()) {
            this.checkClassInternal(psiClass, holder);
        }
    }

    private void checkClassInternal(PsiClass aClass, ProblemsHolder holder) {
        this.checkClass(aClass, holder);
        for (PsiClass psiClass : aClass.getInnerClasses()) {
            this.checkClass(psiClass, holder);
        }
    }

    protected void checkClass(@NotNull PsiClass aClass, ProblemsHolder holder) {
        if (aClass == null) {
            SpringIntegrationJamModelInspectionBase.$$$reportNull$$$0(7);
        }
    }

    protected static boolean isFileAccepted(PsiFile file) {
        if (!InspectionValidatorWrapper.isCompilationThread()) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return SpringIntegrationUtil.isSpringIntegrationUsed(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/integration/inspections/jam/SpringIntegrationJamModelInspectionBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/integration/inspections/jam/SpringIntegrationJamModelInspectionBase";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkJavaFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

