/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.editors;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNodeEditingManager;
import com.intellij.diagram.DiagramNodeEditor;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiagramNodeEditorManager
implements DiagramNodeEditingManager,
UiDataProvider {
    @Nullable
    private DiagramNodeEditor myCurrentNodeEditor;
    @Nullable
    private DiagramNodeEditor myLastActiveNodeEditor;

    private DiagramNodeEditorManager() {
    }

    @Override
    @Nullable
    public DiagramNodeEditor getCurrentNodeEditor() {
        return this.myCurrentNodeEditor;
    }

    @Override
    @Nullable
    public DiagramNodeEditor getLastActiveNodeEditor() {
        return this.myLastActiveNodeEditor;
    }

    @Override
    public void dropLastActiveNodeEditor() {
        this.myLastActiveNodeEditor = null;
    }

    @Override
    public void startEditing(@NotNull DiagramNodeEditor editor, @NotNull DiagramBuilder builder) {
        if (editor == null) {
            DiagramNodeEditorManager.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            DiagramNodeEditorManager.$$$reportNull$$$0(1);
        }
        this.myLastActiveNodeEditor = this.myCurrentNodeEditor = editor;
        JComponent editorComponent = this.getCurrentEditorComponent();
        if (editorComponent != null) {
            this.setupEscapeListener(editorComponent, builder);
            IdeFocusManager.getInstance((Project)builder.getProject()).requestFocus((Component)editorComponent, true);
        }
    }

    private void setupEscapeListener(@NotNull JComponent editorComponent, final @NotNull DiagramBuilder builder) {
        if (editorComponent == null) {
            DiagramNodeEditorManager.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            DiagramNodeEditorManager.$$$reportNull$$$0(3);
        }
        editorComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    DiagramNodeEditorManager.this.stopEditing(builder);
                }
            }
        });
    }

    @Override
    public void stopEditing(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramNodeEditorManager.$$$reportNull$$$0(4);
        }
        if (this.myCurrentNodeEditor != null) {
            this.myCurrentNodeEditor.stopCellEditing();
            this.myLastActiveNodeEditor = this.myCurrentNodeEditor;
            this.myCurrentNodeEditor = null;
        }
    }

    @Override
    public void cancelEditing(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramNodeEditorManager.$$$reportNull$$$0(5);
        }
        if (this.myCurrentNodeEditor != null) {
            this.myCurrentNodeEditor.cancelCellEditing();
            this.myLastActiveNodeEditor = this.myCurrentNodeEditor;
            this.myCurrentNodeEditor = null;
        }
    }

    @Override
    public boolean isEditing() {
        return this.myCurrentNodeEditor != null;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Object value;
        if (sink == null) {
            DiagramNodeEditorManager.$$$reportNull$$$0(6);
        }
        if ((value = ObjectUtils.chooseNotNull((Object)this.getCurrentValue(), (Object)this.getLastActiveValue())) == null) {
            return;
        }
        sink.lazy(CommonDataKeys.LANGUAGE, () -> {
            Language language;
            if (value instanceof PsiElement) {
                PsiElement o = (PsiElement)value;
                language = o.getLanguage();
            } else {
                language = null;
            }
            return language;
        });
        sink.lazy(CommonDataKeys.NAVIGATABLE_ARRAY, () -> {
            Navigatable[] navigatableArray;
            if (value instanceof Navigatable) {
                Navigatable o = (Navigatable)value;
                Navigatable[] navigatableArray2 = new Navigatable[1];
                navigatableArray = navigatableArray2;
                navigatableArray2[0] = o;
            } else {
                navigatableArray = Navigatable.EMPTY_NAVIGATABLE_ARRAY;
            }
            return navigatableArray;
        });
        sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> {
            PsiElement o;
            return value instanceof PsiElement ? (o = (PsiElement)value) : null;
        });
        sink.lazy(CommonDataKeys.PSI_FILE, () -> {
            PsiFile psiFile;
            if (value instanceof PsiElement) {
                PsiElement o = (PsiElement)value;
                psiFile = o.getContainingFile();
            } else {
                psiFile = null;
            }
            return psiFile;
        });
        sink.lazy(CommonDataKeys.VIRTUAL_FILE, () -> {
            VirtualFile virtualFile;
            if (value instanceof PsiElement) {
                PsiElement o = (PsiElement)value;
                virtualFile = PsiUtilCore.getVirtualFile((PsiElement)o);
            } else {
                virtualFile = null;
            }
            return virtualFile;
        });
        sink.lazy(CommonDataKeys.VIRTUAL_FILE_ARRAY, () -> {
            VirtualFile[] virtualFileArray;
            VirtualFile file;
            if (value instanceof PsiElement) {
                PsiElement o = (PsiElement)value;
                v0 = PsiUtilCore.getVirtualFile((PsiElement)o);
            } else {
                v0 = file = null;
            }
            if (file != null) {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = file;
            } else {
                virtualFileArray = VirtualFile.EMPTY_ARRAY;
            }
            return virtualFileArray;
        });
        sink.lazy(VcsDataKeys.VIRTUAL_FILES, () -> {
            VirtualFile file = value instanceof PsiElement ? PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)value)) : null;
            return file != null ? Collections.singleton(file) : null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/editors/DiagramNodeEditorManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startEditing";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setupEscapeListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "stopEditing";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelEditing";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "uiDataSnapshot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

