/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.kotlin;

import com.intellij.openapi.diagnostic.Logger;
import junit.framework.ComparisonFailure;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ*\u0010\u000f\u001a\u00020\u00042\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u00020\u0015*\u00060\u0016j\u0002`\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/testFramework/fixtures/kotlin/KtFlakyErrorWorkaround;", "", "setUp", "Lkotlin/Function0;", "", "tearDown", "repeatCount", "", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;I)V", "wrapFlaky", "actualMessagePattern", "Lkotlin/text/Regex;", "body", "Ljava/lang/Runnable;", "repeatTest", "repeatCondition", "Lkotlin/Function1;", "", "", "actual", "", "Ljava/lang/AssertionError;", "Lkotlin/AssertionError;", "getActual", "(Ljava/lang/AssertionError;)Ljava/lang/String;", "intellij.java.testFramework"})
@SourceDebugExtension(value={"SMAP\nKtFlakyErrorWorkaround.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFlakyErrorWorkaround.kt\ncom/intellij/testFramework/fixtures/kotlin/KtFlakyErrorWorkaround\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,49:1\n13#2:50\n13#2:51\n*S KotlinDebug\n*F\n+ 1 KtFlakyErrorWorkaround.kt\ncom/intellij/testFramework/fixtures/kotlin/KtFlakyErrorWorkaround\n*L\n24#1:50\n28#1:51\n*E\n"})
public final class KtFlakyErrorWorkaround {
    @NotNull
    private final Function0<Unit> setUp;
    @NotNull
    private final Function0<Unit> tearDown;
    private final int repeatCount;

    public KtFlakyErrorWorkaround(@NotNull Function0<Unit> setUp, @NotNull Function0<Unit> tearDown, int repeatCount) {
        Intrinsics.checkNotNullParameter(setUp, (String)"setUp");
        Intrinsics.checkNotNullParameter(tearDown, (String)"tearDown");
        this.setUp = setUp;
        this.tearDown = tearDown;
        this.repeatCount = repeatCount;
    }

    public /* synthetic */ KtFlakyErrorWorkaround(Function0 function0, Function0 function02, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 5;
        }
        this((Function0<Unit>)function0, (Function0<Unit>)function02, n);
    }

    public final void wrapFlaky(@NotNull Regex actualMessagePattern, @NotNull Function0<Unit> body) {
        Intrinsics.checkNotNullParameter((Object)actualMessagePattern, (String)"actualMessagePattern");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.repeatTest((Function1<? super Throwable, Boolean>)((Function1)arg_0 -> KtFlakyErrorWorkaround.wrapFlaky$lambda$0(this, actualMessagePattern, arg_0)), body);
    }

    public final void wrapFlaky(@NotNull Regex actualMessagePattern, @NotNull Runnable body) {
        Intrinsics.checkNotNullParameter((Object)actualMessagePattern, (String)"actualMessagePattern");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.wrapFlaky(actualMessagePattern, (Function0<Unit>)((Function0)() -> KtFlakyErrorWorkaround.wrapFlaky$lambda$1(body)));
    }

    public final void repeatTest(@NotNull Function1<? super Throwable, Boolean> repeatCondition, @NotNull Function0<Unit> body) {
        Intrinsics.checkNotNullParameter(repeatCondition, (String)"repeatCondition");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean repeat = false;
        int repeatedTimes = 0;
        do {
            try {
                body.invoke();
                repeat = false;
            }
            catch (Throwable e) {
                if (((Boolean)repeatCondition.invoke((Object)e)).booleanValue()) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(KtFlakyErrorWorkaround.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Workaround hit! " + e.getClass() + " on try: " + repeatedTimes);
                    repeat = true;
                    if (++repeatedTimes > this.repeatCount) {
                        $i$f$logger = false;
                        Logger logger2 = Logger.getInstance(KtFlakyErrorWorkaround.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                        logger2.error("Workaround: hit too many times: " + repeatedTimes + ", max is " + this.repeatCount, e);
                        throw e;
                    }
                    this.tearDown.invoke();
                    this.setUp.invoke();
                    continue;
                }
                throw e;
            }
        } while (repeat);
    }

    public static /* synthetic */ void repeatTest$default(KtFlakyErrorWorkaround ktFlakyErrorWorkaround, Function1 function1, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = KtFlakyErrorWorkaround::repeatTest$lambda$0;
        }
        ktFlakyErrorWorkaround.repeatTest((Function1<? super Throwable, Boolean>)function1, (Function0<Unit>)function0);
    }

    private final String getActual(AssertionError $this$actual) {
        String string;
        AssertionError assertionError = $this$actual;
        if (assertionError instanceof org.junit.ComparisonFailure) {
            String string2 = ((org.junit.ComparisonFailure)((Object)$this$actual)).getActual();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getActual(...)");
        } else if (assertionError instanceof ComparisonFailure) {
            String string3 = ((ComparisonFailure)$this$actual).getActual();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getActual(...)");
        } else {
            string = "";
        }
        return string;
    }

    private static final boolean wrapFlaky$lambda$0(KtFlakyErrorWorkaround this$0, Regex $actualMessagePattern, Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e instanceof AssertionError && $actualMessagePattern.containsMatchIn((CharSequence)this$0.getActual((AssertionError)((Object)e)));
    }

    private static final Unit wrapFlaky$lambda$1(Runnable $body) {
        $body.run();
        return Unit.INSTANCE;
    }

    private static final boolean repeatTest$lambda$0(Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

