/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui.rest.resource;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.core.SwaggerResult;
import com.intellij.swagger.core.ui.SwPreviewType;
import com.intellij.swagger.core.ui.rest.SwSpecFileProviderKt;
import com.intellij.swagger.core.ui.rest.SwUrlBuilderKt;
import com.intellij.swagger.core.ui.rest.resource.SwPreviewResourceProvider;
import com.intellij.swagger.core.ui.rest.resource.SwPreviewResourceProviderKt;
import com.intellij.swagger.core.ui.rest.resource.SwaggerResourceProviderKt;
import com.intellij.swagger.core.ui.rest.resource.SwaggerUiResourceProviderKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/swagger/core/ui/rest/resource/SwaggerUiResourceProvider;", "Lcom/intellij/swagger/core/ui/rest/resource/SwPreviewResourceProvider;", "<init>", "()V", "getLibraryResource", "Lcom/intellij/swagger/core/SwaggerResult;", "Lcom/intellij/openapi/vfs/VirtualFile;", "resourcePath", "", "getMainHtmlPage", "specificationId", "Lcom/intellij/swagger/core/ui/rest/SpecificationId;", "getMainHtmlPage-Y7tB9Ug", "(Ljava/util/UUID;)Lcom/intellij/swagger/core/SwaggerResult;", "htmlMainContainerId", "getHtmlMainContainerId", "()Ljava/lang/String;", "previewType", "Lcom/intellij/swagger/core/ui/SwPreviewType;", "getPreviewType", "()Lcom/intellij/swagger/core/ui/SwPreviewType;", "intellij.swagger.core"})
public final class SwaggerUiResourceProvider
implements SwPreviewResourceProvider {
    @Override
    @NotNull
    public SwaggerResult<VirtualFile> getLibraryResource(@NotNull String resourcePath) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        return SwPreviewResourceProviderKt.getAllowedResourceFromLibraryWithUnknownVersion(SwaggerUiResourceProviderKt.access$getSWAGGER_UI_RESOURCES_ALLOW_LIST$p(), "META-INF/resources/webjars/swagger-ui", resourcePath);
    }

    @Override
    @NotNull
    public SwaggerResult<String> getMainHtmlPage-Y7tB9Ug(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"$v$c$com-intellij-swagger-core-ui-rest-SpecificationId$-specificationId$0");
        SwaggerResult<String> html = SwaggerResourceProviderKt.getBundledResourceResult("htmlTemplates/swagger-ui-index.html");
        if (html.isFailure()) {
            return SwaggerResult.Companion.failure(html.getFailureOrThrow());
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"{STATIC_RESOURCE_BASE_URL}", (Object)SwUrlBuilderKt.buildStaticResourceAccessUrl(SwPreviewType.SWAGGER_UI)), TuplesKt.to((Object)"{ERROR_HANDLER_SCRIPT_URL}", (Object)SwUrlBuilderKt.buildErrorScriptAccessUrl(SwPreviewType.SWAGGER_UI)), TuplesKt.to((Object)"{SPEC_URL}", (Object)SwUrlBuilderKt.buildSpecificationAccessUrl-bFyn6F8(uUID, SwPreviewType.SWAGGER_UI))};
        String htmlWithFulfilledValues = SwSpecFileProviderKt.inlineVariablesIntoTemplate(html.getSuccessOrThrow(), MapsKt.mapOf((Pair[])pairArray));
        return SwaggerResult.Companion.success(SwaggerUiResourceProviderKt.access$addCssStyles(htmlWithFulfilledValues));
    }

    @Override
    @NotNull
    public String getHtmlMainContainerId() {
        return "swagger_ui";
    }

    @Override
    @NotNull
    public SwPreviewType getPreviewType() {
        return SwPreviewType.SWAGGER_UI;
    }
}

