/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.DateChecker;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.de.SemanticRules;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GermanDateChecker
extends DateChecker {
    private static final NodePattern dayOfMonth = NodePattern.N.form("\\d{1,3}");
    static final GermanDateChecker INSTANCE = new GermanDateChecker();
    static final NodePattern monthName = NodePattern.N.form("(" + String.join((CharSequence)"|", GermanDateChecker.INSTANCE.monthNames) + "|j\u00e4nner|feber)(e?s)?");
    static final NodePattern numDotMonth = monthName.inFormSequence(2, "\\d\\d?", "\\.", ".*");
    final NodePattern longOrShortMonthName;
    private final NodePattern spelledMonthDate;
    private final NodePattern dayOfWeek;
    private static final String FUTURE_DATE_PAST_VERB_MSG = "Zuk\u00fcnftiges Datum stimmt mit dem vergangenen \u201e$Verb\u201c nicht \u00fcberein";
    private static final NodePattern perfect = NodePattern.or(NodePattern.N.pos(".*PA2.*"), GermanTreePatterns.infinitive).markAs("Verb").withDependent("cop|aux.*", NodePattern.N.lemma("haben|sein")).noDependents("aux", NodePattern.N.lemma("werden"));
    private static final NodePattern imperfect = NodePattern.N.pos("VER.*PRT.*").markAs("Verb");
    private static final NodePattern pastVerb = NodePattern.or(perfect, imperfect);
    private static final NodePattern pastClause = NodePattern.or(pastVerb, NodePattern.N.withDependent("cop", imperfect), NodePattern.N.noDependents("cop|aux.*").withHead("xcomp", pastVerb));

    private GermanDateChecker() {
        super(Locale.GERMAN, "d. MMMM uuuu", "d. MMMM");
        this.longOrShortMonthName = NodePattern.N.form(StreamEx.of((Collection)this.monthNames).append((Object[])new String[]{"j\u00e4nner", "feber"}).flatMap(s -> Stream.of(s, s.substring(0, 3))).toSet());
        this.spelledMonthDate = dayOfMonth.markAs("Day").noSpaceAfter().directlyBefore(CommonPatterns.dot).withNeighbor(2, this.longOrShortMonthName.markAs("Month").andOptionally(CommonPatterns.beforeSkipping(CommonPatterns.dot, year.markAs("Year"))));
        this.dayOfWeek = NodePattern.N.form(StreamEx.of((Collection)this.dayNames).flatMap(s -> Stream.of(s, s.substring(0, 2))).joining((CharSequence)"|") + "|sonnabend");
    }

    @Override
    protected DayOfWeek findDayOfWeek(Node weekday) {
        String form = weekday.lowForm();
        return form.equals("sonnabend") ? DayOfWeek.SATURDAY : DayOfWeek.of(GermanDateChecker.findStarting(GermanDateChecker.trimDot(form), this.dayNames) + 1);
    }

    private Month findMonth(Node node) {
        String form = node.lowForm();
        return form.startsWith("j\u00e4n") ? Month.JANUARY : (form.equals("feber") ? Month.FEBRUARY : Month.of(GermanDateChecker.findStarting(GermanDateChecker.trimDot(form), this.monthNames) + 1));
    }

    @Override
    protected String weekdayExampleSentence(String date, String day) {
        return "Heute ist <b>" + day + ", " + date.replaceFirst("(\\d+)", "$1</b>");
    }

    @Override
    protected String wrongWeekdayMessage(LocalDate date, DayOfWeek day, String sentenceText, DateChecker.YearStrategy strategy) {
        String dateStr = this.canonicalDateFormat.format(date).replaceAll("\\. ", ".\u00a0");
        if (sentenceText.toLowerCase(this.locale).contains("j\u00e4nner")) {
            dateStr = dateStr.replace("Januar", "J\u00e4nner");
        }
        if (sentenceText.toLowerCase(this.locale).contains("feber")) {
            dateStr = dateStr.replace("Februar", "Feber");
        }
        String dayStr = sentenceText.toLowerCase(this.locale).contains("sonnabend") ? "Sonnabend" : this.fullDayFormat.format(day);
        String prefix = strategy == DateChecker.YearStrategy.current ? "Meinten Sie dieses Jahr? " : "";
        return prefix + "Der " + dateStr + " ist kein " + dayStr;
    }

    NodePattern absolutePattern() {
        return NodePattern.or(this.wrongWeekday(DateChecker.YearStrategy.absolute), this.invalidDate(), this.fiveDigitYear());
    }

    NodePattern relativePattern() {
        return NodePattern.or(this.futureDatePastVerb(), this.dateFromLastYear(), this.wrongWeekday(DateChecker.YearStrategy.current));
    }

    private NodePattern dateFromLastYear() {
        return NodePattern.or(this.spelledMonthDate.and(NodePattern.markedNodeMatches("Year", NodePattern.N.includeIntoReport())), dashDate, dottedDateNode).andNot(CommonPatterns.possiblySkipUp("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("seit|nach|vo[nm]")))).andNot(NodePattern.N.after(this.dayOfWeek)).and((node, match) -> this.checkDateFromLastYear(node, match, this.extractFullDate(node, DateChecker.YearStrategy.absolute), "Meinten Sie das neue Jahr %s?"));
    }

    private NodePattern futureDatePastVerb() {
        NodePattern allowFuture = NodePattern.N.withDependent("case", NodePattern.N.form("auf|zu[mr]?|f(\u00fc|ue)r"));
        return NodePattern.or(NodePattern.or(this.spelledMonthDate.reportEverythingTouched().andNot(NodePattern.markedNodeMatches("Month", allowFuture)), dottedDateNode.andNot(allowFuture)).and(node -> {
            DateChecker.ParsedDate date = this.extractFullDate((Node)node, DateChecker.YearStrategy.absolute);
            return date != null && date.isInFuture();
        }), year.andOptionally(CommonPatterns.afterSkipping(CommonPatterns.dot, this.longOrShortMonthName.markAs("Month"))).reportEverythingTouched().andOr(NodePattern.markedNodeMatches("Month", NodePattern.N.withDependent("case", NodePattern.N.form("i[nm]"))), NodePattern.N.withDependent("case", NodePattern.N.form("i[nm]"))).and((node, match) -> {
            Node month = match.findMarkedNode("Month");
            if (allowFuture.matches(node) || allowFuture.matches(month)) {
                return null;
            }
            LocalDate date = GermanDateChecker.validDate(Integer.parseInt(node.form()), month == null ? Month.JANUARY : this.findMonth(month), 1);
            return date != null && date.isAfter(GermanDateChecker.now()) ? match : null;
        })).and(CommonPatterns.skipUp("amod|flat|nmod|nummod|compound", CommonPatterns.skipUp("obl", pastClause))).message(FUTURE_DATE_PAST_VERB_MSG);
    }

    private NodePattern fiveDigitYear() {
        return NodePattern.N.withHead("appos|nmod", NodePattern.or(this.longOrShortMonthName, SemanticRules.seasoned)).afterHead().and(GermanDateChecker.fiveDigitYear("Meinen Sie eine Jahreszahl?"));
    }

    private NodePattern wrongWeekday(DateChecker.YearStrategy strategy) {
        return this.dayOfWeek.and((weekday, match) -> {
            Node next = weekday.nextNode();
            if (CommonPatterns.dot.matches(next)) {
                next = next.nextNode();
            }
            if (CommonPatterns.comma.matches(next)) {
                next = next.nextNode();
            }
            if (next != null && next.hasForm("den")) {
                next = next.nextNode();
            }
            DateChecker.ParsedDate date = next == null ? null : this.extractFullDate(next, strategy);
            return date == null ? null : this.checkWeekday(weekday, match, date, strategy);
        });
    }

    private NodePattern invalidDate() {
        NodePattern vom = NodePattern.N.withDependent("case", NodePattern.N.form("vo[nm]").directlyBefore(dayOfMonth.markAs("Start")));
        NodePattern bis = NodePattern.N.withDependent("case", NodePattern.N.form("bis").directlyBefore(dayOfMonth.markAs("End")));
        NodePattern am = NodePattern.N.withDependent("case", NodePattern.N.form("am").directlyBefore(dayOfMonth.markAs("Start")));
        return NodePattern.or(this.longOrShortMonthName.markAs("Month").andOr(vom.and(dayOfMonth).withDependent("nmod", bis), bis.withPrevSibling(vom.andNot(this.longOrShortMonthName)), vom, bis, am).withDependent("case", NodePattern.N.reportRangeTo("Month")).and((node, match) -> {
            Node start = match.findMarkedNode("Start");
            Node end = match.findMarkedNode("End");
            Node year1 = match.findMarkedNode("Year");
            if (start != null && end != null && Integer.parseInt(start.form()) >= Integer.parseInt(end.form())) {
                return match.withMessage("Das Anfangsdatum sollte vor dem Enddatum sein");
            }
            return this.checkInvalidDayOfMonth(match, this.findMonth(node), start == null ? null : start.form(), end == null ? null : end.form(), year1 == null ? null : year1.form());
        }), NodePattern.N.form(dotDate.pattern()).reportEverythingTouched().directlyAfter(NodePattern.N.form("am|der").markAs("Prep")).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("Uhr"))).and((node, match) -> {
            Matcher matcher = dotDate.matcher(node.form());
            if (!matcher.matches()) {
                throw new AssertionError();
            }
            int month = Integer.parseInt(matcher.group(2));
            if (month == 0) {
                return null;
            }
            if (month > 12) {
                Node prep = match.getMarkedNode("Prep");
                if (!prep.form().equalsIgnoreCase("am") || matcher.group(3) != null) {
                    return match.withMessage("Ung\u00fcltiger Monat " + month);
                }
                return null;
            }
            return this.checkInvalidDayOfMonth(match, Month.of(month), matcher.group(1), null, matcher.group(3));
        }), this.spelledMonthDate.reportEverythingTouched().and((node, match) -> {
            Node year = match.findMarkedNode("Year");
            return this.checkInvalidDayOfMonth(match, this.findMonth(match.getMarkedNode("Month")), match.getMarkedNode("Day").form(), null, year == null ? null : year.form());
        }));
    }

    @Nullable
    private NodeMatch checkInvalidDayOfMonth(NodeMatch match, Month month, @Nullable String startDay, @Nullable String endDay, @Nullable String year) {
        int maxDays;
        int n = maxDays = year == null ? month.maxLength() : month.length(GermanDateChecker.isLeapYear(year));
        if (startDay != null && Integer.parseInt(startDay) > maxDays || endDay != null && Integer.parseInt(endDay) > maxDays) {
            if (month == Month.FEBRUARY && year != null) {
                return match.withMessage("Der Februar " + year + " hat nur " + maxDays + " Tage");
            }
            return match.withMessage("Der " + this.renderMonth(month) + " hat nur " + maxDays + " Tage");
        }
        return null;
    }

    @Nullable
    private DateChecker.ParsedDate extractFullDate(@NotNull Node start, DateChecker.YearStrategy strategy) {
        NodeMatch match = this.spelledMonthDate.match(start);
        if (match != null) {
            return DateChecker.ParsedDate.fromNodes(match.getMarkedNode("Day"), match.getMarkedNode("Month"), match.findMarkedNode("Year"), strategy, this::findMonth);
        }
        DateChecker.ParsedDate date = DateChecker.ParsedDate.fromDMYDotDate(start, strategy);
        if (date != null) {
            return date;
        }
        if (dashDate.matches(start) && strategy == DateChecker.YearStrategy.absolute) {
            return DateChecker.ParsedDate.fromAmbiguousDate(start.tree(), start.neighbor(2).textRange(), start.neighbor(4).textRange(), start.textRange(), strategy);
        }
        return null;
    }

    @Override
    protected boolean hasPastTenseAround(Node dayName) {
        return dayName.hierarchy().anyMatch(pastClause::matches);
    }
}

