/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.util.regex;

import ai.grazie.rules.util.regex.Literal;
import ai.grazie.rules.util.regex.PathComponent;
import ai.grazie.rules.util.regex.RegexMatcher;
import ai.grazie.rules.util.regex.RegexParser;
import ai.grazie.rules.util.regex.RegexPath;
import ai.grazie.rules.util.regex.Term;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public class Regex {
    final Term term;
    public final String pattern;

    Regex(String pattern, Term term) {
        this.term = term;
        this.pattern = pattern;
    }

    public String toString() {
        return this.pattern;
    }

    public static Regex parse(String regex) {
        return new Regex(regex, new RegexParser(regex).parse());
    }

    public RegexMatcher caseSensitiveMatcher() {
        return RegexMatcher.create(this, true);
    }

    public RegexMatcher caseInsensitiveMatcher() {
        return RegexMatcher.create(this, false);
    }

    @Nullable
    public Set<String> possibleValues() {
        return this.possibleValues(Integer.MAX_VALUE);
    }

    @Nullable
    public Set<String> possibleValues(int limit) {
        if (!this.term.isFinite()) {
            return null;
        }
        Set<RegexPath> paths = this.term.enumerate(limit);
        HashSet<String> result = new HashSet<String>();
        for (RegexPath path : paths) {
            PathComponent pathComponent = path.single();
            if (pathComponent instanceof Literal) {
                Literal l = (Literal)pathComponent;
                result.add(l.value());
                continue;
            }
            return null;
        }
        return result;
    }

    @Nullable
    public Set<String> possibleSubstrings(int limit) {
        Set<RegexPath> paths = this.term.enumerate(limit);
        ArrayList<Set> candidates = new ArrayList<Set>();
        HashSet<String> singleCandidates = new HashSet<String>();
        for (RegexPath path : paths) {
            Set substrings = (Set)((StreamEx)StreamEx.of(path.components()).map(c -> {
                String string;
                if (c instanceof Literal) {
                    Literal l = (Literal)c;
                    string = l.value();
                } else {
                    string = "";
                }
                return string;
            }).filter(s -> !s.isEmpty())).toCollection(LinkedHashSet::new);
            if (substrings.isEmpty()) {
                return null;
            }
            candidates.add(substrings);
            if (substrings.size() != 1) continue;
            singleCandidates.add((String)substrings.iterator().next());
        }
        for (Set set2 : candidates) {
            if (set2.size() <= 1) continue;
            if (!set2.stream().anyMatch(singleCandidates::contains)) continue;
            set2.removeIf(s -> !singleCandidates.contains(s));
        }
        List shortToLong = ((StreamEx)((StreamEx)StreamEx.of(candidates).filter(set -> !set.isEmpty())).map(set -> (String)StreamEx.of((Collection)set).maxBy(String::length).orElseThrow()).sortedBy(String::length)).toList();
        HashSet<String> result = new HashSet<String>();
        for (String each : shortToLong) {
            if (!result.stream().noneMatch(prev -> each.contains((CharSequence)prev))) continue;
            result.add(each);
        }
        return result;
    }
}

