/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.converter.utils;

import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import com.intellij.httpClient.executor.util.encoding.EncodingUtilsKt;
import com.intellij.httpClient.http.request.HttpRequestPsiConverter;
import com.intellij.httpClient.http.request.HttpRequestPsiFactory;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.converter.utils.HttpRequestQueryPresentationUtilsKt;
import com.intellij.httpClient.http.request.converter.utils.Query;
import com.intellij.httpClient.http.request.psi.HttpFormUrlencodedBody;
import com.intellij.httpClient.http.request.psi.HttpFormUrlencodedParameter;
import com.intellij.httpClient.http.request.psi.HttpInputFile;
import com.intellij.httpClient.http.request.psi.HttpMultipartMessage;
import com.intellij.httpClient.http.request.psi.HttpQuery;
import com.intellij.httpClient.http.request.psi.HttpQueryParameter;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBody;
import com.intellij.httpClient.http.request.psi.HttpRequestCompositeElement;
import com.intellij.httpClient.http.request.psi.HttpRequestMessage;
import com.intellij.httpClient.http.request.psi.HttpRequestMessagesGroup;
import com.intellij.httpClient.http.request.psi.HttpVariableBase;
import com.intellij.httpClient.http.request.run.HttpRequestValidationException;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a*\u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a*\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a \u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a8\u0006\u0012"}, d2={"getQueryParametersSkipUnknown", "", "Lkotlin/Pair;", "", "element", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "substitutor", "Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutor;", "getQueryParameters", "getQueryParametersWithSubstitution", "Lcom/intellij/httpClient/http/request/converter/utils/Query;", "getEncodedQueryString", "getBody", "getEncodedFormParameters", "body", "Lcom/intellij/httpClient/http/request/psi/HttpFormUrlencodedBody;", "isEncodingEnabled", "", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nhttpRequestPsiConverterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 httpRequestPsiConverterUtils.kt\ncom/intellij/httpClient/http/request/converter/utils/HttpRequestPsiConverterUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1617#2,9:111\n1869#2:120\n1870#2:122\n1626#2:123\n1563#2:124\n1634#2,3:125\n1563#2:128\n1634#2,3:129\n1563#2:132\n1634#2,3:133\n1#3:121\n*S KotlinDebug\n*F\n+ 1 httpRequestPsiConverterUtils.kt\ncom/intellij/httpClient/http/request/converter/utils/HttpRequestPsiConverterUtilsKt\n*L\n15#1:111,9\n15#1:120\n15#1:122\n15#1:123\n25#1:124\n25#1:125,3\n50#1:128\n50#1:129,3\n101#1:132\n101#1:133,3\n15#1:121\n*E\n"})
public final class HttpRequestPsiConverterUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Pair<String, String>> getQueryParametersSkipUnknown(@NotNull HttpRequest element, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        List<Query> queryParameters = HttpRequestPsiConverterUtilsKt.getQueryParametersWithSubstitution(element, substitutor2);
        Iterable $this$mapNotNull$iv = queryParameters;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Query query = (Query)element$iv$iv;
            boolean bl2 = false;
            String name = query.component1();
            String value2 = query.component2();
            if (((CharSequence)name).length() > 0) {
                String string = value2;
                if (string == null) {
                    string = "";
                }
                pair = TuplesKt.to((Object)name, (Object)string);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Pair<String, String>> getQueryParameters(@NotNull HttpRequest element, @NotNull HttpRequestVariableSubstitutor substitutor2) throws HttpRequestValidationException {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        List<Query> queryParameters = HttpRequestPsiConverterUtilsKt.getQueryParametersWithSubstitution(element, substitutor2);
        Iterable $this$map$iv = queryParameters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            Query query = (Query)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name = query.component1();
            String value2 = query.component2();
            HttpQueryParameter parameter = query.component3();
            if (((CharSequence)name).length() > 0) {
                string = value2;
                if (string == null) {
                    string = "";
                }
            } else {
                Object[] objectArray = new Object[]{parameter.getText()};
                throw new HttpRequestValidationException(HttpClientExecutorBundle.message("rest.client.request.query.is.invalid", objectArray));
            }
            collection.add(TuplesKt.to((Object)name, (Object)string));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Query> getQueryParametersWithSubstitution(HttpRequest element, HttpRequestVariableSubstitutor substitutor2) {
        void $this$mapTo$iv$iv;
        HttpRequestCompositeElement httpRequestCompositeElement;
        HttpRequestCompositeElement httpRequestCompositeElement2 = element.getRequestTarget();
        if (httpRequestCompositeElement2 == null || (httpRequestCompositeElement2 = httpRequestCompositeElement2.getQuery()) == null) {
            return CollectionsKt.emptyList();
        }
        HttpRequestCompositeElement query = httpRequestCompositeElement2;
        HttpVariableBase singleVariable = query.getSingleVariable();
        if (singleVariable != null) {
            String string = substitutor2.getValue((PsiElement)singleVariable);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            String queryString = string;
            HttpQuery httpQuery = HttpRequestPsiFactory.createHttpQuery(query.getProject(), queryString);
            Intrinsics.checkNotNull((Object)httpQuery);
            httpRequestCompositeElement = httpQuery;
        } else {
            httpRequestCompositeElement = query;
        }
        HttpRequestCompositeElement finalQuery = httpRequestCompositeElement;
        List<HttpQueryParameter> list2 = finalQuery.getQueryParameterList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getQueryParameterList(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void parameter;
            HttpQueryParameter httpQueryParameter = (HttpQueryParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key = parameter.getKey(substitutor2);
            String value2 = parameter.getValue(substitutor2);
            Intrinsics.checkNotNull((Object)parameter);
            collection.add(new Query(key, value2, (HttpQueryParameter)parameter));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String getEncodedQueryString(@NotNull HttpRequest element, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        List<Pair<String, String>> queryParameters = HttpRequestPsiConverterUtilsKt.getQueryParametersSkipUnknown(element, substitutor2);
        boolean isEncodingEnabled = HttpRequestPsiConverter.isEncodingEnabled(element);
        return HttpRequestQueryPresentationUtilsKt.getEncodedQueryString(queryParameters, isEncodingEnabled);
    }

    @Nullable
    public static final String getBody(@NotNull HttpRequest element, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        String string;
        HttpRequestBody body2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        HttpRequestBody httpRequestBody = body2 = element.getRequestBody();
        if (httpRequestBody instanceof HttpRequestMessagesGroup) {
            List<HttpRequestMessage> list2 = ((HttpRequestMessagesGroup)body2).getRequestMessageList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getRequestMessageList(...)");
            List<HttpRequestMessage> messages = list2;
            string = !(CollectionsKt.singleOrNull(messages) instanceof HttpInputFile) ? HttpRequestPsiConverter.getTextToSend(element.getContainingFile(), messages, substitutor2) : null;
        } else if (httpRequestBody instanceof HttpFormUrlencodedBody) {
            boolean isEncodingEnabled = HttpRequestPsiConverter.isEncodingEnabled(element);
            string = HttpRequestPsiConverterUtilsKt.getEncodedFormParameters((HttpFormUrlencodedBody)body2, substitutor2, isEncodingEnabled);
        } else {
            string = httpRequestBody instanceof HttpMultipartMessage ? null : null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getEncodedFormParameters(@NotNull HttpFormUrlencodedBody body2, @NotNull HttpRequestVariableSubstitutor substitutor2, boolean isEncodingEnabled) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        List<HttpFormUrlencodedParameter> list2 = body2.getFormUrlencodedParameterList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getFormUrlencodedParameterList(...)");
        Iterable iterable = list2;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void parameter;
            HttpFormUrlencodedParameter httpFormUrlencodedParameter = (HttpFormUrlencodedParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name = parameter.getKey(substitutor2);
            String value2 = parameter.getValue(substitutor2);
            collection.add(EncodingUtilsKt.smartFormEncode((Pair<String, String>)TuplesKt.to((Object)name, (Object)value2), isEncodingEnabled));
        }
        List encodedFormParams = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)encodedFormParams, (CharSequence)"&", null, null, (int)0, null, HttpRequestPsiConverterUtilsKt::getEncodedFormParameters$lambda$1, (int)30, null);
    }

    private static final CharSequence getEncodedFormParameters$lambda$1(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        String encodedName = (String)pair.component1();
        String encodedValue = (String)pair.component2();
        return encodedName + "=" + encodedValue;
    }
}

