/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra.introspector;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a$\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\n\u001a.\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\u000e\u001a\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a(\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u00112\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u001a\u0012\u0010\u0014\u001a\u00020\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"userType", "", "validatorToCType", "", "parseDataType", "validator", "concatClassAndOptions", "className", "options", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "jsonToCassandraMapLiteral", "json", "keyFilter", "Lkotlin/Function1;", "", "parseObject", "Lcom/google/gson/JsonObject;", "mapToCassandraMap", "map", "jsonObjectToCassandraMapObject", "value", "Lcom/google/gson/JsonElement;", "quote", "s", "intellij.database.dialects.cassandra"})
@SourceDebugExtension(value={"SMAP\nCassIntrospectorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CassIntrospectorHelper.kt\ncom/intellij/database/dialects/cassandra/introspector/CassIntrospectorHelperKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1188#2,3:117\n1#3:120\n*S KotlinDebug\n*F\n+ 1 CassIntrospectorHelper.kt\ncom/intellij/database/dialects/cassandra/introspector/CassIntrospectorHelperKt\n*L\n57#1:117,3\n*E\n"})
public final class CassIntrospectorHelperKt {
    @NotNull
    private static final String userType = "UserType";
    @NotNull
    private static final Map<String, String> validatorToCType;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String parseDataType(@NotNull String validator) {
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        int parenthPos = StringsKt.indexOf$default((CharSequence)validator, (char)'(', (int)0, (boolean)false, (int)6, null);
        if (parenthPos == -1) {
            String string = validator.substring(StringsKt.lastIndexOf$default((CharSequence)validator, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return validatorToCType.get(string);
        }
        String string = validator.substring(0, parenthPos);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String currentValidator = string;
        String string2 = currentValidator.substring(StringsKt.lastIndexOf$default((CharSequence)currentValidator, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String currentValidatorClass = string2;
        if (Intrinsics.areEqual((Object)currentValidatorClass, (Object)userType)) {
            return validator;
        }
        String string3 = validatorToCType.get(currentValidatorClass);
        if (string3 == null) {
            return null;
        }
        String type = string3;
        StringBuilder sb = new StringBuilder(type).append("<");
        int currentDepth = 0;
        int lastComma = 0;
        String string4 = validator.substring(parenthPos + 1, validator.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String parameters = string4;
        String separator = null;
        separator = "";
        CharSequence $this$forEachIndexed$iv = parameters;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            void c;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c2 = item$iv;
            int index = n;
            boolean bl = false;
            if (c == 40) {
                ++currentDepth;
            }
            if (c == 41) {
                currentDepth += -1;
            }
            if (currentDepth != 0 || c != 44) continue;
            sb.append(separator);
            separator = ", ";
            String string5 = parameters.substring(lastComma, index);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            String string6 = CassIntrospectorHelperKt.parseDataType(string5);
            if (string6 == null) {
                string6 = "unknown";
            }
            sb.append(string6);
            lastComma = index + 1;
        }
        StringBuilder stringBuilder = sb.append(separator);
        String string7 = parameters.substring(lastComma);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
        String string8 = CassIntrospectorHelperKt.parseDataType(string7);
        if (string8 == null) {
            string8 = "unknown";
        }
        stringBuilder.append(string8);
        return sb.append(">").toString();
    }

    @Nullable
    public static final String concatClassAndOptions(@Nullable String className, @Nullable String options, @NotNull Logger log) {
        String o;
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        if (className == null || options == null) {
            return null;
        }
        String string = CassIntrospectorHelperKt.jsonToCassandraMapLiteral$default(options, log, null, 4, null);
        if (string != null) {
            String it = string;
            boolean bl = false;
            String string2 = it.substring(1, it.length() - 1);
            v2 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            v2 = o = null;
        }
        if (o == null) {
            return "{'class': " + CassIntrospectorHelperKt.quote(className) + "}";
        }
        return "{'class': " + CassIntrospectorHelperKt.quote(className) + ", " + o + "}";
    }

    @Nullable
    public static final String jsonToCassandraMapLiteral(@NotNull String json, @NotNull Logger log, @NotNull Function1<? super String, Boolean> keyFilter) {
        String string;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter(keyFilter, (String)"keyFilter");
        JsonObject jsonObject = CassIntrospectorHelperKt.parseObject(json, log);
        if (jsonObject != null) {
            JsonObject it = jsonObject;
            boolean bl = false;
            string = CassIntrospectorHelperKt.mapToCassandraMap(it, keyFilter);
        } else {
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String jsonToCassandraMapLiteral$default(String string, Logger logger, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = CassIntrospectorHelperKt::jsonToCassandraMapLiteral$lambda$0;
        }
        return CassIntrospectorHelperKt.jsonToCassandraMapLiteral(string, logger, (Function1<? super String, Boolean>)function1);
    }

    @Nullable
    public static final JsonObject parseObject(@NotNull String json, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        try {
            JsonReader jsonReader;
            JsonReader $this$parseObject_u24lambda_u240 = jsonReader = new JsonReader((Reader)new StringReader(json));
            boolean bl = false;
            $this$parseObject_u24lambda_u240.setLenient(true);
            JsonReader reader = jsonReader;
            return ((JsonElement)TypeAdapters.JSON_ELEMENT.read(reader)).getAsJsonObject();
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return null;
        }
    }

    private static final String mapToCassandraMap(JsonObject map, Function1<? super String, Boolean> keyFilter) {
        Set set = map.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
        List keys = SequencesKt.toList((Sequence)SequencesKt.sorted((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)set), keyFilter)));
        if (keys.isEmpty()) {
            return null;
        }
        return "{" + CollectionsKt.joinToString$default((Iterable)keys, null, null, null, (int)0, null, arg_0 -> CassIntrospectorHelperKt.mapToCassandraMap$lambda$1(map, arg_0), (int)31, null) + "}";
    }

    static /* synthetic */ String mapToCassandraMap$default(JsonObject jsonObject, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = CassIntrospectorHelperKt::mapToCassandraMap$lambda$0;
        }
        return CassIntrospectorHelperKt.mapToCassandraMap(jsonObject, (Function1<? super String, Boolean>)function1);
    }

    private static final String jsonObjectToCassandraMapObject(JsonElement value) {
        if (value == null || value.isJsonNull()) {
            return "null";
        }
        if (value.isJsonPrimitive()) {
            String string;
            JsonPrimitive p = value.getAsJsonPrimitive();
            if (p.isString()) {
                String string2 = p.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAsString(...)");
                string = CassIntrospectorHelperKt.quote(string2);
            } else {
                String string3 = p.getAsString();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAsString(...)");
            }
            return string;
        }
        if (value.isJsonArray()) {
            JsonArray jsonArray = value.getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
            return "[" + CollectionsKt.joinToString$default((Iterable)((Iterable)jsonArray), null, null, null, (int)0, null, CassIntrospectorHelperKt::jsonObjectToCassandraMapObject$lambda$0, (int)31, null) + "]";
        }
        if (value.isJsonObject()) {
            JsonObject jsonObject = value.getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
            String string = CassIntrospectorHelperKt.mapToCassandraMap$default(jsonObject, null, 2, null);
            if (string == null) {
                string = "{}";
            }
            return string;
        }
        return "class " + value.getClass() + " is not supported";
    }

    private static final String quote(String s) {
        return "'" + StringsKt.replace$default((String)s, (String)"'", (String)"''", (boolean)false, (int)4, null) + "'";
    }

    private static final boolean jsonToCassandraMapLiteral$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean mapToCassandraMap$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final CharSequence mapToCassandraMap$lambda$1(JsonObject $map, String it) {
        Intrinsics.checkNotNull((Object)it);
        return CassIntrospectorHelperKt.quote(it) + ": " + CassIntrospectorHelperKt.jsonObjectToCassandraMapObject($map.get(it));
    }

    private static final CharSequence jsonObjectToCassandraMapObject$lambda$0(JsonElement it) {
        return CassIntrospectorHelperKt.jsonObjectToCassandraMapObject(it);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"AsciiType", (Object)"ascii"), TuplesKt.to((Object)"LongType", (Object)"bigint"), TuplesKt.to((Object)"BooleanType", (Object)"boolean"), TuplesKt.to((Object)"CounterColumnType", (Object)"counter"), TuplesKt.to((Object)"DecimalType", (Object)"decimal"), TuplesKt.to((Object)"DoubleType", (Object)"double"), TuplesKt.to((Object)"DurationType", (Object)"duration"), TuplesKt.to((Object)"FloatType", (Object)"float"), TuplesKt.to((Object)"Int32Type", (Object)"int"), TuplesKt.to((Object)"UTF8Type", (Object)"text"), TuplesKt.to((Object)"TimestampType", (Object)"timestamp"), TuplesKt.to((Object)"UUIDType", (Object)"uuid"), TuplesKt.to((Object)"UTF8Type", (Object)"varchar"), TuplesKt.to((Object)"IntegerType", (Object)"varint"), TuplesKt.to((Object)"TimeUUIDType", (Object)"timeuuid"), TuplesKt.to((Object)"InetAddressType", (Object)"inet"), TuplesKt.to((Object)"SimpleDateType", (Object)"date"), TuplesKt.to((Object)"TimeType", (Object)"time"), TuplesKt.to((Object)"ShortType", (Object)"smallint"), TuplesKt.to((Object)"ByteType", (Object)"tinyint"), TuplesKt.to((Object)"BytesType", (Object)"blob"), TuplesKt.to((Object)"MapType", (Object)"map"), TuplesKt.to((Object)"SetType", (Object)"set"), TuplesKt.to((Object)"ListType", (Object)"list"), TuplesKt.to((Object)userType, (Object)"map"), TuplesKt.to((Object)"TupleType", (Object)"tuple"), TuplesKt.to((Object)"FrozenType", (Object)"frozen")};
        validatorToCType = MapsKt.mapOf((Pair[])pairArray);
    }
}

