/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.Expr;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.Messages;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.utils.Cancellation;

public class ExprBinary
extends Expr {
    public static final int OR = 0;
    public static final int SUB = 1;
    public static final int MUL = 2;
    public static final int DIV = 3;
    public static final int MOD = 4;
    public static final int AND = 5;
    public static final int ADD = 6;
    public static final int LESS = 7;
    public static final int LESSEQU = 8;
    public static final int GREATER = 9;
    public static final int GREATEREQU = 10;
    public static final int EQU = 11;
    public static final int UNEQU = 23;
    private final int opCode;
    private final Expr left;
    private final Expr right;

    public ExprBinary(int opCode, Expr left2, Expr right2, Context context) {
        super(context);
        this.opCode = opCode;
        this.left = left2;
        this.right = right2;
    }

    @Override
    public int interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable) {
        return switch (this.opCode) {
            case 6 -> this.left.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable) + this.right.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable);
            case 1 -> this.left.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable) - this.right.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable);
            case 2 -> this.left.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable) * this.right.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable);
            case 3 -> this.left.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable) / this.right.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable);
            case 4 -> this.left.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable) % this.right.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable);
            case 5 -> this.left.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable) & this.right.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable);
            case 0 -> this.left.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable) | this.right.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable);
            case 7 -> {
                if (this.left.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable) < this.right.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable)) {
                    yield 1;
                }
                yield 0;
            }
            case 8 -> {
                if (this.left.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable) <= this.right.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable)) {
                    yield 1;
                }
                yield 0;
            }
            case 9 -> {
                if (this.left.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable) > this.right.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable)) {
                    yield 1;
                }
                yield 0;
            }
            case 10 -> {
                if (this.left.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable) >= this.right.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable)) {
                    yield 1;
                }
                yield 0;
            }
            case 11 -> {
                if (this.left.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable) == this.right.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable)) {
                    yield 1;
                }
                yield 0;
            }
            case 23 -> {
                if (this.left.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable) != this.right.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable)) {
                    yield 1;
                }
                yield 0;
            }
            default -> throw new DfaInternalException(Messages.getString(ExprBinary.class.getName() + "-0"));
        };
    }

    @Override
    public String toLongString() {
        return "ExprBinary{opCode=" + this.opCode + ", left=" + this.left.toLongString() + ", right=" + this.right.toLongString() + "}";
    }
}

