/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.ui.console;

import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.attributes.DfaTuple;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.domains.DomainTypeManager;
import com.intellij.rml.dfa.impl.relations.DfaRelationInfo;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.RelationKind;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.Messages;
import com.intellij.rml.dfa.impl.ui.console.Console;
import com.intellij.rml.dfa.impl.utils.SortedArrayHelper;
import com.intellij.util.ArrayUtil;
import java.util.List;

public class RelationsConsole {
    private final Console console;
    private int[] metrics;
    protected String[] domainsNames;
    private List<List<Integer>> varDependencies;
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    public static final int DEFAULT_MAX_TUPLES = 1000;

    public RelationsConsole(Console console) {
        this.console = console;
    }

    public void print(IRelation relation, String preHeader, Attribute revealableHeader, DomainType headerType, String postHeader, SymbolTable symbolTable) {
        Console console = this.console;
        console.print(Messages.getString(RelationsConsole.class.getName() + "-0") + preHeader);
        console.printAttribute(revealableHeader, headerType, null);
        console.print(postHeader + "\":\n");
        DfaRelationInfo info = new DfaRelationInfo(relation, "", RelationKind.Local, null, symbolTable, 1000);
        this.print(info, 1000, SortedArrayHelper.getIDPerm(relation.getDomains().length), symbolTable.getTypeManager(), false);
    }

    public void print(IRelation relation, String header, SymbolTable symbolTable) {
        this.console.print(Messages.getString(RelationsConsole.class.getName() + "-1") + header + "\":\n");
        DfaRelationInfo info = new DfaRelationInfo(relation, "", RelationKind.Local, null, symbolTable, 1000);
        this.print(info, 1000, SortedArrayHelper.getIDPerm(relation.getDomains().length), symbolTable.getTypeManager(), false);
    }

    public void print(IRelation relation, String header, int maxAttributes, int[] permutation, SymbolTable symbolTable, boolean printBddNodes) {
        this.console.print(Messages.getString(RelationsConsole.class.getName() + "-2") + header + "\":\n");
        DfaRelationInfo info = new DfaRelationInfo(relation, "", RelationKind.Local, null, symbolTable, maxAttributes);
        this.print(info, maxAttributes, permutation, symbolTable.getTypeManager(), printBddNodes);
    }

    public void print(DfaRelationInfo relationInfo, int maxAttributes, int[] permutation, DomainTypeManager typeManager, boolean printBddNodes) {
        if (maxAttributes == -1) {
            maxAttributes = 1000;
        }
        this.domainsNames = ArrayUtil.toStringArray(relationInfo.getDomainNames());
        this.varDependencies = relationInfo.getVarDependencies();
        DfaTuple[] attributes = relationInfo.getTuples().toArray(new DfaTuple[0]);
        this.console.print("Function: " + String.valueOf(relationInfo.getFunction()) + "\n");
        long totalAttributes = relationInfo.getNumOfTuples();
        long bddNodesCnt = relationInfo.getNumOfBDDNodes();
        this.printNumOfTuples(totalAttributes);
        if (printBddNodes) {
            this.printNumOfBDDNodes(bddNodesCnt);
        }
        if (totalAttributes > (long)maxAttributes) {
            this.console.print(Messages.getString(RelationsConsole.class.getName() + "-3") + maxAttributes + Messages.getString(RelationsConsole.class.getName() + "-4"));
        }
        this.printRelation(attributes, typeManager);
    }

    protected void printRelation(DfaTuple[] attributes, DomainTypeManager typeManager) {
        this.metrics = new int[this.domainsNames.length];
        for (int i = 0; i < this.domainsNames.length; ++i) {
            this.metrics[i] = this.domainsNames[i].length();
            DomainType domainType = typeManager.getDomainType(this.domainsNames[i]);
            if (!domainType.isContextType()) continue;
            this.metrics[i] = Math.max(this.metrics[i], domainType.getFixedBitLength());
        }
        for (DfaTuple tuple : attributes) {
            for (int j = 0; j < tuple.getAttributes().size(); ++j) {
                String attributeStr = this.console.attributeString((Attribute)tuple.getAttributes().get(j));
                int len = Math.min(attributeStr.length(), 100);
                if (len <= this.metrics[j]) continue;
                this.metrics[j] = len;
            }
        }
        this.console.println();
        this.printHeader();
        for (DfaTuple attribute : attributes) {
            this.printTuple(attribute, typeManager);
        }
        this.console.println();
    }

    private void printHeader() {
        int i;
        int max = this.domainsNames.length - 1;
        Console console = this.console;
        for (i = 0; i <= max; ++i) {
            String name = this.domainsNames[i];
            console.print(" " + name);
            if (i >= max) continue;
            this.separateFileds(i, name.length());
        }
        console.println();
        for (i = 0; i < this.metrics.length; ++i) {
            if (i > 0) {
                console.print(PLUS);
            }
            console.print(MINUS);
            for (int j = 0; j <= this.metrics[i]; ++j) {
                console.print(MINUS);
            }
        }
        console.println();
    }

    protected void printNumOfTuples(long numOfTuples) {
        this.console.println(Messages.getString(RelationsConsole.class.getName() + "-5") + numOfTuples);
    }

    protected void printNumOfBDDNodes(long numOfBDDNodes) {
        this.console.println(Messages.getString(RelationsConsole.class.getName() + "-6") + numOfBDDNodes);
    }

    private void printTuple(DfaTuple tuple, DomainTypeManager typeManager) {
        int max = tuple.getAttributes().size() - 1;
        Console console = this.console;
        for (int i = 0; i <= max; ++i) {
            Attribute attr = (Attribute)tuple.getAttributes().get(i);
            console.print(" ");
            int length = console.printAttribute(attr, typeManager.getDomainType(this.domainsNames[i]), this.varDependencies.get(i));
            if (i >= max) continue;
            this.separateFileds(i, length);
        }
        console.println();
    }

    private void separateFileds(int idx, int len) {
        this.console.print(" ".repeat(Math.max(0, this.metrics[idx] - len)) + " |");
    }
}

