/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.resolve.CssClassOrIdReference;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssComposesClassReference
extends CssClassOrIdReference {
    public CssComposesClassReference(PsiElement element) {
        super(element, null);
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    protected GlobalSearchScope getSearchScope() {
        CssTerm lastTerm = CssComposesClassReference.getDeclarationLastTerm(CssUtil.getDeclaration(this.myElement));
        if (lastTerm == null) {
            return GlobalSearchScope.EMPTY_SCOPE;
        }
        PsiFile containingFile = this.myElement.getContainingFile().getOriginalFile();
        if (lastTerm.getTermType() == CssTermTypes.STRING) {
            Object[] psiFiles = CssResolveManager.getInstance().resolveFiles(lastTerm.getFirstChild());
            return GlobalSearchScope.filesScope((Project)this.myElement.getProject(), (Collection)ContainerUtil.map((Object[])psiFiles, PsiFile::getVirtualFile));
        }
        return GlobalSearchScope.fileScope((PsiFile)containingFile);
    }

    @Override
    public Object @NotNull [] getVariants() {
        Project project = this.myElement.getProject();
        GlobalSearchScope scope = this.getSearchScope();
        ArrayList result = new ArrayList();
        Collection<String> notAllowed = this.getNotAllowedCompletionClassNames();
        CssIndexUtil.processAllClassNamesInScope(project, scope, (Processor<? super String>)((Processor)name -> {
            if (!notAllowed.contains(name)) {
                result.add(LookupElementBuilder.create((String)name).withIcon(AllIcons.Xml.Css_class));
            }
            return true;
        }));
        Object[] objectArray = ArrayUtil.toObjectArray(result);
        if (objectArray == null) {
            CssComposesClassReference.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    @NotNull
    private Collection<String> getNotAllowedCompletionClassNames() {
        boolean isLocal;
        CssTerm lastTerm = CssComposesClassReference.getDeclarationLastTerm(CssUtil.getDeclaration(this.myElement));
        if (lastTerm == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                CssComposesClassReference.$$$reportNull$$$0(1);
            }
            return set;
        }
        CssRuleset ruleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, CssRuleset.class);
        if (ruleset == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                CssComposesClassReference.$$$reportNull$$$0(2);
            }
            return set;
        }
        HashSet<String> notAllowed = new HashSet<String>();
        boolean bl = isLocal = lastTerm.getTermType() != CssTermTypes.STRING;
        if (isLocal) {
            List elements = SyntaxTraverser.psiTraverser((PsiElement)ruleset.getSelectorList()).filter(CssClass.class).map(CssSelectorSuffix::getName).toList();
            notAllowed.addAll(elements);
        }
        if (ruleset.getBlock() != null) {
            List classesFromSameFile = Arrays.stream(ruleset.getBlock().getDeclarations()).filter(d -> CssComposesClassReference.isComposesDeclarationWithSamePath(d, isLocal ? null : lastTerm.getText())).flatMap(d -> CssComposesClassReference.getClassNames(d, isLocal)).toList();
            notAllowed.addAll(classesFromSameFile);
        }
        HashSet<String> hashSet = notAllowed;
        if (hashSet == null) {
            CssComposesClassReference.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static Stream<String> getClassNames(@NotNull CssDeclaration declaration, boolean isLocal) {
        if (declaration == null) {
            CssComposesClassReference.$$$reportNull$$$0(4);
        }
        if (declaration.getValue() == null) {
            return Stream.empty();
        }
        CssTerm[] terms = declaration.getValue().getTerms();
        ArrayList<String> classNames = new ArrayList<String>();
        int lastIndex = terms.length - (isLocal ? 0 : 2);
        for (int i = 0; i < lastIndex; ++i) {
            classNames.add(terms[i].getText());
        }
        return classNames.stream();
    }

    private static boolean isComposesDeclarationWithSamePath(@NotNull CssDeclaration declaration, @Nullable String path) {
        if (declaration == null) {
            CssComposesClassReference.$$$reportNull$$$0(5);
        }
        if (!CssPropertyUtil.isComposesProperty(declaration)) {
            return false;
        }
        CssTerm lastTerm = CssComposesClassReference.getDeclarationLastTerm(declaration);
        if (lastTerm == null) {
            return false;
        }
        if (path == null && lastTerm.getTermType() != CssTermTypes.STRING) {
            return true;
        }
        return path != null && lastTerm.textMatches((CharSequence)path);
    }

    @Nullable
    private static CssTerm getDeclarationLastTerm(@Nullable CssDeclaration declaration) {
        if (declaration == null || declaration.getValue() == null) {
            return null;
        }
        return (CssTerm)ArrayUtil.getLastElement((Object[])declaration.getValue().getTerms());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/resolve/CssComposesClassReference";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotAllowedCompletionClassNames";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/resolve/CssComposesClassReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getClassNames";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isComposesDeclarationWithSamePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

