/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.highlighting;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.impl.highlighting.LspDiagnosticAndLazyQuickFixes;
import com.intellij.platform.lsp.impl.highlighting.LspPublishDiagnosticsCacheKt;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u001d\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u001b\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0011\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u001aJ\u001e\u0010\u001b\u001a\u00020\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u001d2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\r\u0010\"\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b#R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/platform/lsp/impl/highlighting/LspPublishDiagnosticsCache;", "", "LspPublishDiagnosticsCache", "()V", "uriToDiagnostics", "", "", "", "Lcom/intellij/platform/lsp/impl/highlighting/LspDiagnosticAndLazyQuickFixes;", "filePathToUri", "Lcom/intellij/util/containers/BidirectionalMap;", "fileToPendingDocEdits", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/platform/lsp/impl/highlighting/LspPublishDiagnosticsCache$DocEdit;", "diagnosticsReceived", "", "file", "params", "Lorg/eclipse/lsp4j/PublishDiagnosticsParams;", "diagnosticsReceived$intellij_platform_lsp_impl", "fileEdited", "e", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "fileEdited$intellij_platform_lsp_impl", "getDiagnostics", "getDiagnostics$intellij_platform_lsp_impl", "q", "diagnostics", "", "docEdit", "q", "Lorg/eclipse/lsp4j/Diagnostic;", "diagnostic", "clearCache", "clearCache$intellij_platform_lsp_impl", "DocEdit", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspPublishDiagnosticsCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspPublishDiagnosticsCache.kt\ncom/intellij/platform/lsp/impl/highlighting/LspPublishDiagnosticsCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,158:1\n1#2:159\n1563#3:160\n1634#3,3:161\n23#4:164\n*S KotlinDebug\n*F\n+ 1 LspPublishDiagnosticsCache.kt\ncom/intellij/platform/lsp/impl/highlighting/LspPublishDiagnosticsCache\n*L\n52#1:160\n52#1:161,3\n62#1:164\n*E\n"})
public final class LspPublishDiagnosticsCache {
    @NotNull
    private final Map<String, List<LspDiagnosticAndLazyQuickFixes>> uriToDiagnostics;
    @NotNull
    private final BidirectionalMap<String, String> filePathToUri;
    @NotNull
    private final MultiMap<VirtualFile, DocEdit> fileToPendingDocEdits;

    public LspPublishDiagnosticsCache() {
        Map map = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        this.uriToDiagnostics = map;
        this.filePathToUri = new BidirectionalMap();
        this.fileToPendingDocEdits = new MultiMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void diagnosticsReceived$intellij_platform_lsp_impl(@Nullable VirtualFile file, @NotNull PublishDiagnosticsParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        LspPublishDiagnosticsCache lspPublishDiagnosticsCache = this;
        synchronized (lspPublishDiagnosticsCache) {
            Collection collection;
            boolean bl = false;
            if (params.getDiagnostics().isEmpty()) {
                this.uriToDiagnostics.remove(params.getUri());
                this.filePathToUri.removeValue((Object)params.getUri());
                VirtualFile virtualFile = file;
                if (virtualFile != null) {
                    VirtualFile virtualFile2 = virtualFile;
                    boolean bl2 = false;
                    collection = this.fileToPendingDocEdits.remove((Object)file);
                } else {
                    collection = null;
                }
            } else {
                Object object = this.uriToDiagnostics;
                String string = params.getUri();
                List list = params.getDiagnostics();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDiagnostics(...)");
                Iterable iterable = list;
                boolean bl3 = false;
                Iterable iterable2 = iterable;
                Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                boolean bl4 = false;
                for (Object t2 : iterable2) {
                    Diagnostic diagnostic = (Diagnostic)t2;
                    Collection collection3 = collection2;
                    boolean bl5 = false;
                    Intrinsics.checkNotNull((Object)diagnostic);
                    collection3.add(new LspDiagnosticAndLazyQuickFixes(diagnostic));
                }
                iterable = (List)collection2;
                object.put((String)string, (List<LspDiagnosticAndLazyQuickFixes>)iterable);
                if (file != null) {
                    ((Map)this.filePathToUri).put(file.getPath(), params.getUri());
                    collection = this.fileToPendingDocEdits.remove((Object)file);
                } else {
                    this.filePathToUri.removeValue((Object)params.getUri());
                    object = this;
                    boolean bl6 = false;
                    Logger logger = Logger.getInstance(LspPublishDiagnosticsCache.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Could not find file with diagnostics: " + params.getUri());
                    collection = Unit.INSTANCE;
                }
            }
            Collection collection4 = collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fileEdited$intellij_platform_lsp_impl(@NotNull VirtualFile file, @NotNull DocumentEvent e2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        LspPublishDiagnosticsCache lspPublishDiagnosticsCache = this;
        synchronized (lspPublishDiagnosticsCache) {
            boolean bl = false;
            if (this.filePathToUri.get((Object)file.getPath()) != null) {
                int n2;
                int n3 = e2.getDocument().getLineNumber(e2.getOffset());
                int n4 = e2.getOffset() - e2.getDocument().getLineStartOffset(n3);
                int n5 = e2.getDocument().getLineNumber(e2.getOffset() + e2.getOldLength());
                int n6 = e2.getOffset() + e2.getOldLength() - e2.getDocument().getLineStartOffset(n5);
                int n7 = Strings.countChars((CharSequence)e2.getOldFragment(), (char)'\n');
                int n8 = Strings.countChars((CharSequence)e2.getNewFragment(), (char)'\n');
                int n9 = n8 - n7;
                int n10 = n5 + n9;
                if (n8 == 0) {
                    n2 = n4 + e2.getNewLength();
                } else {
                    int n11 = e2.getNewLength();
                    CharSequence charSequence = e2.getNewFragment();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
                    n2 = n11 - StringsKt.lastIndexOf$default((CharSequence)charSequence, (char)'\n', (int)0, (boolean)false, (int)6, null) - 1;
                }
                int n12 = n2;
                this.fileToPendingDocEdits.putValue((Object)file, (Object)new DocEdit(new Position(n3, n4), new Position(n5, n6), new Position(n10, n12)));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    @NotNull
    public final List<LspDiagnosticAndLazyQuickFixes> getDiagnostics$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        LspPublishDiagnosticsCache lspPublishDiagnosticsCache = this;
        synchronized (lspPublishDiagnosticsCache) {
            Collection collection;
            List list;
            String string;
            block8: {
                String string2;
                block7: {
                    boolean bl = false;
                    if ((String)this.filePathToUri.get((Object)file.getPath()) != null) break block7;
                    List list2 = CollectionsKt.emptyList();
                    return list2;
                }
                string = string2;
                List list3 = this.uriToDiagnostics.get(string);
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                list = list3;
                Collection collection2 = this.fileToPendingDocEdits.get((Object)file);
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
                collection = collection2;
                if (!list.isEmpty() && !collection.isEmpty()) break block8;
                List list4 = list;
                return list4;
            }
            List list5 = CollectionsKt.toMutableList((Collection)list);
            for (DocEdit docEdit : collection) {
                ProgressManager.checkCanceled();
                Intrinsics.checkNotNull((Object)docEdit);
                this.q(list5, docEdit);
            }
            this.uriToDiagnostics.put(string, list5);
            this.fileToPendingDocEdits.remove((Object)file);
            List list6 = list5;
            return list6;
        }
    }

    private final void q(List<LspDiagnosticAndLazyQuickFixes> list, DocEdit docEdit) {
        ListIterator<LspDiagnosticAndLazyQuickFixes> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Diagnostic diagnostic = listIterator.next().getDiagnostic();
            Position position = docEdit.getStart();
            Position position2 = diagnostic.getRange().getEnd();
            Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"getEnd(...)");
            if (LspPublishDiagnosticsCacheKt.access$compareTo(position, position2) > 0) continue;
            Position position3 = docEdit.getEndOld();
            Position position4 = diagnostic.getRange().getStart();
            Intrinsics.checkNotNullExpressionValue((Object)position4, (String)"getStart(...)");
            if (LspPublishDiagnosticsCacheKt.access$compareTo(position3, position4) < 0) {
                listIterator.set(new LspDiagnosticAndLazyQuickFixes(this.q(diagnostic, docEdit)));
                continue;
            }
            listIterator.remove();
        }
    }

    private final Diagnostic q(Diagnostic diagnostic, DocEdit docEdit) {
        Diagnostic diagnostic2;
        int n2 = docEdit.getEndNew().getLine() - docEdit.getEndOld().getLine();
        int n3 = diagnostic.getRange().getStart().getLine() + n2;
        int n4 = diagnostic.getRange().getEnd().getLine() + n2;
        int n5 = n3 == docEdit.getEndNew().getLine() ? diagnostic.getRange().getStart().getCharacter() + docEdit.getEndNew().getCharacter() - docEdit.getEndOld().getCharacter() : diagnostic.getRange().getStart().getCharacter();
        int n6 = diagnostic.getRange().getEnd().getLine() == diagnostic.getRange().getStart().getLine() ? diagnostic.getRange().getEnd().getCharacter() + n5 - diagnostic.getRange().getStart().getCharacter() : diagnostic.getRange().getEnd().getCharacter();
        Diagnostic diagnostic3 = diagnostic2 = new Diagnostic();
        boolean bl = false;
        diagnostic3.setRange(new Range(new Position(n3, n5), new Position(n4, n6)));
        diagnostic3.setSeverity(diagnostic.getSeverity());
        diagnostic3.setCode(diagnostic.getCode());
        diagnostic3.setCodeDescription(diagnostic.getCodeDescription());
        diagnostic3.setSource(diagnostic.getSource());
        diagnostic3.setMessage(diagnostic.getMessage());
        diagnostic3.setTags(diagnostic.getTags());
        diagnostic3.setRelatedInformation(diagnostic.getRelatedInformation());
        diagnostic3.setData(diagnostic.getData());
        return diagnostic2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearCache$intellij_platform_lsp_impl() {
        LspPublishDiagnosticsCache lspPublishDiagnosticsCache = this;
        synchronized (lspPublishDiagnosticsCache) {
            boolean bl = false;
            this.uriToDiagnostics.clear();
            this.filePathToUri.clear();
            this.fileToPendingDocEdits.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/lsp/impl/highlighting/LspPublishDiagnosticsCache$DocEdit;", "", "start", "Lorg/eclipse/lsp4j/Position;", "endOld", "endNew", "LspPublishDiagnosticsCache$DocEdit", "(Lorg/eclipse/lsp4j/Position;Lorg/eclipse/lsp4j/Position;Lorg/eclipse/lsp4j/Position;)V", "getStart", "()Lorg/eclipse/lsp4j/Position;", "getEndOld", "getEndNew", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.lsp.impl"})
    private static final class DocEdit {
        @NotNull
        private final Position start;
        @NotNull
        private final Position endOld;
        @NotNull
        private final Position endNew;

        public DocEdit(@NotNull Position start, @NotNull Position endOld, @NotNull Position endNew) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)endOld, (String)"endOld");
            Intrinsics.checkNotNullParameter((Object)endNew, (String)"endNew");
            this.start = start;
            this.endOld = endOld;
            this.endNew = endNew;
        }

        @NotNull
        public final Position getStart() {
            return this.start;
        }

        @NotNull
        public final Position getEndOld() {
            return this.endOld;
        }

        @NotNull
        public final Position getEndNew() {
            return this.endNew;
        }

        @NotNull
        public final Position component1() {
            return this.start;
        }

        @NotNull
        public final Position component2() {
            return this.endOld;
        }

        @NotNull
        public final Position component3() {
            return this.endNew;
        }

        @NotNull
        public final DocEdit copy(@NotNull Position start, @NotNull Position endOld, @NotNull Position endNew) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)endOld, (String)"endOld");
            Intrinsics.checkNotNullParameter((Object)endNew, (String)"endNew");
            return new DocEdit(start, endOld, endNew);
        }

        public static /* synthetic */ DocEdit copy$default(DocEdit docEdit, Position position, Position position2, Position position3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                position = docEdit.start;
            }
            if ((n2 & 2) != 0) {
                position2 = docEdit.endOld;
            }
            if ((n2 & 4) != 0) {
                position3 = docEdit.endNew;
            }
            return docEdit.copy(position, position2, position3);
        }

        @NotNull
        public String toString() {
            return "DocEdit(start=" + this.start + ", endOld=" + this.endOld + ", endNew=" + this.endNew + ")";
        }

        public int hashCode() {
            int n2 = this.start.hashCode();
            n2 = n2 * 31 + this.endOld.hashCode();
            n2 = n2 * 31 + this.endNew.hashCode();
            return n2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DocEdit)) {
                return false;
            }
            DocEdit docEdit = (DocEdit)other;
            if (!Intrinsics.areEqual((Object)this.start, (Object)docEdit.start)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.endOld, (Object)docEdit.endOld)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.endNew, (Object)docEdit.endNew);
        }
    }
}

