/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.qute.lang.codeInsight.editorActions;

import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.codeInsight.generation.SelfManagingCommenterUtil;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.quarkus.qute.lang.QuteLanguage;
import com.intellij.quarkus.qute.lang.codeInsight.editorActions.QuteCommenterKt;
import com.intellij.util.text.CharArrayUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u00010B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J(\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J \u0010 \u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J*\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J \u0010#\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J \u0010$\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J*\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010(\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\b\u0010)\u001a\u00020\u0007H\u0016J\b\u0010#\u001a\u00020\u0007H\u0016J\b\u0010$\u001a\u00020\u0007H\u0016J\b\u0010*\u001a\u00020\u0007H\u0016J\b\u0010+\u001a\u00020\u0007H\u0016J \u0010,\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fH\u0002J\b\u0010/\u001a\u00020\u000fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/quarkus/qute/lang/codeInsight/editorActions/QuteCommenter;", "Lcom/intellij/lang/Commenter;", "Lcom/intellij/codeInsight/generation/SelfManagingCommenter;", "Lcom/intellij/quarkus/qute/lang/codeInsight/editorActions/QuteCommenter$DataHolder;", "<init>", "()V", "COMMENT_OPENER", "", "COMMENT_CLOSER", "COMMENT_CONTENT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "LINE_COMMENT_CONTENT_PATTERN", "createLineCommentingState", "startLine", "", "endLine", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "createBlockCommentingState", "selectionStart", "selectionEnd", "commentLine", "", "line", "offset", "data", "uncommentLine", "isLineCommented", "", "getCommentPrefix", "getBlockCommentRange", "Lcom/intellij/openapi/util/TextRange;", "getBlockCommentPrefix", "getBlockCommentSuffix", "uncommentBlockComment", "startOffset", "endOffset", "insertBlockComment", "getLineCommentPrefix", "getCommentedBlockCommentPrefix", "getCommentedBlockCommentSuffix", "uncommentBlock", "lineStartOffset", "lineEndOffset", "getMinimalCommentedLength", "DataHolder", "intellij.quarkus"})
public final class QuteCommenter
implements Commenter,
SelfManagingCommenter<DataHolder> {
    @NotNull
    private final String COMMENT_OPENER;
    @NotNull
    private final String COMMENT_CLOSER;
    private final Pattern COMMENT_CONTENT_PATTERN = Pattern.compile("^(\\s*)\\{!(.*?)(?:!})?(\\s*)$", 32);
    private final Pattern LINE_COMMENT_CONTENT_PATTERN = Pattern.compile("^(\\s*)\\{!(.*?)!}(\\s*)$", 32);

    public QuteCommenter() {
        this.COMMENT_OPENER = "{!";
        this.COMMENT_CLOSER = "!}";
    }

    @NotNull
    public DataHolder createLineCommentingState(int startLine, int endLine, @NotNull Document document, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new DataHolder(file);
    }

    @NotNull
    public DataHolder createBlockCommentingState(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new DataHolder(file);
    }

    public void commentLine(int line, int offset, @NotNull Document document, @NotNull DataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        int lineStartOffset = document.getLineStartOffset(line);
        int lineEndOffset = document.getLineEndOffset(line);
        CharSequence lineContent = document.getCharsSequence().subSequence(lineStartOffset, lineEndOffset);
        int contentStartOffset = lineStartOffset + CharArrayUtil.shiftForward((CharSequence)lineContent, (int)0, (String)" \t");
        int contentEndOffset = lineStartOffset + CharArrayUtil.shiftBackward((CharSequence)lineContent, (int)lineContent.length(), (String)" \t");
        document.insertString(contentEndOffset, (CharSequence)this.COMMENT_CLOSER);
        document.insertString(contentStartOffset, (CharSequence)this.COMMENT_OPENER);
    }

    public void uncommentLine(int line, int offset, @NotNull Document document, @NotNull DataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        this.uncommentBlock(document, document.getLineStartOffset(line), document.getLineEndOffset(line));
    }

    public boolean isLineCommented(int line, int offset, @NotNull Document document, @NotNull DataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        int lineStartOffset = document.getLineStartOffset(line);
        int lineEndOffset = document.getLineEndOffset(line);
        return lineEndOffset - lineStartOffset < this.getMinimalCommentedLength() ? false : this.LINE_COMMENT_CONTENT_PATTERN.matcher(document.getCharsSequence().subSequence(lineStartOffset, lineEndOffset)).matches();
    }

    @NotNull
    public String getCommentPrefix(int line, @NotNull Document document, @NotNull DataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        return this.getLineCommentPrefix();
    }

    @Nullable
    public TextRange getBlockCommentRange(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull DataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence sequence = charSequence;
        int shiftedSelectionStart = CharArrayUtil.shiftForward((CharSequence)sequence, (int)selectionStart, (String)" \t\n");
        FileViewProvider fileViewProvider = data.getFile().getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"getViewProvider(...)");
        FileViewProvider fileViewProvider2 = fileViewProvider;
        PsiElement commentElement = fileViewProvider2.findElementAt(shiftedSelectionStart, (Language)QuteLanguage.INSTANCE);
        if (commentElement != fileViewProvider2.findElementAt(CharArrayUtil.shiftBackward((CharSequence)sequence, (int)(selectionEnd - 1), (String)" \t\n"))) {
            return null;
        }
        PsiElement psiElement = commentElement;
        if (psiElement == null || (psiElement = psiElement.getTextRange()) == null) {
            return null;
        }
        PsiElement commentTextRange = psiElement;
        return this.COMMENT_CONTENT_PATTERN.matcher(commentTextRange.subSequence(sequence)).matches() ? TextRange.create((int)commentTextRange.getStartOffset(), (int)commentTextRange.getEndOffset()) : null;
    }

    @NotNull
    public String getBlockCommentPrefix(int selectionStart, @NotNull Document document, @NotNull DataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        return this.COMMENT_OPENER;
    }

    @NotNull
    public String getBlockCommentSuffix(int selectionEnd, @NotNull Document document, @NotNull DataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        return this.COMMENT_CLOSER;
    }

    public void uncommentBlockComment(int startOffset, int endOffset, @NotNull Document document, @Nullable DataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.uncommentBlock(document, startOffset, endOffset);
    }

    @NotNull
    public TextRange insertBlockComment(int startOffset, int endOffset, @NotNull Document document, @NotNull DataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        TextRange textRange = SelfManagingCommenterUtil.insertBlockComment((int)startOffset, (int)endOffset, (Document)document, (String)this.COMMENT_OPENER, (String)this.COMMENT_CLOSER);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"insertBlockComment(...)");
        return textRange;
    }

    @NotNull
    public String getLineCommentPrefix() {
        return this.getBlockCommentPrefix();
    }

    @NotNull
    public String getBlockCommentPrefix() {
        return this.COMMENT_OPENER;
    }

    @NotNull
    public String getBlockCommentSuffix() {
        return this.COMMENT_CLOSER;
    }

    @NotNull
    public String getCommentedBlockCommentPrefix() {
        return this.getBlockCommentPrefix();
    }

    @NotNull
    public String getCommentedBlockCommentSuffix() {
        return this.getBlockCommentSuffix();
    }

    private final void uncommentBlock(Document document, int lineStartOffset, int lineEndOffset) {
        if (lineEndOffset - lineStartOffset < this.getMinimalCommentedLength()) {
            return;
        }
        CharSequence lineContent = document.getCharsSequence().subSequence(lineStartOffset, lineEndOffset);
        Matcher matcher = this.COMMENT_CONTENT_PATTERN.matcher(lineContent);
        if (!matcher.matches()) {
            QuteCommenterKt.access$getLOG$p().warn("Trying to uncomment non-commented:" + lineContent);
            return;
        }
        document.deleteString(lineStartOffset + matcher.end(2), lineStartOffset + matcher.start(3));
        document.deleteString(lineStartOffset + matcher.end(1), lineStartOffset + matcher.start(2));
    }

    private final int getMinimalCommentedLength() {
        return this.COMMENT_OPENER.length() + this.COMMENT_CLOSER.length();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/quarkus/qute/lang/codeInsight/editorActions/QuteCommenter$DataHolder;", "Lcom/intellij/codeInsight/generation/CommenterDataHolder;", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/psi/PsiFile;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "intellij.quarkus"})
    public static final class DataHolder
    extends CommenterDataHolder {
        @NotNull
        private final PsiFile file;

        public DataHolder(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
        }

        @NotNull
        public final PsiFile getFile() {
            return this.file;
        }
    }
}

