/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.lineProfiler.lineMapping;

import com.intellij.history.LocalHistory;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.lineProfiler.lineMapping.LinesMapper;
import com.intellij.profiler.lineProfiler.lineMapping.OneDirectionMapping;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\u001a#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\n\u001a\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000e\u001a+\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"FAIL_MARKER", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getOldLines", "", "", "oldContent", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "([BLcom/intellij/openapi/vfs/VirtualFile;)[Ljava/lang/String;", "getCurrentLines", "document", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/openapi/editor/Document;)[Ljava/lang/String;", "createMapping", "Lcom/intellij/profiler/lineProfiler/lineMapping/OneDirectionMapping;", "old", "new", "([Ljava/lang/String;[Ljava/lang/String;)Lcom/intellij/profiler/lineProfiler/lineMapping/OneDirectionMapping;", "loadFromLocalHistory", "date", "", "virtualFile", "intellij.profiler.lineProfiler"})
@SourceDebugExtension(value={"SMAP\nLinesMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinesMapper.kt\ncom/intellij/profiler/lineProfiler/lineMapping/LinesMapperKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,198:1\n13#2:199\n*S KotlinDebug\n*F\n+ 1 LinesMapper.kt\ncom/intellij/profiler/lineProfiler/lineMapping/LinesMapperKt\n*L\n154#1:199\n*E\n"})
public final class LinesMapperKt {
    @NotNull
    private static final byte[] FAIL_MARKER = new byte[0];
    @NotNull
    private static final Logger LOG;

    private static final String[] getOldLines(byte[] oldContent, VirtualFile vFile) {
        String text = ((Object)LoadTextUtil.getTextByBinaryPresentation((byte[])oldContent, (VirtualFile)vFile, (boolean)false, (boolean)false)).toString();
        return LineTokenizer.Companion.tokenize$default((LineTokenizer.Companion)LineTokenizer.Companion, (CharSequence)text, (boolean)false, (boolean)false, (int)4, null);
    }

    private static final String[] getCurrentLines(Document document) {
        return (String[])ActionsKt.runReadAction(() -> LinesMapperKt.getCurrentLines$lambda$0(document));
    }

    private static final OneDirectionMapping createMapping(String[] old, String[] stringArray) {
        Diff.Change change;
        try {
            change = Diff.buildChanges((Object[])old, (Object[])stringArray);
        }
        catch (FilesTooBigForDiffException e) {
            LOG.info((Throwable)e);
            return null;
        }
        Diff.Change change2 = change;
        if (change2 == null) {
            return null;
        }
        OneDirectionMapping result = new OneDirectionMapping();
        int prevLineInFirst = 0;
        int prevLineInSecond = 0;
        while (change2 != null) {
            result.addRange$intellij_profiler_lineProfiler(prevLineInFirst, prevLineInSecond, change2.line0 - prevLineInFirst, false);
            result.addRange$intellij_profiler_lineProfiler(change2.line0, change2.line1, Math.min(change2.inserted, change2.deleted), true);
            prevLineInFirst = change2.line0 + change2.deleted;
            prevLineInSecond = change2.line1 + change2.inserted;
            change2 = change2.link;
        }
        result.addRange$intellij_profiler_lineProfiler(prevLineInFirst, prevLineInSecond, old.length - prevLineInFirst, false);
        return result;
    }

    private static final byte[] loadFromLocalHistory(long date, VirtualFile virtualFile) {
        LocalHistory localHistory = LocalHistory.Companion.getInstance();
        return localHistory.getByteContent(virtualFile, arg_0 -> LinesMapperKt.loadFromLocalHistory$lambda$0(date, arg_0));
    }

    private static final String[] getCurrentLines$lambda$0(Document $document) {
        int lineCount = $document.getLineCount();
        CharSequence charSequence = $document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence chars = charSequence;
        int n = 0;
        String[] stringArray = new String[lineCount];
        while (n < lineCount) {
            int n2 = n++;
            stringArray[n2] = ((Object)chars.subSequence($document.getLineStartOffset(n2), $document.getLineEndOffset(n2))).toString();
        }
        return stringArray;
    }

    private static final boolean loadFromLocalHistory$lambda$0(long $date, long it) {
        return it < $date;
    }

    public static final /* synthetic */ byte[] access$getFAIL_MARKER$p() {
        return FAIL_MARKER;
    }

    public static final /* synthetic */ String[] access$getOldLines(byte[] oldContent, VirtualFile vFile) {
        return LinesMapperKt.getOldLines(oldContent, vFile);
    }

    public static final /* synthetic */ String[] access$getCurrentLines(Document document) {
        return LinesMapperKt.getCurrentLines(document);
    }

    public static final /* synthetic */ OneDirectionMapping access$createMapping(String[] old, String[] stringArray) {
        return LinesMapperKt.createMapping(old, stringArray);
    }

    public static final /* synthetic */ byte[] access$loadFromLocalHistory(long date, VirtualFile virtualFile) {
        return LinesMapperKt.loadFromLocalHistory(date, virtualFile);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LinesMapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

