/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Objects;
import com.jgoodies.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JToggleButton;

public final class ToggleButtonAdapter
extends JToggleButton.ToggleButtonModel {
    private final ValueModel subject;
    private final Object selectedValue;
    private final Object deselectedValue;

    public ToggleButtonAdapter(ValueModel subject) {
        this(subject, Boolean.TRUE, Boolean.FALSE);
    }

    public ToggleButtonAdapter(ValueModel subject, Object selectedValue, Object deselectedValue) {
        this.subject = (ValueModel)Preconditions.checkNotNull((Object)subject, (String)"The %1$s must not be null.", (Object[])new Object[]{"subject"});
        Preconditions.checkArgument((!Objects.equals((Object)selectedValue, (Object)deselectedValue) ? 1 : 0) != 0, (String)"The selected value must not equal the deselected value.");
        this.selectedValue = selectedValue;
        this.deselectedValue = deselectedValue;
        subject.addValueChangeListener(new SubjectValueChangeHandler());
        this.updateSelectedState();
    }

    @Override
    public void setSelected(boolean b) {
        this.subject.setValue(b ? this.selectedValue : this.deselectedValue);
        this.updateSelectedState();
    }

    private void updateSelectedState() {
        boolean subjectHoldsChoiceValue = Objects.equals((Object)this.selectedValue, (Object)this.subject.getValue());
        super.setSelected(subjectHoldsChoiceValue);
    }

    private final class SubjectValueChangeHandler
    implements PropertyChangeListener {
        private SubjectValueChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ToggleButtonAdapter.this.updateSelectedState();
        }
    }
}

