/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.inspection.LombokJavaInspectionBase;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigDiscovery;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class SpringQualifierCopyableLombokAnnotationInspection
extends LombokJavaInspectionBase {
    private static final String SPRING_QUALIFIER_FQN = "org.springframework.beans.factory.annotation.Qualifier";

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SpringQualifierCopyableLombokAnnotationInspection.$$$reportNull$$$0(0);
        }
        return new LombokElementVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "de/plushnikov/intellij/plugin/inspection/SpringQualifierCopyableLombokAnnotationInspection", "createVisitor"));
    }

    private static class LombokElementVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder holder;

        LombokElementVisitor(ProblemsHolder holder) {
            this.holder = holder;
        }

        public void visitAnnotation(@NotNull PsiAnnotation annotation) {
            Collection<String> configuredCopyableAnnotations;
            PsiClass psiClass;
            PsiElement annotationOwnerParent;
            PsiAnnotationOwner annotationOwner;
            if (annotation == null) {
                LombokElementVisitor.$$$reportNull$$$0(0);
            }
            if (annotation.hasQualifiedName(SpringQualifierCopyableLombokAnnotationInspection.SPRING_QUALIFIER_FQN) && (annotationOwner = annotation.getOwner()) instanceof PsiModifierList && (annotationOwnerParent = ((PsiModifierList)annotationOwner).getParent()) instanceof PsiField && (psiClass = ((PsiField)annotationOwnerParent).getContainingClass()) != null && PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.RequiredArgsConstructor", "lombok.AllArgsConstructor") && !(configuredCopyableAnnotations = ConfigDiscovery.getInstance().getMultipleValueLombokConfigProperty(ConfigKey.COPYABLE_ANNOTATIONS, psiClass)).contains(SpringQualifierCopyableLombokAnnotationInspection.SPRING_QUALIFIER_FQN)) {
                this.holder.registerProblem((PsiElement)annotation, LombokBundle.message("inspection.message.annotation.not.lombok.copyable", SpringQualifierCopyableLombokAnnotationInspection.SPRING_QUALIFIER_FQN), new LocalQuickFix[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "de/plushnikov/intellij/plugin/inspection/SpringQualifierCopyableLombokAnnotationInspection$LombokElementVisitor", "visitAnnotation"));
        }
    }
}

