/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import de.plushnikov.intellij.plugin.problem.LombokProblem;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.problem.ProblemValidationSink;
import de.plushnikov.intellij.plugin.processor.AbstractProcessor;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class JacksonizedProcessor
extends AbstractProcessor {
    public JacksonizedProcessor() {
        super(PsiElement.class, "lombok.extern.jackson.Jacksonized");
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JacksonizedProcessor.$$$reportNull$$$0(0);
        }
        List<PsiAnnotation> list = Collections.emptyList();
        if (list == null) {
            JacksonizedProcessor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<LombokProblem> verifyAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            JacksonizedProcessor.$$$reportNull$$$0(2);
        }
        ProblemValidationSink validationSink = new ProblemValidationSink();
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiMethod.class);
        Object psiModifierListOwner = null != psiMethod ? psiMethod : (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiClass.class);
        if (null != psiModifierListOwner) {
            JacksonizedProcessor.validateAnnotationOwner((PsiModifierListOwner)psiModifierListOwner, validationSink);
        }
        Set<LombokProblem> set = validationSink.getProblems();
        if (set == null) {
            JacksonizedProcessor.$$$reportNull$$$0(3);
        }
        return set;
    }

    public static boolean validateAnnotationOwner(@NotNull PsiModifierListOwner psiModifierListOwner, ProblemSink validationSink) {
        boolean hasJsonDeserialize;
        boolean isAbstract;
        if (psiModifierListOwner == null) {
            JacksonizedProcessor.$$$reportNull$$$0(4);
        }
        boolean hasBuilder = PsiAnnotationSearchUtil.isAnnotatedWith(psiModifierListOwner, "lombok.Builder");
        boolean hasSuperBuilder = PsiAnnotationSearchUtil.isAnnotatedWith(psiModifierListOwner, "lombok.experimental.SuperBuilder");
        if (!hasBuilder && !hasSuperBuilder) {
            validationSink.addWarningMessage("inspection.message.jacksonized.requires.builder.superbuilder", new Object[0]);
        }
        if (hasBuilder && hasSuperBuilder) {
            validationSink.addErrorMessage("inspection.message.jacksonized.cannot.process.both.builder.superbuilder", new Object[0]);
            validationSink.markFailed();
        }
        if (isAbstract = psiModifierListOwner.hasModifierProperty("abstract")) {
            validationSink.addErrorMessage("inspection.message.jacksonized.builder.on.abstract.classes", new Object[0]);
            validationSink.markFailed();
        }
        if (hasJsonDeserialize = PsiAnnotationSearchUtil.isAnnotatedWith(psiModifierListOwner, "com.fasterxml.jackson.databind.annotation.JsonDeserialize")) {
            validationSink.addErrorMessage("inspection.message.jacksonized.jsondeserialize.already.exists", new Object[0]);
            validationSink.markFailed();
        }
        return validationSink.success();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/JacksonizedProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiModifierListOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/JacksonizedProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "verifyAnnotation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOwner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

