/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.EqualsAndHashCodeProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.GetterProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.ToStringProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.AbstractConstructorClassProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.AllArgsConstructorProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.NoArgsConstructorProcessor;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValueProcessor
extends AbstractClassProcessor {
    public ValueProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.Value");
    }

    private static ToStringProcessor getToStringProcessor() {
        return LombokProcessorManager.getInstance().getToStringProcessor();
    }

    private static AllArgsConstructorProcessor getAllArgsConstructorProcessor() {
        return LombokProcessorManager.getInstance().getAllArgsConstructorProcessor();
    }

    private static NoArgsConstructorProcessor getNoArgsConstructorProcessor() {
        return LombokProcessorManager.getInstance().getNoArgsConstructorProcessor();
    }

    private static GetterProcessor getGetterProcessor() {
        return LombokProcessorManager.getInstance().getGetterProcessor();
    }

    private static EqualsAndHashCodeProcessor getEqualsAndHashCodeProcessor() {
        return LombokProcessorManager.getInstance().getEqualsAndHashCodeProcessor();
    }

    @Override
    protected boolean possibleToGenerateElementNamed(@NotNull String nameHint, @NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (nameHint == null) {
            ValueProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            ValueProcessor.$$$reportNull$$$0(1);
        }
        if (psiAnnotation == null) {
            ValueProcessor.$$$reportNull$$$0(2);
        }
        return nameHint.equals(ValueProcessor.getStaticConstructorNameValue(psiAnnotation)) || ValueProcessor.getNoArgsConstructorProcessor().possibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation) || ValueProcessor.getToStringProcessor().possibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation) || ValueProcessor.getEqualsAndHashCodeProcessor().possibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation) || ValueProcessor.getGetterProcessor().possibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation);
    }

    @Override
    protected Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            ValueProcessor.$$$reportNull$$$0(3);
        }
        if (psiAnnotation == null) {
            ValueProcessor.$$$reportNull$$$0(4);
        }
        ArrayList<String> result = new ArrayList<String>();
        String staticConstructorName = ValueProcessor.getStaticConstructorNameValue(psiAnnotation);
        if (StringUtil.isNotEmpty((String)staticConstructorName)) {
            result.add(staticConstructorName);
        }
        result.addAll(ValueProcessor.getNoArgsConstructorProcessor().getNamesOfPossibleGeneratedElements(psiClass, psiAnnotation));
        result.addAll(ValueProcessor.getToStringProcessor().getNamesOfPossibleGeneratedElements(psiClass, psiAnnotation));
        result.addAll(ValueProcessor.getEqualsAndHashCodeProcessor().getNamesOfPossibleGeneratedElements(psiClass, psiAnnotation));
        result.addAll(ValueProcessor.getGetterProcessor().getNamesOfPossibleGeneratedElements(psiClass, psiAnnotation));
        return result;
    }

    private static String getStaticConstructorNameValue(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            ValueProcessor.$$$reportNull$$$0(5);
        }
        return PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, "staticConstructor", "");
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            ValueProcessor.$$$reportNull$$$0(6);
        }
        if (psiClass == null) {
            ValueProcessor.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            ValueProcessor.$$$reportNull$$$0(8);
        }
        ValueProcessor.validateAnnotationOnRightType(psiClass, builder);
        if (builder.deepValidation()) {
            if (PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.EqualsAndHashCode")) {
                ValueProcessor.getEqualsAndHashCodeProcessor().validateCallSuperParamExtern(psiAnnotation, psiClass, builder);
            }
            if (ValueProcessor.shouldGenerateConstructor(psiClass)) {
                ValueProcessor.getAllArgsConstructorProcessor().validateBaseClassConstructor(psiClass, builder);
            }
        }
        return builder.success();
    }

    private static void validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiClass == null) {
            ValueProcessor.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            ValueProcessor.$$$reportNull$$$0(10);
        }
        if (psiClass.isAnnotationType() || psiClass.isInterface() || psiClass.isEnum() || psiClass.isRecord()) {
            builder.addErrorMessage("inspection.message.value.only.supported.on.class.type", new Object[0]).withLocalQuickFixes(() -> PsiQuickFixFactory.createDeleteAnnotationFix(psiClass, "lombok.Value"));
            builder.markFailed();
        }
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        if (psiClass == null) {
            ValueProcessor.$$$reportNull$$$0(11);
        }
        if (psiAnnotation == null) {
            ValueProcessor.$$$reportNull$$$0(12);
        }
        if (target == null) {
            ValueProcessor.$$$reportNull$$$0(13);
        }
        if (PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.Getter")) {
            target.addAll(ValueProcessor.getGetterProcessor().createFieldGetters(psiClass, "public", nameHint));
        }
        if (PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.EqualsAndHashCode") && ValueProcessor.getEqualsAndHashCodeProcessor().noHintOrPossibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation)) {
            target.addAll(ValueProcessor.getEqualsAndHashCodeProcessor().createEqualAndHashCode(psiClass, psiAnnotation));
        }
        if (PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.ToString") && ValueProcessor.getToStringProcessor().noHintOrPossibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation)) {
            target.addAll(ValueProcessor.getToStringProcessor().createToStringMethod(psiClass, psiAnnotation));
        }
        String staticName = ValueProcessor.getStaticConstructorNameValue(psiAnnotation);
        if (nameHint != null && !nameHint.equals(staticName) && !nameHint.equals(psiClass.getName())) {
            return;
        }
        if (!ValueProcessor.hasLombokConstructorAnnotations(psiClass)) {
            Collection<PsiField> requiredFields = AbstractConstructorClassProcessor.getAllFields(psiClass);
            target.addAll(ValueProcessor.getAllArgsConstructorProcessor().createAllArgsConstructor(psiClass, "public", psiAnnotation, staticName, requiredFields, true));
        }
        if (this.shouldGenerateExtraNoArgsConstructor(psiClass)) {
            target.addAll(ValueProcessor.getNoArgsConstructorProcessor().createNoArgsConstructor(psiClass, "private", psiAnnotation, true));
        }
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ValueProcessor.$$$reportNull$$$0(14);
        }
        Collection<PsiAnnotation> result = super.collectProcessedAnnotations(psiClass);
        this.addClassAnnotation(result, psiClass, "lombok.experimental.NonFinal", "lombok.experimental.PackagePrivate");
        this.addFieldsAnnotation(result, psiClass, "lombok.experimental.NonFinal", "lombok.experimental.PackagePrivate");
        Collection<PsiAnnotation> collection = result;
        if (collection == null) {
            ValueProcessor.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        if (psiField == null) {
            ValueProcessor.$$$reportNull$$$0(16);
        }
        if (psiAnnotation == null) {
            ValueProcessor.$$$reportNull$$$0(17);
        }
        return LombokPsiElementUsage.READ_WRITE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameHint";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/ValueProcessor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/ValueProcessor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "possibleToGenerateElementNamed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStaticConstructorNameValue";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 15: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15 -> new IllegalStateException(string);
        };
    }
}

