/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.handler;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import de.plushnikov.intellij.plugin.processor.handler.BuilderHandler;
import de.plushnikov.intellij.plugin.processor.handler.BuilderInfo;
import de.plushnikov.intellij.plugin.psi.LombokLightClassBuilder;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuilderHelper {
    @NotNull
    public static String renderChainedMethods(Collection<String> remainingBuilderMethods, @NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            BuilderHelper.$$$reportNull$$$0(0);
        }
        StringBuilder chainedBuilderMethodCalls = new StringBuilder();
        StringUtil.join(remainingBuilderMethods, (String)"().", (StringBuilder)chainedBuilderMethodCalls);
        if (!chainedBuilderMethodCalls.isEmpty()) {
            chainedBuilderMethodCalls.append("().");
        }
        chainedBuilderMethodCalls.append(BuilderHandler.getBuildMethodName(psiAnnotation)).append("()");
        String string = chainedBuilderMethodCalls.toString();
        if (string == null) {
            BuilderHelper.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static List<String> getAllBuilderMethodNames(@NotNull PsiModifierListOwner psiModifierListOwner, @NotNull PsiAnnotation psiAnnotation, @NotNull Predicate<BuilderInfo> filter) {
        PsiMethod psiMethod1;
        PsiClass containingClass;
        if (psiModifierListOwner == null) {
            BuilderHelper.$$$reportNull$$$0(2);
        }
        if (psiAnnotation == null) {
            BuilderHelper.$$$reportNull$$$0(3);
        }
        if (filter == null) {
            BuilderHelper.$$$reportNull$$$0(4);
        }
        if (null == (containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiModifierListOwner, PsiClass.class, (boolean)false))) {
            return Collections.emptyList();
        }
        PsiMethod psiMethod = psiModifierListOwner instanceof PsiMethod ? (psiMethod1 = (PsiMethod)psiModifierListOwner) : null;
        String builderClassName = BuilderHandler.getBuilderClassName(containingClass, psiAnnotation, psiMethod);
        PsiClass builderClass = containingClass.findInnerClassByName(builderClassName, false);
        if (null == builderClass) {
            return Collections.emptyList();
        }
        List<String> result = BuilderHelper.getBuilderMethodNames(psiAnnotation, filter, containingClass, psiMethod, builderClass);
        if (psiAnnotation.hasQualifiedName("lombok.experimental.SuperBuilder")) {
            for (PsiClass superClass = containingClass.getSuperClass(); null != superClass && !"java.lang.Class".equals(superClass.getQualifiedName()); superClass = superClass.getSuperClass()) {
                List<String> nextResult = BuilderHelper.getBuilderMethodNames(psiAnnotation, filter, superClass, psiMethod, builderClass);
                result.addAll(nextResult);
            }
        }
        return result;
    }

    @NotNull
    private static List<String> getBuilderMethodNames(@NotNull PsiAnnotation psiAnnotation, @NotNull Predicate<BuilderInfo> filter, @NotNull PsiClass containingClass, @Nullable PsiMethod psiMethod, @NotNull PsiClass builderClass) {
        if (psiAnnotation == null) {
            BuilderHelper.$$$reportNull$$$0(5);
        }
        if (filter == null) {
            BuilderHelper.$$$reportNull$$$0(6);
        }
        if (containingClass == null) {
            BuilderHelper.$$$reportNull$$$0(7);
        }
        if (builderClass == null) {
            BuilderHelper.$$$reportNull$$$0(8);
        }
        List<BuilderInfo> builderInfos = BuilderHandler.createBuilderInfos(psiAnnotation, containingClass, psiMethod, builderClass);
        List<String> list = builderInfos.stream().filter(filter).map(BuilderInfo::renderBuilderMethodName).collect(Collectors.toList());
        if (list == null) {
            BuilderHelper.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public static Pair<PsiAnnotation, PsiNamedElement> findBuilderAnnotation(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            BuilderHelper.$$$reportNull$$$0(10);
        }
        for (PsiClass psiClass = psiMethod.getContainingClass(); psiClass != null; psiClass = psiClass.getContainingClass()) {
            if (psiClass instanceof LombokLightClassBuilder) continue;
            PsiAnnotation psiAnnotation = BuilderHelper.getBuilderAnnotation((PsiModifierListOwner)psiClass);
            if (null != psiAnnotation) {
                return Pair.pair((Object)psiAnnotation, (Object)psiClass);
            }
            Collection<PsiMethod> psiMethods = PsiClassUtil.collectClassMethodsIntern(psiClass);
            for (PsiMethod method : psiMethods) {
                PsiAnnotation psiMethodAnnotation = BuilderHelper.getBuilderAnnotation((PsiModifierListOwner)method);
                if (null == psiMethodAnnotation) continue;
                return Pair.pair((Object)psiMethodAnnotation, (Object)method);
            }
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation getBuilderAnnotation(@NotNull PsiModifierListOwner psiModifierListOwner) {
        if (psiModifierListOwner == null) {
            BuilderHelper.$$$reportNull$$$0(11);
        }
        return PsiAnnotationSearchUtil.findAnnotation(psiModifierListOwner, "lombok.Builder", "lombok.experimental.SuperBuilder");
    }

    public static List<String> getAllMethodsInChainFromMiddle(@Nullable PsiMethodCallExpression methodCallExpression) {
        PsiElement psiElement;
        ArrayList<String> backwardMethods = new ArrayList<String>();
        PsiMethodCallExpression currentCall = methodCallExpression;
        while (currentCall != null) {
            PsiExpression qualifier;
            PsiReferenceExpression methodExpression = currentCall.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (methodName != null) {
                backwardMethods.add(methodName);
            }
            if (!((qualifier = methodExpression.getQualifierExpression()) instanceof PsiMethodCallExpression)) break;
            currentCall = (PsiMethodCallExpression)qualifier;
        }
        Collections.reverse(backwardMethods);
        if (methodCallExpression == null) {
            return backwardMethods;
        }
        ArrayList<String> forwardMethods = new ArrayList<String>();
        PsiElement parent = methodCallExpression.getParent();
        while (parent instanceof PsiReferenceExpression && (psiElement = parent.getParent()) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression parentCall = (PsiMethodCallExpression)psiElement;
            String methodName = ((PsiReferenceExpression)parent).getReferenceName();
            if (methodName != null) {
                forwardMethods.add(methodName);
            }
            parent = parentCall.getParent();
        }
        ArrayList<String> allMethods = new ArrayList<String>(backwardMethods);
        allMethods.addAll(forwardMethods);
        return allMethods;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/handler/BuilderHelper";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiModifierListOwner";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/handler/BuilderHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "renderChainedMethods";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderMethodNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "renderChainedMethods";
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllBuilderMethodNames";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderMethodNames";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findBuilderAnnotation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderAnnotation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 9 -> new IllegalStateException(string);
        };
    }
}

