/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.psi;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LombokLightModifierList
extends LightModifierList
implements SyntheticElement {
    private final Map<String, PsiAnnotation> myAnnotations;
    private final Set<String> myImplicitModifiers;
    private PsiElement myParent;

    public LombokLightModifierList(@NotNull PsiManager manager) {
        if (manager == null) {
            LombokLightModifierList.$$$reportNull$$$0(0);
        }
        this(manager, (Language)JavaLanguage.INSTANCE);
    }

    public LombokLightModifierList(@NotNull PsiManager manager, @NotNull Language language) {
        if (manager == null) {
            LombokLightModifierList.$$$reportNull$$$0(1);
        }
        if (language == null) {
            LombokLightModifierList.$$$reportNull$$$0(2);
        }
        this(manager, language, Collections.emptyList(), new String[0]);
    }

    public LombokLightModifierList(PsiManager manager, Language language, Collection<String> implicitModifiers, String ... modifiers) {
        super(manager, language, modifiers);
        this.myAnnotations = new HashMap<String, PsiAnnotation>();
        this.myImplicitModifiers = new HashSet<String>(implicitModifiers);
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            LombokLightModifierList.$$$reportNull$$$0(3);
        }
        return this.myImplicitModifiers.contains(name) || super.hasModifierProperty(name);
    }

    public void addImplicitModifierProperty(@PsiModifier.ModifierConstant @NotNull @NonNls String implicitModifier) {
        if (implicitModifier == null) {
            LombokLightModifierList.$$$reportNull$$$0(4);
        }
        this.myImplicitModifiers.add(implicitModifier);
    }

    public void setModifierProperty(@PsiModifier.ModifierConstant @NotNull @NonNls String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            LombokLightModifierList.$$$reportNull$$$0(5);
        }
        if (value) {
            this.addModifier(name);
        } else if (this.hasModifierProperty(name)) {
            this.removeModifier(name);
        }
    }

    private void removeModifier(@PsiModifier.ModifierConstant @NotNull @NonNls String name) {
        if (name == null) {
            LombokLightModifierList.$$$reportNull$$$0(6);
        }
        Collection<String> myModifiers = this.collectAllModifiers();
        myModifiers.remove(name);
        this.clearModifiers();
        for (String modifier : myModifiers) {
            this.addModifier(modifier);
        }
    }

    private Collection<String> collectAllModifiers() {
        HashSet<String> result = new HashSet<String>();
        for (String modifier : PsiModifier.MODIFIERS) {
            if (!this.hasExplicitModifier(modifier)) continue;
            result.add(modifier);
        }
        return result;
    }

    public LombokLightModifierList withParent(@NotNull PsiElement parent) {
        if (parent == null) {
            LombokLightModifierList.$$$reportNull$$$0(7);
        }
        this.myParent = parent;
        return this;
    }

    public LombokLightModifierList withAnnotation(@NotNull String qualifiedName, @NotNull PsiAnnotation psiAnnotation) {
        if (qualifiedName == null) {
            LombokLightModifierList.$$$reportNull$$$0(8);
        }
        if (psiAnnotation == null) {
            LombokLightModifierList.$$$reportNull$$$0(9);
        }
        this.myAnnotations.put(qualifiedName, psiAnnotation);
        return this;
    }

    public LombokLightModifierList withAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        String qualifiedName;
        if (psiAnnotation == null) {
            LombokLightModifierList.$$$reportNull$$$0(10);
        }
        if (null != (qualifiedName = psiAnnotation.getQualifiedName())) {
            return this.withAnnotation(qualifiedName, psiAnnotation);
        }
        return this;
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            LombokLightModifierList.$$$reportNull$$$0(11);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.getProject());
        PsiAnnotation psiAnnotation = elementFactory.createAnnotationFromText("@" + qualifiedName, null);
        this.myAnnotations.put(qualifiedName, psiAnnotation);
        PsiAnnotation psiAnnotation2 = psiAnnotation;
        if (psiAnnotation2 == null) {
            LombokLightModifierList.$$$reportNull$$$0(12);
        }
        return psiAnnotation2;
    }

    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            LombokLightModifierList.$$$reportNull$$$0(13);
        }
        return this.myAnnotations.get(qualifiedName);
    }

    public PsiAnnotation @NotNull [] getAnnotations() {
        PsiAnnotation[] result = PsiAnnotation.EMPTY_ARRAY;
        if (!this.myAnnotations.isEmpty()) {
            Collection<PsiAnnotation> annotations = this.myAnnotations.values();
            result = annotations.toArray(PsiAnnotation.EMPTY_ARRAY);
        }
        if (result == null) {
            LombokLightModifierList.$$$reportNull$$$0(14);
        }
        return result;
    }

    public TextRange getTextRange() {
        TextRange r = super.getTextRange();
        return r == null ? TextRange.EMPTY_RANGE : r;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public String toString() {
        return "LombokLightModifierList";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LombokLightModifierList that = (LombokLightModifierList)((Object)o);
        return this.myAnnotations.equals(that.myAnnotations);
    }

    public int hashCode() {
        return this.myAnnotations.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitModifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/psi/LombokLightModifierList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/psi/LombokLightModifierList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addAnnotation";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitModifierProperty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setModifierProperty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeModifier";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withParent";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "withAnnotation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
            case 12: 
            case 14: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 14 -> new IllegalStateException(string);
        };
    }
}

