/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.quickfix;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.daemon.impl.quickfix.ModifierFix;
import com.intellij.codeInsight.intention.AddAnnotationModCommandAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import com.siyeh.ig.fixes.ChangeAnnotationParameterQuickFix;
import de.plushnikov.intellij.plugin.quickfix.CreateFieldQuickFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiQuickFixFactory {
    @Nullable
    public static LocalQuickFix createDeleteAnnotationFix(@NotNull PsiClass psiClass, @Nullable String annotationFQN) {
        if (psiClass == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(0);
        }
        if (annotationFQN == null) {
            return null;
        }
        PsiAnnotation annotation = psiClass.getAnnotation(annotationFQN);
        if (annotation == null) {
            return null;
        }
        return new RemoveAnnotationQuickFix(annotation, (PsiModifierListOwner)psiClass);
    }

    public static LocalQuickFix createAddAnnotationFix(@NotNull PsiClass psiClass, @NotNull String annotationFQN, @Nullable String annotationParam) {
        if (psiClass == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(1);
        }
        if (annotationFQN == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(2);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
        PsiAnnotation newAnnotation = elementFactory.createAnnotationFromText("@" + annotationFQN + "(" + StringUtil.notNullize((String)annotationParam) + ")", (PsiElement)psiClass);
        PsiNameValuePair[] attributes = newAnnotation.getParameterList().getAttributes();
        return LocalQuickFix.from((ModCommandAction)new AddAnnotationModCommandAction(annotationFQN, (PsiModifierListOwner)psiClass, attributes, ExternalAnnotationsManager.AnnotationPlace.IN_CODE, new String[0]));
    }

    @NotNull
    public static LocalQuickFix createAddAnnotationFix(@NotNull String annotationFQN, @NotNull PsiModifierListOwner targetForAnnotation) {
        if (annotationFQN == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(3);
        }
        if (targetForAnnotation == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(4);
        }
        LocalQuickFix localQuickFix = LocalQuickFix.from((ModCommandAction)new AddAnnotationModCommandAction(annotationFQN, targetForAnnotation, PsiNameValuePair.EMPTY_ARRAY, ExternalAnnotationsManager.AnnotationPlace.IN_CODE, new String[0]));
        if (localQuickFix == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(5);
        }
        return localQuickFix;
    }

    public static LocalQuickFix createModifierListFix(@NotNull PsiModifierListOwner owner, @NotNull String modifier, boolean shouldHave, boolean showContainingClass) {
        if (owner == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(6);
        }
        if (modifier == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(7);
        }
        return LocalQuickFix.from((ModCommandAction)new ModifierFix(owner, modifier, shouldHave, showContainingClass));
    }

    public static LocalQuickFix createNewFieldFix(@NotNull PsiClass psiClass, @NotNull String name, @NotNull PsiType psiType, @Nullable String initializerText, String ... modifiers) {
        if (psiClass == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(8);
        }
        if (name == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(9);
        }
        if (psiType == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(10);
        }
        return LocalQuickFix.from((ModCommandAction)new CreateFieldQuickFix(psiClass, name, psiType, initializerText, modifiers));
    }

    public static LocalQuickFix createChangeAnnotationParameterFix(@NotNull PsiAnnotation psiAnnotation, @NotNull String name, @Nullable String newValue) {
        if (psiAnnotation == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(11);
        }
        if (name == null) {
            PsiQuickFixFactory.$$$reportNull$$$0(12);
        }
        return LocalQuickFix.from((ModCommandAction)new ChangeAnnotationParameterQuickFix(psiAnnotation, name, newValue));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetForAnnotation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/quickfix/PsiQuickFixFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/quickfix/PsiQuickFixFactory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddAnnotationFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDeleteAnnotationFix";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAddAnnotationFix";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createModifierListFix";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createNewFieldFix";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createChangeAnnotationParameterFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

