/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.GlobalDeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.IrFileSerializer;
import org.jetbrains.kotlin.backend.common.serialization.IrSerializationSettings;
import org.jetbrains.kotlin.builtins.FunctionInterfacePackageFragment;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragmentsKt;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.library.SerializedIrFile;
import org.jetbrains.kotlin.library.SerializedIrModule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000e\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u001a\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u0014\u001a\u00020\u0015X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleSerializer;", "Serializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;", "", "settings", "Lorg/jetbrains/kotlin/backend/common/serialization/IrSerializationSettings;", "diagnosticReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/serialization/IrSerializationSettings;Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;)V", "getSettings", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrSerializationSettings;", "getDiagnosticReporter", "()Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "createFileSerializer", "(Lorg/jetbrains/kotlin/backend/common/serialization/IrSerializationSettings;)Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;", "backendSpecificFileFilter", "", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "globalDeclarationTable", "Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "getGlobalDeclarationTable", "()Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "serializeIrFile", "Lorg/jetbrains/kotlin/library/SerializedIrFile;", "serializePreparedInlinableFunctions", "preparedInlineFunctionCopies", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "serializedIrModule", "Lorg/jetbrains/kotlin/library/SerializedIrModule;", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIrModuleSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrModuleSerializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IrModuleSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n777#2:58\n873#2,2:59\n777#2:61\n873#2,2:62\n1586#2:64\n1661#2,3:65\n*S KotlinDebug\n*F\n+ 1 IrModuleSerializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IrModuleSerializer\n*L\n45#1:58\n45#1:59,2\n46#1:61\n46#1:62,2\n47#1:64\n47#1:65,3\n*E\n"})
public abstract class IrModuleSerializer<Serializer extends IrFileSerializer> {
    @NotNull
    private final IrSerializationSettings settings;
    @NotNull
    private final IrDiagnosticReporter diagnosticReporter;

    public IrModuleSerializer(@NotNull IrSerializationSettings settings, @NotNull IrDiagnosticReporter diagnosticReporter) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
        this.settings = settings;
        this.diagnosticReporter = diagnosticReporter;
    }

    @NotNull
    protected final IrSerializationSettings getSettings() {
        return this.settings;
    }

    @NotNull
    protected final IrDiagnosticReporter getDiagnosticReporter() {
        return this.diagnosticReporter;
    }

    @NotNull
    public abstract Serializer createFileSerializer(@NotNull IrSerializationSettings var1);

    public static /* synthetic */ IrFileSerializer createFileSerializer$default(IrModuleSerializer irModuleSerializer, IrSerializationSettings irSerializationSettings, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createFileSerializer");
        }
        if ((n & 1) != 0) {
            irSerializationSettings = irModuleSerializer.settings;
        }
        return irModuleSerializer.createFileSerializer(irSerializationSettings);
    }

    protected boolean backendSpecificFileFilter(@NotNull IrFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    @NotNull
    protected abstract GlobalDeclarationTable getGlobalDeclarationTable();

    private final SerializedIrFile serializeIrFile(IrFile file) {
        IrFileSerializer fileSerializer = IrModuleSerializer.createFileSerializer$default(this, null, 1, null);
        return fileSerializer.serializeIrFile(file);
    }

    private final SerializedIrFile serializePreparedInlinableFunctions(List<? extends IrSimpleFunction> preparedInlineFunctionCopies) {
        return IrModuleSerializer.createFileSerializer$default(this, null, 1, null).serializeIrFileWithPreparedInlineFunctions(preparedInlineFunctionCopies);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SerializedIrModule serializedIrModule(@NotNull IrModuleFragment module) {
        SerializedIrFile serializedIrFile;
        void $this$mapTo$iv$iv;
        IrFile p0;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Iterable $this$filter$iv = module.getFiles();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrFile it = (IrFile)element$iv$iv;
            boolean bl = false;
            if (!(!(IrPackageFragmentsKt.getPackageFragmentDescriptor(it) instanceof FunctionInterfacePackageFragment))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            p0 = (IrFile)element$iv$iv;
            boolean bl = false;
            if (!this.backendSpecificFileFilter(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (IrFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.serializeIrFile(p0));
        }
        List serializedFiles = (List)destination$iv$iv;
        if (this.settings.getShouldCheckSignaturesOnUniqueness()) {
            this.getGlobalDeclarationTable().getClashDetector$ir_serialization_common().reportErrorsTo(this.diagnosticReporter);
        }
        List<IrSimpleFunction> list = IrInlineUtilsKt.getPreparedInlineFunctionCopies(module);
        if (list != null) {
            List<IrSimpleFunction> it = list;
            boolean bl = false;
            serializedIrFile = this.serializePreparedInlinableFunctions(it);
        } else {
            serializedIrFile = null;
        }
        SerializedIrFile inlinableFunctionsFile = serializedIrFile;
        return new SerializedIrModule((Collection)serializedFiles, inlinableFunctionsFile);
    }
}

