/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6TypeEvaluator;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptExpressionWithTypeArgumentsTypeEvaluator;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.TypeScriptExpressionWithTypeArguments;
import com.intellij.lang.javascript.psi.TypeScriptSatisfiesExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNotNullExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformer;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSModuleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTemplateLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTemplateLiteralJSTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyIndexedAccessType;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeEvaluator
extends ES6TypeEvaluator {
    public static final String THIS_TYPE_NAME = "ThisType";

    public TypeScriptTypeEvaluator(@NotNull JSEvaluateContext context) {
        if (context == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(0);
        }
        super(context);
    }

    @Nullable
    private static JSType toFalsy(@Nullable JSType type, JSTypeSource source) {
        if (JSTypeCastUtil.isFalsy(type)) {
            return type;
        }
        if (type instanceof JSStringType && !(type instanceof JSStringLiteralTypeImpl)) {
            return new JSStringLiteralTypeImpl("", false, source);
        }
        if (type instanceof JSNumberType && !(type instanceof JSNumberLiteralTypeImpl)) {
            return new JSNumberLiteralTypeImpl(0.0, false, source, "0");
        }
        if (type instanceof JSBigIntType && !(type instanceof JSBigIntLiteralTypeImpl)) {
            return new JSBigIntLiteralTypeImpl(BigInteger.ZERO, false, source, "0n");
        }
        if (type instanceof JSBooleanType && !(type instanceof JSBooleanLiteralTypeImpl)) {
            return new JSBooleanLiteralTypeImpl(false, false, source);
        }
        return null;
    }

    @Nullable
    private static JSType toFalsyTypeAfterAndOperator(@Nullable JSType type, JSTypeSource source) {
        JSType initialType = type;
        if (JSTypeUtils.isAnyType(type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type, source.getSourceElement()))) {
            return initialType;
        }
        if (type instanceof JSUnionType) {
            ArrayList<JSType> allFalsy = new ArrayList<JSType>();
            for (JSType part : ((JSUnionType)type).getTypes()) {
                JSType falsy = TypeScriptTypeEvaluator.toFalsy(part, source);
                if (falsy == null) continue;
                allFalsy.add(falsy);
            }
            return allFalsy.isEmpty() ? null : JSCompositeTypeFactory.createUnionType(source, allFalsy);
        }
        return TypeScriptTypeEvaluator.toFalsy(type, source);
    }

    @Override
    protected void evaluatePlusType(@NotNull JSBinaryExpression binaryExpression, @Nullable JSType lProcType, @Nullable JSType rProcType) {
        if (binaryExpression == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(1);
        }
        super.evaluatePlusType(binaryExpression, JSTypeUtils.removeNullableComponents(lProcType), JSTypeUtils.removeNullableComponents(rProcType));
    }

    @Override
    protected void evaluateAndOrOrType(@NotNull JSExpression rawqualifier, @NotNull IElementType sign, @Nullable JSType lProcType, @Nullable JSType rProcType) {
        JSType type;
        if (rawqualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(2);
        }
        if (sign == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(3);
        }
        if ((type = TypeScriptTypeEvaluator.getAndOrOrOrQuestType(lProcType, rProcType, sign, (PsiElement)rawqualifier, TypeScriptConfigUtil.strictNullChecks((PsiElement)rawqualifier))) != null) {
            this.addType(type);
        } else {
            this.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    @Nullable
    public static JSType getAndOrOrOrQuestType(@Nullable JSType lProcType, @Nullable JSType rProcType, @NotNull IElementType sign, @NotNull PsiElement context, boolean isStrictNullChecks) {
        boolean isTypeScript;
        if (sign == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(4);
        }
        if (context == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(5);
        }
        boolean strictNullChecks = (isTypeScript = DialectDetector.isTypeScript(context)) && isStrictNullChecks;
        JSType originalLProc = lProcType;
        if (sign == JSTokenTypes.OROR) {
            lProcType = JSTypeUtils.removeFalsyComponents(lProcType);
        } else if (sign == JSTokenTypes.QUEST_QUEST) {
            lProcType = JSTypeUtils.removeNullableComponents(lProcType);
        } else if (sign == JSTokenTypes.ANDAND) {
            lProcType = TypeScriptTypeEvaluator.toFalsyTypeAfterAndOperator(lProcType, JSTypeSourceFactory.createTypeSource(context, true));
        }
        if (isTypeScript && lProcType != null && rProcType != null && sign == JSTokenTypes.OROR) {
            return TypeScriptTypeRelations.getBestChoiceType(lProcType, rProcType, context);
        }
        if (sign == JSTokenTypes.QUEST_QUEST) {
            if (lProcType instanceof TypeScriptNeverType) {
                return rProcType;
            }
            if (strictNullChecks && lProcType == originalLProc) {
                return lProcType;
            }
            return TypeScriptTypeRelations.getBestChoiceType(lProcType, rProcType, context);
        }
        if (isTypeScript && !strictNullChecks && sign != JSTokenTypes.OROR) {
            lProcType = null;
        }
        if (lProcType == null) {
            return rProcType;
        }
        if (rProcType == null) {
            return lProcType;
        }
        return JSCompositeTypeFactory.createUnionType(JSTypeSourceFactory.createTypeSource(context, true), Arrays.asList(lProcType, rProcType));
    }

    @Override
    protected void addTypeFromElementResolveResult(@Nullable PsiElement resolveResult) {
        if (resolveResult instanceof TypeScriptPropertySignature) {
            TypeScriptPropertySignature propertySignature = (TypeScriptPropertySignature)resolveResult;
            JSTypeDeclaration propertyType = propertySignature.getTypeDeclaration();
            if (propertyType instanceof JSFunction) {
                this.processFunction((JSFunction)((Object)propertyType));
            } else if (propertyType != null) {
                JSType jsType = propertySignature.getJSType();
                if (propertySignature.isOptional() && jsType != null) {
                    jsType = JSTypeGuardUtil.wrapWithUndefined(jsType, jsType.getSource());
                }
                this.addType(jsType);
            }
        } else if (resolveResult instanceof TypeScriptModule) {
            this.addTypeFromModule((TypeScriptModule)resolveResult);
        } else if (resolveResult instanceof TypeScriptImportStatement) {
            this.addTypeFromImportStatement((TypeScriptImportStatement)resolveResult);
        } else if (resolveResult instanceof TypeScriptIndexSignature) {
            JSType type = ((TypeScriptIndexSignature)resolveResult).getMemberType();
            this.addType(type);
        } else if (!(resolveResult instanceof TypeScriptCallSignature)) {
            if (resolveResult instanceof TypeScriptGlobalModuleExportDeclaration) {
                for (PsiElement element : ((TypeScriptGlobalModuleExportDeclaration)resolveResult).getModules()) {
                    this.addTypeFromExternalModuleReferenceResolveResult(element);
                }
            } else {
                super.addTypeFromElementResolveResult(resolveResult);
            }
        }
    }

    private void addTypeFromModule(TypeScriptModule resolveResult) {
        if (resolveResult.isShorthandAmbientModule()) {
            this.addType(JSAnyType.get(resolveResult));
            return;
        }
        this.addTypeFromLocalModule(resolveResult);
    }

    private void addTypeFromLocalModule(@NotNull TypeScriptModule resolveResult) {
        if (resolveResult == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(6);
        }
        if (resolveResult.isExternal()) {
            this.addType(new JSModuleTypeImpl(resolveResult, false).copyWithStrict(this.myContext.isStrict()));
            return;
        }
        String name = resolveResult.getName();
        if (!StringUtil.isEmpty((String)name)) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(resolveResult, true);
            JSType jsType = JSNamedTypeFactory.createType(name, source, JSContext.STATIC);
            this.addType(jsType);
        }
    }

    private void addTypeFromImportStatement(TypeScriptImportStatement importStatement) {
        TypeScriptEntityName internalModuleReference = importStatement.getInternalModuleReference();
        TypeScriptExternalModuleReference externalModuleReference = importStatement.getExternalModuleReference();
        if (internalModuleReference != null) {
            List<PsiElement> elements = JSResolveResult.toElements(internalModuleReference.multiResolve(false));
            this.addTypeFromInternalModules(elements);
        } else if (externalModuleReference != null) {
            Collection<PsiElement> elements = externalModuleReference.multiResolve();
            for (PsiElement element : elements) {
                this.addTypeFromExternalModuleReferenceResolveResult(element);
            }
        }
    }

    private void addTypeFromInternalModules(Collection<PsiElement> elements) {
        if (elements.isEmpty()) {
            return;
        }
        if (elements.size() == 1) {
            PsiElement item = (PsiElement)ContainerUtil.getFirstItem(elements);
            assert (item != null);
            this.addTypeFromResolveResult(item);
            return;
        }
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        if (expression == null) {
            return;
        }
        List<TypeScriptModule> modules = elements.stream().filter(TypeScriptModule.class::isInstance).map(TypeScriptModule.class::cast).toList();
        if (!modules.isEmpty()) {
            TypeScriptModule module = (TypeScriptModule)ContainerUtil.getFirstItem(modules);
            assert (module != null);
            this.addTypeFromLocalModule(module);
        }
        for (PsiElement element : elements) {
            if (element instanceof TypeScriptModule) continue;
            this.addTypeFromResolveResult(element);
        }
    }

    @Override
    protected void processThisQualifierExpression(@NotNull JSThisExpression rawqualifier, @NotNull JSClass jsClass, @NotNull JSContext staticOrInstance) {
        TypeScriptTypeParameter[] parametersForOwner;
        String name;
        if (rawqualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(7);
        }
        if (jsClass == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(8);
        }
        if (staticOrInstance == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(9);
        }
        if ((name = jsClass.getQualifiedName()) != null && (parametersForOwner = TypeScriptPsiUtil.getTypeParametersForOwner(jsClass)).length > 0 && staticOrInstance == JSContext.INSTANCE) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
            JSTypeSource classNameSource = JSTypeSourceFactory.createTypeSource(jsClass, true);
            List<JSType> types = TypeScriptGenericTypesEvaluator.buildGenericParameters(parametersForOwner);
            JSType thisType = this.createTypeForThisExpression(JSContext.INSTANCE, jsClass, classNameSource);
            this.addType(new JSGenericTypeImpl(source, thisType, types));
            return;
        }
        super.processThisQualifierExpression(rawqualifier, jsClass, staticOrInstance);
    }

    @Override
    @NotNull
    protected JSType createTypeForThisExpression(@NotNull JSContext staticOrInstance, @NotNull JSClass jsClass, @NotNull JSTypeSource typeSource) {
        if (staticOrInstance == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(10);
        }
        if (jsClass == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(11);
        }
        if (typeSource == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(12);
        }
        if (!DialectDetector.isTypeScript(jsClass)) {
            JSType jSType = super.createTypeForThisExpression(staticOrInstance, jsClass, typeSource);
            if (jSType == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(13);
            }
            return jSType;
        }
        String name = jsClass.getQualifiedName();
        if (name == null) {
            JSTypeBaseImpl baseType = jsClass instanceof JSClassExpression ? new JSClassExpressionType((JSClassExpression)jsClass, JSTypeContext.fromJSContext(staticOrInstance)) : JSAnyType.get(typeSource);
            return new TypeScriptGenericThisTypeImpl(JSTypeSourceFactory.createTypeSource(jsClass, true), baseType);
        }
        JSType ownerType = JSNamedTypeFactory.createType(name, typeSource, staticOrInstance);
        if (staticOrInstance == JSContext.STATIC) {
            JSType jSType = ownerType;
            if (jSType == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(14);
            }
            return jSType;
        }
        return new TypeScriptGenericThisTypeImpl(typeSource, ownerType);
    }

    @Override
    public void addTypeFromExternalModuleReferenceResolveResult(@NotNull PsiElement moduleCandidate, boolean fromRequire) {
        TypeScriptExportAssignment exportAssignment;
        if (moduleCandidate == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(15);
        }
        if ((exportAssignment = TypeScriptPsiUtil.findExportAssignment(moduleCandidate)) != null) {
            this.evaluateExportAssignment(exportAssignment);
            return;
        }
        super.addTypeFromExternalModuleReferenceResolveResult(moduleCandidate, fromRequire);
    }

    @Override
    protected void evaluateExportAssignment(@NotNull JSExportAssignment assignment) {
        String reference;
        if (assignment == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(16);
        }
        if (assignment instanceof TypeScriptExportAssignment && (reference = assignment.getInitializerReference()) != null) {
            List<PsiElement> elements = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(reference, (PsiElement)assignment);
            for (PsiElement element : elements) {
                this.addTypeFromResolveResult(element);
            }
            if (!elements.isEmpty()) {
                return;
            }
        }
        super.evaluateExportAssignment(assignment);
    }

    @Override
    protected boolean evaluateDialectSpecificTypes(@NotNull JSExpression rawQualifier) {
        if (rawQualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(17);
        }
        if (rawQualifier instanceof TypeScriptCastExpression) {
            TypeScriptType typeScriptType = ((TypeScriptCastExpression)rawQualifier).getType();
            if (((TypeScriptCastExpression)rawQualifier).isConstCast()) {
                this.addType(this.getExpressionTypeInContext(((TypeScriptCastExpression)rawQualifier).getExpression()));
                return true;
            }
            if (typeScriptType != null) {
                JSType type = typeScriptType.getJSType();
                this.addType(type);
                return true;
            }
        } else {
            if (rawQualifier instanceof TypeScriptSatisfiesExpression) {
                JSExpression expression = ((TypeScriptSatisfiesExpression)rawQualifier).getExpression();
                this.addType(TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(this.getExpressionTypeInContext(expression), (PsiElement)expression));
                return true;
            }
            if (rawQualifier instanceof TypeScriptNotNullExpression) {
                JSExpression expression = ((TypeScriptNotNullExpression)rawQualifier).getExpression();
                JSType type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(this.getExpressionTypeInContext(expression), (PsiElement)expression);
                this.addType(JSTypeUtils.removeNullableComponents(type));
                return true;
            }
            if (rawQualifier instanceof TypeScriptExpressionWithTypeArguments) {
                JSType type = TypeScriptExpressionWithTypeArgumentsTypeEvaluator.INSTANCE.evaluate((TypeScriptExpressionWithTypeArguments)rawQualifier);
                this.addType(type);
                return true;
            }
        }
        return super.evaluateDialectSpecificTypes(rawQualifier);
    }

    @Override
    protected void addTypeFromClassWithQName(@NotNull JSClass resolveResult) {
        if (resolveResult == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(18);
        }
        if (!DialectDetector.isTypeScript(resolveResult)) {
            super.addTypeFromClassWithQName(resolveResult);
            return;
        }
        this.addType(resolveResult.getStaticJSType());
    }

    @Override
    @NotNull
    public List<JSType> getComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        JSType argumentType;
        JSType typeFromIndexSignature;
        JSRecordType.PropertySignature member;
        String value;
        if (type instanceof JSArrayType || type == null || type instanceof JSUnionType && !JSTypeCastUtil.isStrictTypeScriptUnionType((JSUnionType)type)) {
            List<JSType> list = super.getComponentTypeFromProcessor(rawqualifier, type);
            if (list == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(19);
            }
            return list;
        }
        if (!(rawqualifier instanceof JSIndexedPropertyAccessExpression)) {
            List<JSType> candidates = this.getComponentTypeWithExpandingComposite(rawqualifier, type);
            if (!candidates.isEmpty()) {
                List<JSType> list = candidates;
                if (list == null) {
                    TypeScriptTypeEvaluator.$$$reportNull$$$0(20);
                }
                return list;
            }
            List<JSType> list = Collections.singletonList(new JSIterableComponentTypeImpl(type, type.getSource()));
            if (list == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(21);
            }
            return list;
        }
        JSRecordType recordType = type.asRecordType();
        if (!recordType.hasMembers()) {
            List<JSType> list = super.getComponentTypeFromProcessor(rawqualifier, type);
            if (list == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(22);
            }
            return list;
        }
        JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)rawqualifier).getIndexExpression();
        Object propertyName = null;
        if (indexExpression instanceof JSLiteralExpression && (value = ((JSLiteralExpression)indexExpression).getStringValue()) != null) {
            propertyName = value;
        }
        if (JSPsiImplUtils.isSymbolRef(indexExpression)) {
            propertyName = "[" + indexExpression.getText() + "]";
        }
        if (propertyName != null && (member = recordType.findPropertySignature((String)propertyName)) != null) {
            List<JSType> list = Collections.singletonList(member.getJSType());
            if (list == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(23);
            }
            return list;
        }
        if (recordType.hasIndexers() && (typeFromIndexSignature = JSApplyIndexedAccessType.getComponentTypeFromIndexSignature(recordType, argumentType = indexExpression != null ? this.getExpressionTypeInContext(indexExpression) : null)) != null) {
            List<JSType> list = Collections.singletonList(typeFromIndexSignature);
            if (list == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(24);
            }
            return list;
        }
        List<JSType> list = Collections.emptyList();
        if (list == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(25);
        }
        return list;
    }

    @Override
    @Nullable
    protected JSType getIndexedPropertyAccessType(@NotNull JSIndexedPropertyAccessExpression rawqualifier) {
        JSType type;
        List<JSType> results;
        if (rawqualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(26);
        }
        if (!DialectDetector.isTypeScript((PsiElement)rawqualifier)) {
            return super.getIndexedPropertyAccessType(rawqualifier);
        }
        JSExpression qualifier = rawqualifier.getQualifier();
        JSType qualifierTypeType = this.getExpressionTypeInContext(qualifier);
        JSExpression indexExpression = rawqualifier.getIndexExpression();
        JSType indexExpressionType = this.getExpressionTypeInContext(indexExpression);
        if (qualifierTypeType == null || indexExpressionType == null || JSPsiImplUtils.isSymbolRef(indexExpression)) {
            return super.getIndexedPropertyAccessType(rawqualifier);
        }
        if (indexExpressionType instanceof JSNumberType && (results = this.getComponentTypeFromArrayExpression(rawqualifier, rawqualifier.getQualifier())).size() == 1 && (type = results.get(0)).isSourceStrict()) {
            return type;
        }
        return JSCompositeTypeFactory.createIndexedAccessType(qualifierTypeType, indexExpressionType, JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true));
    }

    @Override
    @NotNull
    protected JSType getArrayTypeFromExpressions(@NotNull JSArrayLiteralExpression rawQualifier, @NotNull Stream<JSExpression> expressions) {
        DialectOptionHolder holder;
        if (rawQualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(27);
        }
        if (expressions == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(28);
        }
        AtomicInteger typesToEvaluateLimit = (holder = DialectDetector.dialectOfElement((PsiElement)rawQualifier)) != null && holder.isJavaScript() ? new AtomicInteger(5) : null;
        List types = expressions.map(expression -> TypeScriptTypeEvaluator.getTypeOrSpread(expression, this.getExpressionTypeForArrayLiteral(rawQualifier, (JSExpression)expression, typesToEvaluateLimit))).collect(Collectors.toList());
        JSType type = JSCompositeTypeFactory.createTupleType(JSTypeSourceFactory.createTypeSource((PsiElement)rawQualifier, true), types, false, -1, false);
        if (JSDestructuringUtil.arrayLiteralCorrespondsToDestructuringArray(rawQualifier)) {
            JSType jSType = type;
            if (jSType == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(29);
            }
            return jSType;
        }
        if (this.isContextualOverloadEvaluation()) {
            JSType jSType = type;
            if (jSType == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(30);
            }
            return jSType;
        }
        return TypeScriptTypeEvaluator.createWidening(type, (PsiElement)rawQualifier, this.myContext.isAstAccessAllowed((PsiElement)rawQualifier));
    }

    @NotNull
    public static JSType createWidening(@NotNull JSType type, @NotNull PsiElement contextOwner, boolean isAstAccessAllowed) {
        if (type == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(31);
        }
        if (contextOwner == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(32);
        }
        JSType jSType = DialectDetector.isTypeScript(contextOwner) || isAstAccessAllowed ? JSWidenType.createWidening(type, contextOwner) : type;
        if (jSType == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(33);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSType getExpressionTypeForArrayLiteral(@Nullable JSExpression arrayLiteralExpression, @Nullable JSExpression expression, @Nullable AtomicInteger typesToEvaluateLimit) {
        JSType expressionType = super.getExpressionTypeForArrayLiteral(arrayLiteralExpression, expression, typesToEvaluateLimit);
        if (expressionType == null) {
            expressionType = this.createNullType(arrayLiteralExpression);
        }
        JSType jSType = expressionType;
        if (jSType == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(34);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSType getObjectLiteralType(JSObjectLiteralExpression expression, boolean evaluatePropertyTypes) {
        JSType type = super.getObjectLiteralType(expression, evaluatePropertyTypes);
        if (!this.myContext.isContextualOverloadEvaluation() && this.myContext.isAstAccessAllowed((PsiElement)expression) && JSWidenType.canBeInGenericConstContext(expression)) {
            return TypeScriptTypeEvaluator.createWidening(type, (PsiElement)expression, true);
        }
        JSType jSType = type;
        if (jSType == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(35);
        }
        return jSType;
    }

    @Override
    protected boolean addTypeFromAmdModuleReference(@NotNull JSParameter parameter) {
        if (parameter == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(36);
        }
        return !DialectDetector.isTypeScript((PsiElement)parameter) && super.addTypeFromAmdModuleReference(parameter);
    }

    @Override
    protected void processThisQualifierInExecutionScope(@NotNull JSThisExpression thisQualifier, PsiElement thisScope) {
        if (thisQualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(37);
        }
        if (thisScope instanceof TypeScriptFunction) {
            JSType type;
            PsiElement context = thisScope;
            if (thisScope instanceof JSFunctionExpression) {
                context = JSContextResolver.findContextElement((PsiElement)thisQualifier);
            }
            if (context instanceof TypeScriptFunction && (type = this.computeThisType((TypeScriptFunction)context)) != null) {
                this.addType(type);
                return;
            }
        }
        super.processThisQualifierInExecutionScope(thisQualifier, thisScope);
    }

    @Nullable
    public JSType computeThisType(@NotNull TypeScriptFunction function) {
        JSType thisType;
        JSType contextualType;
        JSType explicitThisType;
        if (function == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(38);
        }
        if ((explicitThisType = function.getExplicitThisType()) != null) {
            return explicitThisType;
        }
        if (function instanceof JSExpression && (contextualType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((Object)function), JSExpectedTypeKind.CONTEXTUAL)) instanceof JSFunctionTypeImpl && (thisType = ((JSFunctionTypeImpl)contextualType).getThisType()) != null) {
            return thisType;
        }
        TypeScriptConfig config = TypeScriptConfigUtil.getConfigForPsiFile(function.getContainingFile());
        if (config == null || !config.noImplicitThis()) {
            return null;
        }
        PsiElement context = function.getContext();
        JSAssignmentExpression parentAssignment = (JSAssignmentExpression)ObjectUtils.tryCast((Object)context, JSAssignmentExpression.class);
        if (parentAssignment != null) {
            return this.computeThisTypeFromAssignment(parentAssignment);
        }
        JSObjectLiteralExpression parentLiteral = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)context, JSObjectLiteralExpression.class);
        if (parentLiteral != null) {
            return TypeScriptTypeEvaluator.computeThisTypeFromLiteral(parentLiteral);
        }
        return null;
    }

    @Nullable
    private JSType computeThisTypeFromAssignment(@NotNull JSAssignmentExpression assignment) {
        JSExpression qualifier;
        JSDefinitionExpression definitionExpression;
        if (assignment == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(39);
        }
        if ((definitionExpression = assignment.getDefinitionExpression()) == null) {
            return null;
        }
        JSExpression expression = definitionExpression.getExpression();
        JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)expression, JSReferenceExpression.class);
        JSIndexedPropertyAccessExpression indexer = (JSIndexedPropertyAccessExpression)ObjectUtils.tryCast((Object)expression, JSIndexedPropertyAccessExpression.class);
        JSExpression jSExpression = referenceExpression != null ? referenceExpression.getQualifier() : (qualifier = indexer != null ? indexer.getQualifier() : null);
        if (qualifier == null) {
            return null;
        }
        return this.getExpressionTypeInContext(qualifier);
    }

    @Nullable
    private static JSType computeThisTypeFromLiteral(@NotNull JSObjectLiteralExpression parentLiteral) {
        JSType contextualType;
        if (parentLiteral == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(40);
        }
        return (contextualType = JSDialectSpecificHandlersFactory.findExpectedType(parentLiteral, JSExpectedTypeKind.CONTEXTUAL_FOR_THIS_IN_LITERAL)) == null ? TypeScriptTypeEvaluator.createTypeOfLiteralType(parentLiteral) : TypeScriptTypeEvaluator.extractThisType(contextualType);
    }

    @Nullable
    private static JSType extractThisType(@Nullable JSType contextualType) {
        Ref thisTypeRef = Ref.create();
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
            JSType thisType = TypeScriptTypeEvaluator.doExtractThisType(t);
            if (thisType != null) {
                thisTypeRef.set((Object)thisType);
                return false;
            }
            return true;
        }), contextualType, false, true, true);
        return thisTypeRef.isNull() ? contextualType : (JSType)thisTypeRef.get();
    }

    @Nullable
    private static JSType doExtractThisType(@Nullable JSType type) {
        JSType expanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type, null);
        JSType thisType = TypeScriptTypeEvaluator.getTypeFromThisType(expanded);
        if (thisType != null) {
            return thisType;
        }
        if (expanded instanceof JSIntersectionType) {
            for (JSType jsType : ((JSIntersectionType)expanded).getTypes()) {
                thisType = TypeScriptTypeEvaluator.getTypeFromThisType(jsType);
                if (thisType == null) continue;
                return thisType;
            }
        }
        return null;
    }

    @Nullable
    private static JSType getTypeFromThisType(JSType expanded) {
        JSGenericTypeImpl genericType = (JSGenericTypeImpl)ObjectUtils.tryCast((Object)expanded, JSGenericTypeImpl.class);
        if (genericType == null) {
            return null;
        }
        JSNamedType namedType = (JSNamedType)ObjectUtils.tryCast((Object)genericType.getType(), JSNamedType.class);
        if (namedType == null || !THIS_TYPE_NAME.equals(namedType.getQualifiedName().getQualifiedName())) {
            return null;
        }
        List<JSType> arguments = genericType.getArguments();
        if (arguments.size() != 1) {
            return null;
        }
        return arguments.get(0);
    }

    @NotNull
    private static JSCodeBasedType createTypeOfLiteralType(@NotNull JSObjectLiteralExpression parentLiteral) {
        if (parentLiteral == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(41);
        }
        return new JSTypeofTypeImpl(parentLiteral, JSTypeSourceFactory.createTypeSource((PsiElement)parentLiteral, DialectDetector.isTypeScript((PsiElement)parentLiteral)));
    }

    @Override
    protected void processSuperQualifierExpression(JSSuperExpression rawqualifier, @Nullable JSClass jsClass) {
        if (jsClass != null && !jsClass.isInterface()) {
            JSReferenceListMember member;
            JSReferenceList extendsList = jsClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            Object[] members = extendsList.getMembers();
            if (members.length == 1 && (member = (JSReferenceListMember)ArrayUtil.getFirstElement((Object[])members)) != null) {
                Collection<JSClass> jsClasses = member.getClasses();
                if (jsClasses.isEmpty()) {
                    super.processSuperQualifierExpression(rawqualifier, jsClass);
                    return;
                }
                JSTypeDeclaration[] arguments = member.getTypeArguments();
                if (arguments.length > 0) {
                    List<JSType> types = JSClassUtils.buildTypeArguments(member);
                    for (JSClass aClass : jsClasses) {
                        JSType type = aClass.getStaticJSType();
                        this.addType(new JSGenericTypeImpl(type.getSource(), type, types));
                    }
                    return;
                }
            }
        }
        super.processSuperQualifierExpression(rawqualifier, jsClass);
    }

    @Override
    protected JSType substituteThisType(@Nullable JSType type, @Nullable JSFieldVariable jsVariable) {
        if (!JSTypeUtils.hasTypes(type, TypeScriptGenericThisTypeImpl.class)) {
            return type;
        }
        JSClass context = JSResolveUtil.getClassOfContext((PsiElement)jsVariable);
        if (context == null) {
            return type;
        }
        JSType parentType = TypeScriptTypeEvaluator.createTypeForThisTypeSubstitution(context, type.getSource());
        if (parentType == null) {
            return type;
        }
        return type.transformTypeHierarchy(new JSCacheableTypeTransformer((Function<? super JSType, ? extends JSType>)((Function)jsType -> {
            if (jsType instanceof TypeScriptGenericThisTypeImpl) {
                JSType owner = ((TypeScriptGenericThisTypeImpl)jsType).getOwnerType();
                JSTypeSource currentSource = jsType.getSource();
                if (!(currentSource.getSourceElement() == context || owner != null && owner.isEquivalentTo(parentType, null))) {
                    JSTypeSource newSource = JSTypeSourceFactory.copyTypeSource(currentSource, context);
                    return new TypeScriptGenericThisTypeImpl(newSource, parentType);
                }
            }
            return jsType;
        })));
    }

    @Nullable
    public static JSType createTypeForThisTypeSubstitution(JSClass context, JSTypeSource source) {
        String name = context.getQualifiedName();
        return name == null ? null : JSNamedTypeFactory.createType(name, source, JSContext.INSTANCE);
    }

    @Override
    protected JSType evaluateTypeFromInlineComment(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(42);
        }
        if (DialectDetector.isTypeScript((PsiElement)rawqualifier)) {
            return null;
        }
        return super.evaluateTypeFromInlineComment(rawqualifier);
    }

    @Override
    protected void addTypeFromLiteralExpression(@NotNull JSExpression rawQualifier) {
        JSStringTemplateExpression expression;
        JSExpression[] arguments;
        if (rawQualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(43);
        }
        if (rawQualifier instanceof JSStringTemplateExpression && (JSWidenType.isConstContext((PsiElement)rawQualifier) || TypeScriptTypeEvaluator.isTemplateLiteralContext((PsiElement)rawQualifier) || this.isTemplateLiteralContextualType(rawQualifier)) && (arguments = ((JSStringTemplateExpression)rawQualifier).getArguments()).length > 0) {
            ProcessingContext context = JSTypeComparingContextService.createProcessingContextWithCache((PsiElement)rawQualifier);
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rawQualifier, true);
            JSType constraintType = TypeScriptTypeRelations.createTemplateLiteralConstraintType(source);
            ArrayList<String> texts = new ArrayList<String>();
            ArrayList<JSType> types = new ArrayList<JSType>();
            String text = rawQualifier.getText();
            TextRange[] ranges = ((JSStringTemplateExpression)rawQualifier).getStringRangesWithEmpty();
            for (int i = 0; i < ranges.length; ++i) {
                TextRange range = ranges[i];
                texts.add(range.substring(text));
                if (i == ranges.length - 1) continue;
                JSExpression expression2 = i < arguments.length ? arguments[i] : null;
                JSType expressionType = JSResolveUtil.getExpressionJSType(expression2, false);
                types.add(expressionType != null && constraintType.isDirectlyAssignableType(expressionType, context) ? expressionType : JSNamedTypeFactory.createStringPrimitiveType(source));
            }
            this.doAddType(TypeScriptTemplateLiteralJSTypeImpl.createType(texts, types, false, source));
            return;
        }
        if (rawQualifier instanceof JSStringTemplateExpression && JSWidenType.canBeInGenericConstContext(expression = (JSStringTemplateExpression)rawQualifier) && !JSWidenType.isConstContextByGenericParamConstModifier(expression)) {
            JSType stringType = TypeScriptTypeEvaluator.createStringType(expression, JSTypeSourceFactory.createTypeSource((PsiElement)expression, true));
            this.addType(stringType);
            return;
        }
        super.addTypeFromLiteralExpression(rawQualifier);
    }

    private static boolean isTemplateLiteralContext(@Nullable PsiElement element) {
        if (!(element instanceof JSElement)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSParenthesizedExpression) {
            return TypeScriptTypeEvaluator.isTemplateLiteralContext(parent);
        }
        if (parent instanceof JSIndexedPropertyAccessExpression) {
            return ((JSIndexedPropertyAccessExpression)parent).getIndexExpression() == element;
        }
        return false;
    }

    private boolean isTemplateLiteralContextualType(@NotNull JSExpression expression) {
        if (expression == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(44);
        }
        if (this.getEvaluateContext().isContextualOverloadEvaluation()) {
            return false;
        }
        JSType contextualType = JSDialectSpecificHandlersFactory.findExpectedType(expression, JSExpectedTypeKind.CONTEXTUAL);
        if (contextualType == null) {
            return false;
        }
        return TypeScriptTypeRelations.someType(contextualType, type -> {
            if (type instanceof JSStringType || type instanceof JSTemplateLiteralType) {
                return true;
            }
            if (TypeScriptTypeRelations.isInstantiableNonPrimitive(type)) {
                JSType constraint = TypeScriptTypeRelations.getBaseConstraintOfType(type, type.getSourceElement());
                return constraint != null && TypeScriptTypeRelations.maybeTypeOfKind(constraint, TypeScriptTypeRelations::isStringLike);
            }
            return false;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 19, 20, 21, 22, 23, 24, 25, 29, 30, 33, 34, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 2: 
            case 7: 
            case 26: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawqualifier";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleCandidate";
                break;
            }
            case 16: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 17: 
            case 27: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawQualifier";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextOwner";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisQualifier";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLiteral";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeForThisExpression";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeFromProcessor";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayTypeFromExpressions";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createWidening";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionTypeForArrayLiteral";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectLiteralType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "evaluatePlusType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "evaluateAndOrOrType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAndOrOrOrQuestType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromLocalModule";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierExpression";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTypeForThisExpression";
                break;
            }
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromExternalModuleReferenceResolveResult";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExportAssignment";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "evaluateDialectSpecificTypes";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromClassWithQName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedPropertyAccessType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getArrayTypeFromExpressions";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createWidening";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromAmdModuleReference";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierInExecutionScope";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "computeThisType";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "computeThisTypeFromAssignment";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "computeThisTypeFromLiteral";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createTypeOfLiteralType";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTypeFromInlineComment";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromLiteralExpression";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateLiteralContextualType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14, 19, 20, 21, 22, 23, 24, 25, 29, 30, 33, 34, 35 -> new IllegalStateException(string);
        };
    }
}

