/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.gcl;

import com.intellij.lang.javascript.StubIndexSupport;
import com.intellij.lang.javascript.index.JSIndexKeys;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.impl.JSReferenceSetElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSGclModuleReference
extends JSReferenceSetElement {
    public static final String GCL_MODULE_USER_STRING = "gcl";

    public JSGclModuleReference(JSReferenceSet set, String s, int offset) {
        super(set, s, new TextRange(offset, offset + s.length()));
    }

    @Override
    protected ResolveResult @NotNull [] doResolve() {
        String moduleName = this.getQualifiedName().getQualifiedName();
        GlobalSearchScope scope = this.getElement().getResolveScope();
        SmartList results = new SmartList();
        StubIndexSupport.getInstance().processElements(JSIndexKeys.JS_GCL_MODULES_INDEX_KEY, moduleName, this.getElement().getProject(), scope, JSLiteralExpression.class, arg_0 -> JSGclModuleReference.lambda$doResolve$0(moduleName, (List)results, arg_0));
        ResolveResult[] resolveResultArray = results.isEmpty() ? super.doResolve() : results.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            JSGclModuleReference.$$$reportNull$$$0(0);
        }
        return resolveResultArray;
    }

    public static boolean isGoogRequireCall(@Nullable JSExpression methodExpression) {
        return JSSymbolUtil.isAccurateReferenceExpressionName(methodExpression, "goog", "require") || JSSymbolUtil.isAccurateReferenceExpressionName(methodExpression, "goog", "module", "get");
    }

    @Nullable
    public static JSGclModuleReference getGclModuleReference(@NotNull JSCallExpression callExpression) {
        JSExpression[] arguments;
        if (callExpression == null) {
            JSGclModuleReference.$$$reportNull$$$0(1);
        }
        if ((arguments = callExpression.getArguments()).length > 0 && arguments[0] instanceof JSLiteralExpression) {
            for (PsiReference reference : arguments[0].getReferences()) {
                if (!(reference instanceof JSGclModuleReference)) continue;
                return (JSGclModuleReference)reference;
            }
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$doResolve$0(String moduleName, List results, JSLiteralExpression element) {
        ProgressManager.checkCanceled();
        JSElementIndexingData data = element.getIndexingData();
        List elements = data != null ? data.findElementsByQualifiedName(moduleName) : Collections.emptyList();
        Object resultElement = (PsiElement)ContainerUtil.getFirstItem(elements);
        if (resultElement == null) {
            resultElement = element;
        }
        results.add(new JSResolveResult((PsiElement)resultElement));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/gcl/JSGclModuleReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/gcl/JSGclModuleReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getGclModuleReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

