/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.StubIndexSupport;
import com.intellij.lang.javascript.flex.ActionScriptPsiExtensions;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.index.JSIndexKeys;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationLogger;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSClassResolver {
    private static JSClassResolver INSTANCE = null;
    private static final Logger LOG = Logger.getInstance(JSClassResolver.class);

    protected JSClassResolver() {
    }

    public static JSClassResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JSClassResolver();
        }
        return INSTANCE;
    }

    public static PsiElement findClassFromNamespace(@NotNull String qname, @NotNull PsiElement context) {
        if (qname == null) {
            JSClassResolver.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSClassResolver.$$$reportNull$$$0(1);
        }
        return ActionScriptPsiExtensions.getInstance().findClassFromNamespace(qname, context);
    }

    public static long getResolveResultTimestamp(PsiElement candidate) {
        for (JSResolveHelper helper : JSResolveHelper.EP_NAME.getExtensionList()) {
            long result = helper.getResolveResultTimestamp(candidate);
            if (result == -1L) continue;
            return result;
        }
        return -1L;
    }

    public PsiElement findClassByQName(@NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            JSClassResolver.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JSClassResolver.$$$reportNull$$$0(3);
        }
        return this.doFindClassByQName(link, JSResolveUtil.getResolveScope(context), false);
    }

    @Nullable
    public PsiElement findClassByQName(@NotNull String link, @NotNull GlobalSearchScope scope) {
        if (link == null) {
            JSClassResolver.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(5);
        }
        return TypeScriptClassResolver.getInstance().findAnyClassByQName(link, scope);
    }

    protected PsiElement doFindClassByQName(@NotNull String link, GlobalSearchScope searchScope, boolean allowFileLocalSymbols) {
        Project project;
        if (link == null) {
            JSClassResolver.$$$reportNull$$$0(6);
        }
        if ((project = searchScope.getProject()) == null) {
            throw new IllegalArgumentException("searchScope.getProject() is null");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("doFindClassByQName: " + link);
        }
        Collection<JSQualifiedNamedElement> candidates = StubIndexSupport.getInstance().getElements(JSIndexKeys.JS_QUALIFIED_ELEMENT_INDEX_KEY, link, project, searchScope, JSQualifiedNamedElement.class);
        for (JSQualifiedNamedElement clazz : candidates) {
            PsiFile file;
            if (!link.equals(clazz.getQualifiedName()) || (file = clazz.getContainingFile()).getLanguage().isKindOf((Language)FlexSupportLoader.ECMA_SCRIPT_L4)) continue;
            return clazz;
        }
        return null;
    }

    @NotNull
    public List<JSClass> findClassesByQName(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        Project project;
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(8);
        }
        if ((project = scope.getProject()) == null) {
            if (scope != GlobalSearchScope.EMPTY_SCOPE) {
                Logger.getInstance(JSClassResolver.class).error("Incorrect scope: " + String.valueOf(scope));
            }
            List<JSClass> list = Collections.emptyList();
            if (list == null) {
                JSClassResolver.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("findClassesByQName: " + qName);
        }
        Collection<JSQualifiedNamedElement> candidates = StubIndexSupport.getInstance().getElements(JSIndexKeys.JS_QUALIFIED_ELEMENT_INDEX_KEY, qName, project, scope, JSQualifiedNamedElement.class);
        SmartList classes = new SmartList();
        for (JSQualifiedNamedElement _clazz : candidates) {
            JSClass clazz;
            if (!(_clazz instanceof JSClass) || !qName.equals((clazz = (JSClass)_clazz).getQualifiedName())) continue;
            classes.add((Object)clazz);
        }
        SmartList smartList = classes;
        if (smartList == null) {
            JSClassResolver.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    @NotNull
    public Collection<JSQualifiedNamedElement> findElementsByQName(@NotNull String qName, @NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(12);
        }
        if (project == null) {
            JSClassResolver.$$$reportNull$$$0(13);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("findElementsByQName: " + qName);
        }
        SmartList result = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)result);
        scope = this.adjustScopeForQualifiedNameSearch(scope);
        StubIndexSupport.getInstance().processElements(JSIndexKeys.JS_QUALIFIED_ELEMENT_INDEX_KEY, qName, project, scope, JSQualifiedNamedElement.class, processor);
        Collections.sort(result, JSResolveUtil.FILE_PATH_COMPARATOR);
        SmartList smartList = result;
        if (smartList == null) {
            JSClassResolver.$$$reportNull$$$0(14);
        }
        return smartList;
    }

    @NotNull
    protected GlobalSearchScope adjustScopeForQualifiedNameSearch(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(15);
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            JSClassResolver.$$$reportNull$$$0(16);
        }
        return globalSearchScope;
    }

    @NotNull
    public Collection<JSPsiElementBase> findNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(17);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(18);
        }
        Collection<JSPsiElementBase> collection = this.findNamespaceMembers(namespace, scope, null);
        if (collection == null) {
            JSClassResolver.$$$reportNull$$$0(19);
        }
        return collection;
    }

    public boolean processNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(20);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(21);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(22);
        }
        return JSClassResolver.processNamespaceMembers(namespace, scope, null, processor);
    }

    @NotNull
    public Collection<JSPsiElementBase> findNamespaceMembersIncludingLocal(@NotNull String namespace, @NotNull GlobalSearchScope scope) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(23);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(24);
        }
        SmartList result = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)result);
        JSClassResolver.processNamespaceMembers(namespace, scope, scope, (Processor<? super JSPsiElementBase>)processor);
        SmartList smartList = result;
        if (smartList == null) {
            JSClassResolver.$$$reportNull$$$0(25);
        }
        return smartList;
    }

    @NotNull
    public Collection<JSPsiElementBase> findNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope, @Nullable GlobalSearchScope scopeToIncludeLocal) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(26);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(27);
        }
        SmartList result = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)result);
        JSClassResolver.processNamespaceMembers(namespace, scope, scopeToIncludeLocal, (Processor<? super JSPsiElementBase>)processor);
        SmartList smartList = result;
        if (smartList == null) {
            JSClassResolver.$$$reportNull$$$0(28);
        }
        return smartList;
    }

    public boolean processNamespaceMembers(@NotNull String namespace, @NotNull PsiFile scope, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(29);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(30);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(31);
        }
        GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)scope);
        return JSClassResolver.processNamespaceMembers(namespace, fileScope, fileScope, processor);
    }

    public boolean processNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope, @Nullable PsiFile fileToIncludeLocal, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(32);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(33);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(34);
        }
        GlobalSearchScope localNsScope = fileToIncludeLocal != null ? GlobalSearchScope.fileScope((PsiFile)fileToIncludeLocal) : null;
        return JSClassResolver.processNamespaceMembers(namespace, scope, localNsScope, processor);
    }

    @NotNull
    public Collection<JSPsiElementBase> findNamespaceMembers(@NotNull JSNamespace namespace, @NotNull GlobalSearchScope scope, @Nullable GlobalSearchScope scopeToIncludeLocal) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(35);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(36);
        }
        String key = (String)ObjectUtils.chooseNotNull((Object)JSQualifiedNameImpl.getNamespaceForIndexing(namespace, true), (Object)"");
        SmartList result = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)result);
        JSClassResolver.processNamespaceMembers(namespace, key, scope, scopeToIncludeLocal, (Processor<? super JSPsiElementBase>)processor);
        SmartList smartList = result;
        if (smartList == null) {
            JSClassResolver.$$$reportNull$$$0(37);
        }
        return smartList;
    }

    public static boolean processNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope globalNsScope, @Nullable GlobalSearchScope localNsScope, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(38);
        }
        if (globalNsScope == null) {
            JSClassResolver.$$$reportNull$$$0(39);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(40);
        }
        JSNamespace jsNamespace = "".equals(namespace) ? null : (JSNamespace)ObjectUtils.tryCast((Object)JSTypeParser.createType(namespace, JSTypeSource.EXPLICITLY_DECLARED), JSNamespace.class);
        return JSClassResolver.processNamespaceMembers(jsNamespace, namespace, globalNsScope, localNsScope, processor);
    }

    private static boolean processNamespaceMembers(@Nullable JSNamespace jsNamespace, @NotNull String namespace, @NotNull GlobalSearchScope globalNsScope, @Nullable GlobalSearchScope localNsScope, @NotNull Processor<? super JSPsiElementBase> processor) {
        Project project;
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(41);
        }
        if (globalNsScope == null) {
            JSClassResolver.$$$reportNull$$$0(42);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(43);
        }
        if ((project = globalNsScope.getProject()) == null) {
            return true;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("processNamespaceMembers: " + namespace);
        }
        Processor<JSElement> namespaceMembersProcessor = JSClassResolver.getNamespaceMembersProcessor(processor, jsNamespace);
        if (localNsScope != null && !StubIndexSupport.getInstance().processElements(JSIndexKeys.JS_LOCAL_NAMESPACE_MEMBERS_INDEX_KEY, namespace, project, localNsScope, JSElement.class, namespaceMembersProcessor)) {
            return false;
        }
        return StubIndexSupport.getInstance().processElements(JSIndexKeys.JS_NAMESPACE_MEMBERS_INDEX_KEY, namespace, project, globalNsScope, JSElement.class, namespaceMembersProcessor);
    }

    @NotNull
    private static Processor<JSElement> getNamespaceMembersProcessor(@NotNull Processor<? super JSPsiElementBase> processor, @Nullable JSNamespace namespace) {
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(44);
        }
        Processor processor2 = element -> {
            Collection<JSImplicitElement> implicitElements;
            JSElementIndexingData data;
            boolean emptyImplicitElements = true;
            if (element instanceof JSImplicitElementProvider && (data = ((JSImplicitElementProvider)element).getIndexingData()) != null && (implicitElements = data.getImplicitElements()) != null) {
                emptyImplicitElements = false;
                for (JSImplicitElement implicitElement : implicitElements) {
                    if (!(namespace == null ? implicitElement.getNamespace() == null : BaseJSSymbolProcessor.isElementFromNamespaceIgnoringJSContext(namespace, implicitElement, implicitElement.getNamespace(), implicitElement.getJSNamespace())) || processor.process((Object)implicitElement)) continue;
                    return false;
                }
            }
            return !(element instanceof JSPsiElementBase) || !emptyImplicitElements && !ComparatorUtil.equalsNullable((Object)namespace, (Object)((JSPsiElementBase)element).getJSNamespace()) || processor.process((Object)((JSPsiElementBase)element));
        };
        if (processor2 == null) {
            JSClassResolver.$$$reportNull$$$0(45);
        }
        return processor2;
    }

    @NotNull
    public Collection<JSPsiElementBase> findElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(46);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(47);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processElementsByQNameIncludingImplicit(qName, scope, (Processor<? super JSPsiElementBase>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            JSClassResolver.$$$reportNull$$$0(48);
        }
        return collection;
    }

    @NotNull
    public List<JSPsiElementBase> findElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull PsiFile scope) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(49);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(50);
        }
        ArrayList<JSPsiElementBase> result = new ArrayList<JSPsiElementBase>();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(result);
        this.processElementsByQNameIncludingImplicit(qName, GlobalSearchScope.fileScope((PsiFile)scope), IncludeLocalMembersOptions.ALL, (Processor<? super JSPsiElementBase>)processor);
        ArrayList<JSPsiElementBase> arrayList = result;
        if (arrayList == null) {
            JSClassResolver.$$$reportNull$$$0(51);
        }
        return arrayList;
    }

    public void processElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull GlobalSearchScope scope, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(52);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(53);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(54);
        }
        this.processElementsByQNameIncludingImplicit(qName, scope, IncludeLocalMembersOptions.NONE, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull GlobalSearchScope scope, @NotNull IncludeLocalMembersOptions includeLocalMembers, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(55);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(56);
        }
        if (includeLocalMembers == null) {
            JSClassResolver.$$$reportNull$$$0(57);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(58);
        }
        Project project = scope.getProject();
        assert (project != null);
        JSEvaluationLogger.getInstance().startTask(() -> "processElementsByQNameIncludingImplicit: " + qName);
        try {
            GlobalSearchScope scopeForSymbolQualifiedNamesIndex;
            Processor<JSElement> processorForQNameIncludingImplicit = JSClassResolver.getProcessorForQNameIncludingImplicit(qName, includeLocalMembers, processor);
            GlobalSearchScope scopeForGlobalSymbolIndex = includeLocalMembers.getScopeForGlobalSymbolIndex(qName, scope);
            if (scopeForGlobalSymbolIndex != null) {
                StubIndexSupport.getInstance().processElements(JSIndexKeys.JS_GLOBAL_SYMBOL_INDEX_KEY, qName, project, scopeForGlobalSymbolIndex, JSElement.class, processorForQNameIncludingImplicit);
            }
            if ((scopeForSymbolQualifiedNamesIndex = includeLocalMembers.getScopeForSymbolQualifiedNamesIndex(qName, scope)) != null) {
                StubIndexSupport.getInstance().processElements(JSIndexKeys.JS_SYMBOL_QUALIFIED_NAMES_INDEX_KEY, qName, project, scopeForSymbolQualifiedNamesIndex, JSElement.class, processorForQNameIncludingImplicit);
            }
        }
        finally {
            JSEvaluationLogger.getInstance().finishTask(null);
        }
    }

    @NotNull
    private static Processor<JSElement> getProcessorForQNameIncludingImplicit(@NotNull String qName, @NotNull IncludeLocalMembersOptions includeLocalMembers, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(59);
        }
        if (includeLocalMembers == null) {
            JSClassResolver.$$$reportNull$$$0(60);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(61);
        }
        Processor processor2 = element -> {
            if (element instanceof JSPsiElementBase) {
                PsiFile file = element.getContainingFile();
                String processedElementQName = includeLocalMembers.myIncludeLocalAll || file != null && file.equals((Object)includeLocalMembers.myIncludeLocalInFile) ? JSIndexBasedResolveUtil.getQualifiedNameToIndex((JSElementBase)((Object)element)) : ((JSPsiElementBase)element).getQualifiedName();
                if (qName.equals(processedElementQName) && !processor.process((Object)((JSPsiElementBase)element))) {
                    return false;
                }
            }
            if (element instanceof JSImplicitElementProvider) {
                Collection<JSImplicitElement> implicitElements;
                JSElementIndexingData indexingData = ((JSImplicitElementProvider)element).getIndexingData();
                List<JSImplicitElement> elements = indexingData != null ? indexingData.findElementsByQualifiedName(qName) : Collections.emptyList();
                for (JSImplicitElement implicitElement : elements) {
                    if (processor.process((Object)implicitElement)) continue;
                    return false;
                }
                if (elements.isEmpty() && indexingData != null && (implicitElements = indexingData.getImplicitElements()) != null) {
                    for (JSImplicitElement implicitElement : implicitElements) {
                        String elementName = implicitElement.getName();
                        if (elementName == null || !qName.equals(JSIndexBasedResolveUtil.getQualifiedNameToIndex(implicitElement)) || processor.process((Object)implicitElement)) continue;
                        return false;
                    }
                }
            }
            return true;
        };
        if (processor2 == null) {
            JSClassResolver.$$$reportNull$$$0(62);
        }
        return processor2;
    }

    @NotNull
    public Collection<JSPsiElementBase> findElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(63);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(64);
        }
        return JSClassResolver.findElementsByNameIncludingImplicit(name, scope, false);
    }

    @NotNull
    public static Collection<JSPsiElementBase> findElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope, boolean justClasses) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(65);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(66);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        JSClassResolver.processElementsByNameIncludingImplicit(name, scope, justClasses, (Processor<? super JSPsiElementBase>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            JSClassResolver.$$$reportNull$$$0(67);
        }
        return collection;
    }

    public static boolean processElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope, boolean justClasses, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(68);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(69);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(70);
        }
        return JSClassResolver.processElementsByNameIncludingImplicit(name, scope, justClasses, JSIndexKeys.JS_SYMBOL_INDEX_2_KEY, processor);
    }

    public static boolean processElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope, boolean justClasses, @NotNull StubIndexKey<? super String, JSElement> indexKey, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(71);
        }
        if (scope == null) {
            JSClassResolver.$$$reportNull$$$0(72);
        }
        if (indexKey == null) {
            JSClassResolver.$$$reportNull$$$0(73);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(74);
        }
        Project project = scope.getProject();
        assert (project != null);
        if (LOG.isTraceEnabled()) {
            LOG.trace("processElementsByNameIncludingImplicit: " + name);
        }
        return StubIndexSupport.getInstance().processElements(indexKey, name, project, scope, JSElement.class, element -> {
            ProgressManager.checkCanceled();
            if (justClasses && !(element instanceof JSClass)) {
                return true;
            }
            return !(element instanceof JSPsiElementBase && name.equals(element.getName()) ? !processor.process((Object)((JSPsiElementBase)element)) : element instanceof JSImplicitElementProvider && !JSClassResolver.processImplicitElements(name, (Processor<? super JSImplicitElement>)processor, (JSImplicitElementProvider)element));
        });
    }

    public static boolean processImplicitElements(@NotNull String name, @NotNull Processor<? super JSImplicitElement> processor, @NotNull JSImplicitElementProvider element) {
        JSElementIndexingData data;
        Collection<JSImplicitElement> implicitElements;
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(75);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(76);
        }
        if (element == null) {
            JSClassResolver.$$$reportNull$$$0(77);
        }
        Collection<JSImplicitElement> collection = implicitElements = (data = element.getIndexingData()) != null ? data.getImplicitElements() : null;
        if (implicitElements != null) {
            for (JSImplicitElement implicitElement : implicitElements) {
                if (!name.equals(implicitElement.getName()) || processor.process((Object)implicitElement)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 14, 16, 19, 25, 28, 37, 45, 48, 51, 62, 67 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qname";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 47: 
            case 50: 
            case 53: 
            case 56: 
            case 64: 
            case 66: 
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 11: 
            case 46: 
            case 49: 
            case 52: 
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 25: 
            case 28: 
            case 37: 
            case 45: 
            case 48: 
            case 51: 
            case 62: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSClassResolver";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 22: 
            case 31: 
            case 34: 
            case 40: 
            case 43: 
            case 44: 
            case 54: 
            case 58: 
            case 61: 
            case 70: 
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalNsScope";
                break;
            }
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeLocalMembers";
                break;
            }
            case 63: 
            case 65: 
            case 68: 
            case 71: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSClassResolver";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesByQName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByQName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustScopeForQualifiedNameSearch";
                break;
            }
            case 19: 
            case 28: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "findNamespaceMembers";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findNamespaceMembersIncludingLocal";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceMembersProcessor";
                break;
            }
            case 48: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByQNameIncludingImplicit";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessorForQNameIncludingImplicit";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByNameIncludingImplicit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClassFromNamespace";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findClassByQName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doFindClassByQName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findClassesByQName";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 25: 
            case 28: 
            case 37: 
            case 45: 
            case 48: 
            case 51: 
            case 62: 
            case 67: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByQName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "adjustScopeForQualifiedNameSearch";
                break;
            }
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findNamespaceMembers";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processNamespaceMembers";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findNamespaceMembersIncludingLocal";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceMembersProcessor";
                break;
            }
            case 46: 
            case 47: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByQNameIncludingImplicit";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "processElementsByQNameIncludingImplicit";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getProcessorForQNameIncludingImplicit";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByNameIncludingImplicit";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "processElementsByNameIncludingImplicit";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 14, 16, 19, 25, 28, 37, 45, 48, 51, 62, 67 -> new IllegalStateException(string);
        };
    }

    public static final class IncludeLocalMembersOptions {
        public static final IncludeLocalMembersOptions ALL = new IncludeLocalMembersOptions(true, null);
        public static final IncludeLocalMembersOptions NONE = new IncludeLocalMembersOptions(false, null);
        private final boolean myIncludeLocalAll;
        @Nullable
        private final PsiFile myIncludeLocalInFile;

        private IncludeLocalMembersOptions(boolean includeLocalAll, @Nullable PsiFile includeLocalInFile) {
            this.myIncludeLocalAll = includeLocalAll;
            this.myIncludeLocalInFile = includeLocalInFile;
        }

        @NotNull
        public static IncludeLocalMembersOptions inFile(@Nullable PsiFile includeInFile) {
            IncludeLocalMembersOptions includeLocalMembersOptions = includeInFile != null ? new IncludeLocalMembersOptions(false, includeInFile) : NONE;
            if (includeLocalMembersOptions == null) {
                IncludeLocalMembersOptions.$$$reportNull$$$0(0);
            }
            return includeLocalMembersOptions;
        }

        @Nullable
        public GlobalSearchScope getScopeForGlobalSymbolIndex(@NotNull String qName, @NotNull GlobalSearchScope scope) {
            if (qName == null) {
                IncludeLocalMembersOptions.$$$reportNull$$$0(1);
            }
            if (scope == null) {
                IncludeLocalMembersOptions.$$$reportNull$$$0(2);
            }
            if (qName.contains(".")) {
                return null;
            }
            if (this.myIncludeLocalAll) {
                return null;
            }
            if (this.myIncludeLocalInFile != null) {
                return scope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)GlobalSearchScope.fileScope((PsiFile)this.myIncludeLocalInFile)));
            }
            return scope;
        }

        @Nullable
        public GlobalSearchScope getScopeForSymbolQualifiedNamesIndex(@NotNull String qName, @NotNull GlobalSearchScope scope) {
            if (qName == null) {
                IncludeLocalMembersOptions.$$$reportNull$$$0(3);
            }
            if (scope == null) {
                IncludeLocalMembersOptions.$$$reportNull$$$0(4);
            }
            if (qName.contains(".")) {
                return scope;
            }
            if (this.myIncludeLocalAll) {
                return scope;
            }
            if (this.myIncludeLocalInFile != null) {
                return GlobalSearchScope.fileScope((PsiFile)this.myIncludeLocalInFile).intersectWith(scope);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSClassResolver$IncludeLocalMembersOptions";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qName";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "inFile";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSClassResolver$IncludeLocalMembersOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getScopeForGlobalSymbolIndex";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getScopeForSymbolQualifiedNamesIndex";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

