/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.psi.util.SoftlyCachedValue;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.SystemProperties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000e*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001\u000eB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000b\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/javascript/psi/util/UpdatableCachedValue;", "T", "", "tracker", "Lcom/intellij/openapi/util/ModificationTracker;", "supplier", "Ljava/util/function/Supplier;", "<init>", "(Lcom/intellij/openapi/util/ModificationTracker;Ljava/util/function/Supplier;)V", "myRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/lang/javascript/psi/util/SoftlyCachedValue$Data;", "getUpToDate", "()Ljava/lang/Object;", "Companion", "intellij.javascript.psi.impl"})
public final class UpdatableCachedValue<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Supplier<T> supplier;
    @NotNull
    private final AtomicReference<SoftlyCachedValue.Data<T>> myRef;
    private static final int ATTEMPT_COUNT = SystemProperties.getIntProperty((String)"idea.updatable.cached.value.attempt.count", (int)100);

    public UpdatableCachedValue(@NotNull ModificationTracker tracker, @NotNull Supplier<T> supplier) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        this.supplier = supplier;
        if (Intrinsics.areEqual((Object)tracker, (Object)ModificationTracker.EVER_CHANGED)) {
            throw new IllegalArgumentException("ModificationTracker.EVER_CHANGED can't be used.");
        }
        this.myRef = new AtomicReference<SoftlyCachedValue.Data<T>>(new SoftlyCachedValue.Data<T>(this.supplier.get(), tracker));
    }

    @NotNull
    public final T getUpToDate() {
        int n = ATTEMPT_COUNT;
        int n2 = 0;
        while (n2 < n) {
            T value;
            int it = n2++;
            boolean bl = false;
            SoftlyCachedValue.Data<T> data = this.myRef.get();
            T t = value = data.getUpToDateOrNull();
            if (t != null) {
                return t;
            }
            this.myRef.compareAndSet(data, new SoftlyCachedValue.Data<T>(this.supplier.get(), data.myModificationTracker));
        }
        throw new RuntimeException("Failed to get up to date value after " + ATTEMPT_COUNT + " attempts");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/lang/javascript/psi/util/UpdatableCachedValue$Companion;", "", "<init>", "()V", "ATTEMPT_COUNT", "", "intellij.javascript.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

