/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.highlighting.components.pass;

import com.intellij.kotlin.jupyter.core.editor.highlighting.components.HighlightingComponent;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.document.MarkUpModelErrorsHighlightersTracker;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.document.topic.DocumentCellsStructureChangedListener;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.pass.HighlightingPassService;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.pass.NotebookPassConfiguration;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.pass.state.DaemonIterationState;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.pass.state.DaemonState;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.pass.state.InjectedFileData;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.pass.state.NotebookPassProgressStatus;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.pass.state.NotebookPassProgressTracker;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.queue.HighlightingEvent;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.queue.HighlightingEventsQueue;
import com.intellij.kotlin.jupyter.core.editor.highlighting.utils.RangeHighlighterUtilsKt;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.util.KotlinNotebookPluginScope;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 02\u00020\u00012\u00020\u0002:\u00010B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u001a\u0010*\u001a\u00020%2\u0006\u0010\"\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010!H\u0003J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u0010\"\u001a\u00020+H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00061"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/HighlightingPassServiceImpl;", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/HighlightingPassService;", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/HighlightingComponent;", "project", "Lcom/intellij/openapi/project/Project;", "highlightingEventsQueue", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/queue/HighlightingEventsQueue;", "notebookName", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/queue/HighlightingEventsQueue;Ljava/lang/String;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "passStatusIndicator", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/state/DaemonIterationState;", "markUpErrorsTracker", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/document/MarkUpModelErrorsHighlightersTracker;", "getMarkUpErrorsTracker$intellij_kotlin_jupyter_core", "()Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/document/MarkUpModelErrorsHighlightersTracker;", "passProgressTracker", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/state/NotebookPassProgressTracker;", "currentPassConfiguration", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/NotebookPassConfiguration;", "getCurrentPassConfiguration", "()Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/NotebookPassConfiguration;", "passState", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/state/DaemonState;", "getPassState", "()Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/state/DaemonState;", "getRangesToHighlight", "", "Lcom/intellij/openapi/util/TextRange;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "passFinished", "", "shouldHighlightErrorsInFile", "", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "processDaemonFinished", "Lcom/intellij/openapi/editor/ex/EditorEx;", "psiFile", "determineIndexesLeftToHighlight", "", "", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nHighlightingPassServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighlightingPassServiceImpl.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/HighlightingPassServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,177:1\n1625#2:178\n1869#2:179\n1870#2:181\n1626#2:182\n1#3:180\n13#4:183\n*S KotlinDebug\n*F\n+ 1 HighlightingPassServiceImpl.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/HighlightingPassServiceImpl\n*L\n83#1:178\n83#1:179\n83#1:181\n83#1:182\n83#1:180\n42#1:183\n*E\n"})
public final class HighlightingPassServiceImpl
extends HighlightingComponent
implements HighlightingPassService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final HighlightingEventsQueue highlightingEventsQueue;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final DaemonIterationState passStatusIndicator;
    @NotNull
    private final MarkUpModelErrorsHighlightersTracker markUpErrorsTracker;
    @NotNull
    private final NotebookPassProgressTracker passProgressTracker;
    @NotNull
    private static final Logger LOG;

    public HighlightingPassServiceImpl(@NotNull Project project, @NotNull HighlightingEventsQueue highlightingEventsQueue, @NotNull String notebookName2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)highlightingEventsQueue, (String)"highlightingEventsQueue");
        Intrinsics.checkNotNullParameter((Object)notebookName2, (String)"notebookName");
        this.highlightingEventsQueue = highlightingEventsQueue;
        this.coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)KotlinNotebookPluginScope.Companion.getGlobal(), (String)("HighlightingPassService for " + notebookName2), null, (boolean)false, (int)6, null);
        this.passStatusIndicator = new DaemonIterationState();
        this.markUpErrorsTracker = (MarkUpModelErrorsHighlightersTracker)this.child(HighlightingPassServiceImpl::markUpErrorsTracker$lambda$0);
        this.passProgressTracker = (NotebookPassProgressTracker)this.child(HighlightingPassServiceImpl::passProgressTracker$lambda$0);
        project.getMessageBus().connect((Disposable)this).subscribe(DocumentCellsStructureChangedListener.TOPIC, (arg_0, arg_1) -> HighlightingPassServiceImpl._init_$lambda$0(this, arg_0, arg_1));
    }

    @NotNull
    public final MarkUpModelErrorsHighlightersTracker getMarkUpErrorsTracker$intellij_kotlin_jupyter_core() {
        return this.markUpErrorsTracker;
    }

    @Override
    @NotNull
    public NotebookPassConfiguration getCurrentPassConfiguration() {
        return this.passProgressTracker.getPassConfiguration();
    }

    @Override
    @NotNull
    public DaemonState getPassState() {
        return this.passStatusIndicator.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<TextRange> getRangesToHighlight(@NotNull PsiFile file, @NotNull Editor editor) {
        List<JupyterPsiCell> list;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int caretOffSet = editor.getCaretModel().getOffset();
        NotebookCellLines.Interval cellUnderEditor = NotebookVisualizationUiUtilKt.getCell((Editor)editor, (int)editor.getDocument().getLineNumber(caretOffSet));
        int focusCellIndex = cellUnderEditor.getOrdinal();
        try {
            list = UtilKt.getNotebookCells(file);
        }
        catch (IllegalStateException illegalStateException) {
            LOG.warn("Cannot get notebook cells for file: " + file.getName());
            return CollectionsKt.emptyList();
        }
        List<JupyterPsiCell> cells = list;
        HighlightingEvent mergedEvent = this.highlightingEventsQueue.pullEvents();
        Object object = mergedEvent;
        if (object == null || (object = ((HighlightingEvent)object).getChangedCells()) == null) {
            object = CollectionsKt.emptyList();
        }
        Object changedCells = object;
        try {
            Set set;
            void destination$iv;
            void $this$mapNotNullTo$iv;
            Iterable iterable = (Iterable)changedCells;
            Collection collection = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                TextRange it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                int it = ((Number)element$iv).intValue();
                boolean bl2 = false;
                JupyterPsiCell jupyterPsiCell = (JupyterPsiCell)CollectionsKt.getOrNull(cells, (int)it);
                if ((jupyterPsiCell != null ? jupyterPsiCell.getTextRange() : null) == null) continue;
                it$iv = it$iv;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            JupyterPsiCell jupyterPsiCell = (JupyterPsiCell)CollectionsKt.getOrNull(cells, (int)focusCellIndex);
            Set targetRanges = SetsKt.plus((Set)((Set)destination$iv), (Iterable)SetsKt.setOfNotNull((Object)(jupyterPsiCell != null ? jupyterPsiCell.getTextRange() : null)));
            boolean inProgress = this.passStatusIndicator.isInProgress();
            if (!this.passStatusIndicator.enterSetupPhase() && !inProgress || inProgress) {
                LOG.debug("Another pass is in setup, aborting, state: " + this.passStatusIndicator.get() + ", changedCells: " + (Collection)changedCells);
                return targetRanges;
            }
            this.markUpErrorsTracker.resetState$intellij_kotlin_jupyter_core(focusCellIndex, false);
            Set $this$getRangesToHighlight_u24lambda_u241 = set = SetsKt.createSetBuilder();
            boolean bl = false;
            $this$getRangesToHighlight_u24lambda_u241.addAll(changedCells);
            $this$getRangesToHighlight_u24lambda_u241.add(focusCellIndex);
            Set targetIndexes = SetsKt.build((Set)set);
            this.passProgressTracker.passStarting(file, focusCellIndex, targetIndexes, cells);
            this.passStatusIndicator.enterProgressPhase();
            return targetRanges;
        }
        catch (ProcessCanceledException ex) {
            if (mergedEvent != null) {
                this.highlightingEventsQueue.pushEvent(mergedEvent);
                this.passStatusIndicator.setIdle();
            }
            throw ex;
        }
    }

    @Override
    public void passFinished(@NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(editor instanceof EditorEx) || this.passStatusIndicator.isIdle()) {
            return;
        }
        BuildersKt.async$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, editor, file, null){
            int label;
            final /* synthetic */ HighlightingPassServiceImpl this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ PsiFile $file;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$file = $file;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        HighlightingPassServiceImpl.access$processDaemonFinished(this.this$0, (EditorEx)this.$editor, this.$file);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public boolean shouldHighlightErrorsInFile(@NotNull KtFile ktFile) {
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        int focusCell = this.passProgressTracker.getPassConfiguration().getFocusCell();
        InjectedFileData cellData = this.passProgressTracker.getPassConfiguration().getFilesToHL().get(ktFile);
        if (cellData != null) {
            return cellData.getNotebookCellIndex() == focusCell;
        }
        PsiLanguageInjectionHost psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)ktFile.getProject()).getInjectionHost((PsiElement)ktFile);
        if (psiLanguageInjectionHost == null) {
            return false;
        }
        PsiLanguageInjectionHost host2 = psiLanguageInjectionHost;
        return this.passProgressTracker.getPassConfiguration().getEditorCells().indexOf(host2) == focusCell;
    }

    @RequiresBackgroundThread
    private final void processDaemonFinished(EditorEx editor, PsiFile psiFile) {
        boolean isLeft;
        NotebookPassConfiguration passConfiguration = this.passProgressTracker.getPassConfiguration();
        if (this.passStatusIndicator.isIdle()) {
            return;
        }
        this.passStatusIndicator.setIdle();
        this.markUpErrorsTracker.removeHighlightersOutSideOfFocus$intellij_kotlin_jupyter_core(passConfiguration.getFocusCell());
        Set<Integer> remaining = this.determineIndexesLeftToHighlight(editor);
        Set finishedFiles = SetsKt.minus(passConfiguration.getCellIndexesToHighlight(), (Iterable)remaining);
        Project project = editor.getProject();
        if (project == null) {
            LOG.info("Project is null for editor " + editor + " in file: " + psiFile);
            return;
        }
        boolean bl = isLeft = !((Collection)remaining).isEmpty();
        if (isLeft) {
            HighlightingEvent event = new HighlightingEvent(passConfiguration.getFocusCell(), null, (Collection<Integer>)remaining, true);
            this.highlightingEventsQueue.pushEvent(event);
        }
        LOG.debug("Reducing queue by " + finishedFiles + ", left: " + remaining);
    }

    private final Set<Integer> determineIndexesLeftToHighlight(EditorEx editor) {
        NotebookPassProgressStatus passRemains = this.passProgressTracker.getStatusAfterPassFinished(editor);
        RangeHighlighterUtilsKt.disposeOfHighlighters(passRemains.getErrorHighlightersOutsideOfFocus());
        return passRemains.getIndexesLeftToProcess();
    }

    private static final MarkUpModelErrorsHighlightersTracker markUpErrorsTracker$lambda$0() {
        return new MarkUpModelErrorsHighlightersTracker();
    }

    private static final NotebookPassProgressTracker passProgressTracker$lambda$0() {
        return new NotebookPassProgressTracker();
    }

    private static final void _init_$lambda$0(HighlightingPassServiceImpl this$0, Editor editor, int affectedCellIndex) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this$0.markUpErrorsTracker.clear();
    }

    public static final /* synthetic */ void access$processDaemonFinished(HighlightingPassServiceImpl $this, EditorEx editor, PsiFile psiFile) {
        $this.processDaemonFinished(editor, psiFile);
    }

    static {
        Companion $this$notebookLogger$iv = Companion = new Companion(null);
        boolean $i$f$notebookLogger = false;
        LOG = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.class));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/HighlightingPassServiceImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

